/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CadicalStats;
import savilerow.CmdFlags;
import savilerow.Model;
import savilerow.Pair;
import savilerow.ReadProcessOutput;
import savilerow.RunCommand;
import savilerow.SATSolver;
import savilerow.Stats;

public class CadicalSATSolver
extends SATSolver {
    public CadicalSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        boolean bl = CmdFlags.getSatFamily().equals("kissat");
        try {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            ArrayList<String> arrayList2 = new ArrayList<String>(CmdFlags.getSolverExtraFlags());
            if (stats != null && (n = this.parseTimeLimit(arrayList2, bl)) != -1) {
                int n2 = n - (int)Math.floor(Double.valueOf(stats.getValue("SolverTotalTime"))) + 1;
                if (n2 > n) {
                    n2 = n;
                }
                if (n2 < 1) {
                    n2 = 1;
                }
                this.setTimeLimit(arrayList2, bl, n2);
            }
            arrayList.addAll(arrayList2);
            arrayList.add(string2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList4);
            double d = System.currentTimeMillis();
            int n3 = RunCommand.runCommand(true, arrayList, arrayList3, readProcessOutput);
            d = ((double)System.currentTimeMillis() - d) / 1000.0;
            CadicalStats cadicalStats = new CadicalStats(arrayList4);
            if (n3 == 10) {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                for (int i = 0; i < arrayList4.size(); ++i) {
                    if (!arrayList4.get(i).startsWith("v ")) continue;
                    String[] stringArray = arrayList4.get(i).trim().split(" ");
                    for (int j = 1; j < stringArray.length; ++j) {
                        arrayList5.add(stringArray[j]);
                    }
                }
                return new Pair<ArrayList<String>, Stats>(arrayList5, cadicalStats);
            }
            if (n3 == 20) {
                return new Pair<Object, CadicalStats>(null, cadicalStats);
            }
            if (arrayList3.size() != 0 || n3 != 10 && n3 != 20) {
                CmdFlags.println("SAT solver exited with error code:" + n3 + " and message:");
                CmdFlags.println(arrayList3);
                int n4 = this.parseTimeLimit(arrayList2, bl);
                if (n4 != -1 && d > (double)n4) {
                    cadicalStats.putValue("SolverTimeOut", "1");
                }
            }
            return new Pair<Object, CadicalStats>(null, cadicalStats);
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
    }

    int parseTimeLimit(ArrayList<String> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!bl && arrayList.get(i).equals("-t")) {
                return Integer.parseInt(arrayList.get(i + 1));
            }
            if (!bl || !arrayList.get(i).contains("--time=")) continue;
            return Integer.parseInt(arrayList.get(i).split("=")[1]);
        }
        return -1;
    }

    void setTimeLimit(ArrayList<String> arrayList, boolean bl, int n) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!bl && arrayList.get(i).equals("-t")) {
                arrayList.set(i + 1, String.valueOf(n));
                return;
            }
            if (!bl || !arrayList.get(i).contains("--time=")) continue;
            arrayList.set(i, "--time=" + n);
            return;
        }
    }
}

