/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.Identifier;
import savilerow.SymbolTable;

public class Cat
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Cat(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public Cat(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    @Override
    public ASTNode copy() {
        return new Cat(this.getChildrenArray());
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        int n = 1;
        if (this.numChildren() > 0) {
            n = this.getChild(0).getDimension();
        }
        if (n < 1) {
            System.out.println("ERROR: Expected 1-dimensional or greater matrix inside concatenate: " + this);
            return false;
        }
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() == n) continue;
            System.out.println("ERROR: Dimensions of matrices in cat function do not match: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i) instanceof CompoundMatrix || this.getChild(i) instanceof EmptyMatrix || this.getChild(i) instanceof Identifier && this.getChild(i).getCategory() == 0) continue;
            return null;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            ASTNode aSTNode = this.getChildConst(i);
            if (this.getChild(i) == aSTNode) {
                aSTNode.detachChildren();
            }
            arrayList.addAll(aSTNode.getChildren(1));
        }
        return CompoundMatrix.make(arrayList);
    }

    @Override
    public int getDimension() {
        if (this.numChildren() == 0) {
            return 1;
        }
        return this.getChild(0).getDimension();
    }

    @Override
    public boolean isRelation() {
        boolean bl = true;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).isRelation()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isNumerical() {
        return !this.isRelation();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cat(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i));
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

