/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.Intpair;
import savilerow.Length;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.SymbolTable;

public class Count
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Count(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Count(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public Intpair getBounds() {
        if (this.getChild(0) instanceof CompoundMatrix) {
            return new Intpair(0L, this.getChild(0).numChildren() - 1);
        }
        return new Intpair(0L, Long.MAX_VALUE);
    }

    public PairASTNode getBoundsAST() {
        return new PairASTNode(NumberConstant.make(0L), new Length(this.getChild(0)));
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof EmptyMatrix) {
            return NumberConstant.make(0L);
        }
        if (aSTNode instanceof CompoundMatrix && this.getChild(1).isConstant()) {
            int n;
            long l = this.getChild(1).getValue();
            boolean bl = true;
            long l2 = 0L;
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            for (n = 1; n < aSTNode.numChildren(); ++n) {
                ASTNode aSTNode2 = aSTNode.getChild(n);
                if (aSTNode2.isConstant()) {
                    if (aSTNode2.getValue() != l) continue;
                    arrayList.add(aSTNode2);
                    ++l2;
                    continue;
                }
                bl = false;
                arrayList.add(aSTNode2);
            }
            if (bl) {
                return NumberConstant.make(l2);
            }
            if (arrayList.size() < aSTNode.numChildren() - 1) {
                if (aSTNode == this.getChild(0)) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        arrayList.get(n).setParent(null);
                    }
                }
                return new Count(CompoundMatrix.make(arrayList), this.getChild(1));
            }
        }
        return null;
    }

    @Override
    public ASTNode normalise() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        boolean bl = Count.sortByHashcode(arrayList);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            this.getChild(1).setParent(null);
            return new Count((ASTNode)new CompoundMatrix(arrayList), this.getChild(1));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return null;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        boolean bl = Count.sortByAlpha(arrayList);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setParent(null);
            }
            this.getChild(1).setParent(null);
            return new Count((ASTNode)new CompoundMatrix(arrayList), this.getChild(1));
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            System.out.println("ERROR: Count function must contain 1-dimensional matrix: " + this);
            return false;
        }
        if (this.getChild(1).getDimension() != 0) {
            System.out.println("ERROR: Found matrix, expected single expression in second argument of Count function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("occurrence(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(",");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint count(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public String toString() {
        return "count(" + this.getChild(0) + "," + this.getChild(1) + ")";
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("count(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }
}

