/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import savilerow.InteractiveGlucoseStats;
import savilerow.InteractiveSATSolver;
import savilerow.Model;
import savilerow.Pair;
import savilerow.Stats;

public class InteractiveGlucoseSATSolver
extends InteractiveSATSolver {
    private long nativeSolverPointer;
    private ArrayList<String> lastSolution;

    public InteractiveGlucoseSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) {
        this.finaliseAssumptions();
        InteractiveGlucoseSATSolver.addAssumptionsToSolver(this.nativeSolverPointer, Arrays.stream(this.assumptions).mapToInt(l -> (int)l).toArray());
        double d = System.currentTimeMillis();
        long l2 = InteractiveGlucoseSATSolver.runSolver(this.nativeSolverPointer, this, model.satModel.variableNumber - 1L);
        d = ((double)System.currentTimeMillis() - d) / 1000.0;
        double[] dArray = new double[]{d, InteractiveGlucoseSATSolver.getSolverStats(this.nativeSolverPointer)};
        InteractiveGlucoseStats interactiveGlucoseStats = new InteractiveGlucoseStats(l2 == 0L, dArray);
        interactiveGlucoseStats.setNbLearnts(this.getNbLearntClausesFromISATSolver());
        if (model.objective != null) {
            this.cleanAssumptionQueue();
        }
        return new Pair<ArrayList<String>, Stats>(l2 == 0L ? this.lastSolution : null, interactiveGlucoseStats);
    }

    private static native long initSolver();

    private static native long addClauseToSolver(long var0, int[] var2);

    private static native long addAssumptionsToSolver(long var0, int[] var2);

    private static native long runSolver(long var0, InteractiveSATSolver var2, long var3);

    private static native long getSolverStats(long var0);

    private static native long setRndSeed(long var0, long var2);

    private static native long getNbLearntClauses(long var0);

    @Override
    protected void initISATSolver() {
        this.nativeSolverPointer = InteractiveGlucoseSATSolver.initSolver();
        assert (this.nativeSolverPointer != 0L);
    }

    @Override
    public void setRndSeedToISATSolver(long l) {
        InteractiveGlucoseSATSolver.setRndSeed(this.nativeSolverPointer, l);
    }

    @Override
    public void addClauseToISATSolver(long[] lArray) {
        InteractiveGlucoseSATSolver.addClauseToSolver(this.nativeSolverPointer, Arrays.stream(lArray).mapToInt(l -> (int)l).toArray());
    }

    @Override
    public long getNbLearntClausesFromISATSolver() {
        return InteractiveGlucoseSATSolver.getNbLearntClauses(this.nativeSolverPointer);
    }

    @Override
    protected void handleFreshSolution(int[] nArray) {
        this.lastSolution = Arrays.stream(nArray).mapToObj(Integer::toString).collect(Collectors.toCollection(ArrayList::new));
    }

    static {
        System.loadLibrary("rust_jni_solvers");
    }
}

