/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import savilerow.ASTNode;
import savilerow.AllDifferent;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CompoundMatrix;
import savilerow.Equals;
import savilerow.Identifier;
import savilerow.InSet;
import savilerow.Intpair;
import savilerow.Less;
import savilerow.LessEqual;
import savilerow.Model;
import savilerow.MultiplyMapper;
import savilerow.NumberConstant;
import savilerow.ShiftMapper;
import savilerow.SymbolTable;
import savilerow.Times;
import savilerow.TransformMIPOutput;
import savilerow.WeightedSum;
import savilerow.categoryentry;

public class MIP {
    Model m;
    SymbolTable gs;
    HashSet<String> vars01 = new HashSet();
    HashSet<String> varsint = new HashSet();
    HashMap<String, HashMap<Long, String>> varTo01 = new HashMap();

    public MIP(Model model) {
        this.m = model;
        this.gs = model.global_symbols;
    }

    public void process() {
        this.collect01();
        ArrayList<ASTNode> arrayList = this.generate01Vars();
        arrayList.addAll(this.generateDomainConstraints());
        this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), new And(arrayList)));
        this.replace01();
    }

    public void collect01() {
        ArrayDeque<ASTNode> arrayDeque = new ArrayDeque<ASTNode>();
        arrayDeque.add(this.m.constraints.getChild(0));
        while (!arrayDeque.isEmpty()) {
            ASTNode aSTNode = (ASTNode)arrayDeque.poll();
            if (aSTNode instanceof Identifier) {
                this.varsint.add(aSTNode.toString());
                if (!aSTNode.isRelation()) {
                    Intpair intpair = aSTNode.getBounds();
                    if (intpair.lower < 0L || intpair.upper > 1L) {
                        ASTNode aSTNode2 = aSTNode;
                        while (aSTNode2.getParent() instanceof MultiplyMapper || aSTNode2.getParent() instanceof ShiftMapper || aSTNode2.getParent() instanceof CompoundMatrix) {
                            aSTNode2 = aSTNode2.getParent();
                        }
                        ASTNode aSTNode3 = aSTNode2.getParent();
                        if ((aSTNode3 instanceof Equals || aSTNode3 instanceof LessEqual || aSTNode3 instanceof Less) && (aSTNode3.getChild(0).isConstant() || aSTNode3.getChild(1).isConstant()) || aSTNode3 instanceof AllDifferent && aSTNode3.getChild(0).numChildren() == 3 && (aSTNode3.getChild(0).getChild(1).isConstant() || aSTNode3.getChild(0).getChild(2).isConstant()) || aSTNode3 instanceof InSet) {
                            this.vars01.add(aSTNode.toString());
                        }
                    }
                }
            }
            arrayDeque.addAll(aSTNode.getChildren());
        }
    }

    public ArrayList<ASTNode> generate01Vars() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        categoryentry categoryentry2 = this.gs.category_first;
        while (categoryentry2 != null) {
            if (this.vars01.contains(categoryentry2.name)) {
                HashMap<Long, String> hashMap = new HashMap<Long, String>();
                this.varTo01.put(categoryentry2.name, hashMap);
                ArrayList<Intpair> arrayList2 = this.gs.getDomain(categoryentry2.name).getIntervalSet();
                ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                ArrayList<Long> arrayList4 = new ArrayList<Long>();
                ArrayList<ASTNode> arrayList5 = new ArrayList<ASTNode>();
                ArrayList<Long> arrayList6 = new ArrayList<Long>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    for (long j = arrayList2.get((int)i).lower; j <= arrayList2.get((int)i).upper; ++j) {
                        Identifier identifier = this.gs.newAuxiliaryVariable(0L, 1L);
                        hashMap.put(j, ((ASTNode)identifier).toString());
                        arrayList3.add(identifier);
                        arrayList4.add(1L);
                        arrayList5.add(identifier);
                        arrayList6.add(j);
                    }
                }
                arrayList.add(new Equals((ASTNode)new WeightedSum(arrayList3, arrayList4), NumberConstant.make(1L)));
                arrayList5.add(new Identifier(this.m, categoryentry2.name));
                arrayList6.add(-1L);
                arrayList.add(new Equals((ASTNode)new WeightedSum(arrayList5, arrayList6), NumberConstant.make(0L)));
            }
            categoryentry2 = categoryentry2.next;
        }
        return arrayList;
    }

    public ArrayList<ASTNode> generateDomainConstraints() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        categoryentry categoryentry2 = this.gs.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                ArrayList<Intpair> arrayList2 = this.gs.getDomain(categoryentry2.name).getIntervalSet();
                if (!this.vars01.contains(categoryentry2.name) && arrayList2.size() > 1) {
                    int n;
                    ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                    ArrayList<Long> arrayList4 = new ArrayList<Long>();
                    for (n = 0; n < arrayList2.size(); ++n) {
                        Identifier identifier = this.gs.newAuxiliaryVariable(0L, 1L);
                        arrayList3.add(identifier);
                        arrayList4.add(1L);
                    }
                    arrayList.add(new Equals((ASTNode)new WeightedSum(arrayList3, arrayList4), NumberConstant.make(1L)));
                    for (n = 0; n < arrayList2.size(); ++n) {
                        if (n > 0) {
                            arrayList.add(this.implyIneq(arrayList3.get(n), new Times((ASTNode)new Identifier(this.m, categoryentry2.name), NumberConstant.make(-1L)), -arrayList2.get((int)n).lower));
                        }
                        if (n >= arrayList2.size() - 1) continue;
                        arrayList.add(this.implyIneq(arrayList3.get(n), new Identifier(this.m, categoryentry2.name), arrayList2.get((int)n).upper));
                    }
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        return arrayList;
    }

    public void replace01() {
        TransformMIPOutput transformMIPOutput = new TransformMIPOutput(this);
        this.m.constraints = transformMIPOutput.transform(this.m.constraints);
    }

    public ASTNode implyIneq(ASTNode aSTNode, ASTNode aSTNode2, long l) {
        System.out.println("implyineq: " + aSTNode + ", " + aSTNode2 + ", " + l);
        Intpair intpair = aSTNode2.getBounds();
        if (intpair.upper <= l) {
            return new BooleanConstant(true);
        }
        long l2 = intpair.upper - l;
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        arrayList.add(aSTNode2);
        arrayList.add(aSTNode);
        arrayList2.add(1L);
        arrayList2.add(l2);
        LessEqual lessEqual = new LessEqual((ASTNode)new WeightedSum(arrayList, arrayList2), NumberConstant.make(l + l2));
        System.out.println(lessEqual);
        return lessEqual;
    }

    public ASTNode diseq(ASTNode aSTNode, ASTNode aSTNode2) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        arrayList.add(NumberConstant.make(1L));
        arrayList.add(aSTNode2);
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        arrayList2.add(1L);
        arrayList2.add(1L);
        arrayList2.add(-1L);
        WeightedSum weightedSum = new WeightedSum(arrayList, arrayList2);
        arrayList.clear();
        arrayList.add(aSTNode2);
        arrayList.add(NumberConstant.make(1L));
        arrayList.add(aSTNode);
        WeightedSum weightedSum2 = new WeightedSum(arrayList, arrayList2);
        return this.disjunction2(weightedSum, 0L, weightedSum2, 0L);
    }

    public ASTNode diseq(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        ASTNode aSTNode4 = this.diseq(aSTNode, aSTNode2);
        aSTNode4.setChild(0, this.implyIneq(aSTNode3, aSTNode4.getChild(0).getChild(0), aSTNode4.getChild(0).getChild(1).getValue()));
        aSTNode4.setChild(1, this.implyIneq(aSTNode3, aSTNode4.getChild(1).getChild(0), aSTNode4.getChild(1).getChild(1).getValue()));
        return aSTNode4;
    }

    public ASTNode equal(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        arrayList.add(aSTNode2);
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        arrayList2.add(1L);
        arrayList2.add(-1L);
        WeightedSum weightedSum = new WeightedSum(arrayList, arrayList2);
        ASTNode aSTNode4 = this.implyIneq(aSTNode3, weightedSum, 0L);
        arrayList2.clear();
        arrayList2.add(-1L);
        arrayList2.add(1L);
        WeightedSum weightedSum2 = new WeightedSum(arrayList, arrayList2);
        ASTNode aSTNode5 = this.implyIneq(aSTNode3, weightedSum2, 0L);
        return new And(aSTNode4, aSTNode5);
    }

    public ASTNode disjunction2(ASTNode aSTNode, long l, ASTNode aSTNode2, long l2) {
        Identifier identifier = this.gs.newAuxiliaryVariable(0L, 1L);
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(identifier);
        arrayList.add(NumberConstant.make(1L));
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        arrayList2.add(-1L);
        arrayList2.add(1L);
        WeightedSum weightedSum = new WeightedSum(arrayList, arrayList2);
        ASTNode aSTNode3 = this.implyIneq(identifier, aSTNode, l);
        ASTNode aSTNode4 = this.implyIneq(weightedSum, aSTNode2, l2);
        return new And(aSTNode3, aSTNode4);
    }

    public ASTNode negate(ASTNode aSTNode) {
        return new WeightedSum(new ASTNode[]{NumberConstant.make(1L), aSTNode}, new long[]{1L, -1L});
    }

    public ASTNode inset(ASTNode aSTNode, ASTNode aSTNode2, ArrayList<Intpair> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                arrayList2.add(this.get01var(aSTNode2, j));
            }
        }
        if (aSTNode.getParent().inTopAnd()) {
            return new LessEqual((ASTNode)NumberConstant.make(1L), new WeightedSum(arrayList2));
        }
        return new WeightedSum(arrayList2);
    }

    public ASTNode stripMappers(ASTNode aSTNode) {
        while (aSTNode instanceof MultiplyMapper || aSTNode instanceof ShiftMapper) {
            aSTNode = aSTNode.getChild(0);
        }
        return aSTNode;
    }

    public ASTNode get01var(ASTNode aSTNode, long l) {
        while (aSTNode instanceof MultiplyMapper || aSTNode instanceof ShiftMapper) {
            if (aSTNode instanceof MultiplyMapper) {
                long l2 = aSTNode.getChild(1).getValue();
                if (l % l2 != 0L) {
                    return new BooleanConstant(false);
                }
                l /= l2;
            } else {
                l -= aSTNode.getChild(1).getValue();
            }
            aSTNode = aSTNode.getChild(0);
        }
        assert (aSTNode instanceof Identifier);
        String string = this.varTo01.get(aSTNode.toString()).get(l);
        assert (string != null);
        return new Identifier(this.m, string);
    }

    public static void toMIPBounds(BufferedWriter bufferedWriter, Model model) throws IOException {
        categoryentry categoryentry2 = model.global_symbols.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                Intpair intpair = model.global_symbols.getDomain(categoryentry2.name).getBounds();
                if (intpair.lower != 0L || intpair.upper != 1L) {
                    bufferedWriter.append(String.valueOf(intpair.lower));
                    bufferedWriter.append(" <= ");
                    bufferedWriter.append(categoryentry2.name);
                    bufferedWriter.append(" <= ");
                    bufferedWriter.append(String.valueOf(intpair.upper));
                    bufferedWriter.append("\n");
                }
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public static void toMIPGenerals(BufferedWriter bufferedWriter, Model model) throws IOException {
        categoryentry categoryentry2 = model.global_symbols.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                Intpair intpair = model.global_symbols.getDomain(categoryentry2.name).getBounds();
                if (intpair.lower != 0L || intpair.upper != 1L) {
                    bufferedWriter.append(categoryentry2.name);
                    bufferedWriter.append(" ");
                }
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public static void toMIPBinary(BufferedWriter bufferedWriter, Model model) throws IOException {
        categoryentry categoryentry2 = model.global_symbols.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                Intpair intpair = model.global_symbols.getDomain(categoryentry2.name).getBounds();
                if (intpair.lower == 0L && intpair.upper == 1L) {
                    bufferedWriter.append(categoryentry2.name);
                    bufferedWriter.append(" ");
                }
            }
            categoryentry2 = categoryentry2.next;
        }
    }
}

