/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CmdFlags;
import savilerow.Intpair;
import savilerow.NegInfinity;
import savilerow.NumberConstant;
import savilerow.SymbolTable;

public class Min
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Min(ArrayList<ASTNode> arrayList) {
        super(arrayList);
        assert (arrayList.size() >= 1);
    }

    public Min(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
        assert (aSTNodeArray.length >= 1);
    }

    public Min(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Min(this.getChildren());
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public ASTNode simplify() {
        int n;
        int n2;
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = false;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (!(arrayList.get(n2) instanceof Min)) continue;
            arrayList.addAll(arrayList.get(n2).getChildren());
            arrayList.remove(n2);
            --n2;
            bl = true;
        }
        n2 = 0;
        long l = Long.MAX_VALUE;
        for (n = 0; n < arrayList.size(); ++n) {
            long l2;
            if (arrayList.get(n) instanceof NegInfinity) {
                return arrayList.get(n);
            }
            if (!arrayList.get(n).isConstant()) continue;
            if (n2 != 0) {
                bl = true;
            }
            l = l < (l2 = arrayList.get(n).getValue()) ? l : l2;
            arrayList.remove(n);
            --n;
            n2 = 1;
        }
        if (n2 != 0) {
            arrayList.add(NumberConstant.make(l));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                if (!arrayList.get(n).equals(arrayList.get(i))) continue;
                arrayList.remove(i);
                --i;
                bl = true;
            }
        }
        if (arrayList.size() == 1) {
            arrayList.get(0).setParent(null);
            return arrayList.get(0);
        }
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList.get(n).setParent(null);
            }
            return new Min(arrayList);
        }
        return null;
    }

    @Override
    public int polarity(int n) {
        return this.polarity();
    }

    @Override
    public ASTNode normalise() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Min.sortByHashcode(arrayList);
        if (bl) {
            this.detachChildren();
            return new Min(arrayList);
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Min.sortByAlpha(arrayList);
        if (bl) {
            this.detachChildren();
            return new Min(arrayList);
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() <= 0) continue;
            CmdFlags.println("ERROR: Unexpected matrix in min: " + this);
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        long l = intpair.lower;
        long l2 = intpair.upper;
        for (int i = 1; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            if (intpair2.lower < l) {
                l = intpair2.lower;
            }
            if (intpair2.upper >= l2) continue;
            l2 = intpair2.upper;
        }
        intpair.lower = l;
        intpair.upper = l2;
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        for (int i = 1; i < this.numChildren(); ++i) {
            arrayList = Intpair.union(arrayList, this.getChild(i).getIntervalSetExp());
        }
        ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>(1);
        arrayList2.add(this.getBounds());
        return Intpair.intersection(arrayList, arrayList2);
    }

    @Override
    public String toString() {
        return this.generic_to_string("min");
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("min([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(bufferedWriter, false);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("],");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        assert (this.numChildren() == 2);
        bufferedWriter.append("constraint int_min(");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(bufferedWriter, false);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append(",");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("min([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, bl);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

