/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import savilerow.ASTNode;
import savilerow.NumberConstantByte;
import savilerow.NumberConstantInt;
import savilerow.NumberConstantLong;

public abstract class NumberConstant
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public static NumberConstant make(long l) {
        if (l >= -128L && l <= 127L) {
            return new NumberConstantByte((byte)l);
        }
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return new NumberConstantInt((int)l);
        }
        return new NumberConstantLong(l);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean usesSMTEncoding() {
        return true;
    }

    @Override
    public boolean canVariableEncode() {
        return true;
    }
}

