/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.Identifier;
import savilerow.Intpair;
import savilerow.NegInfinity;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.PosInfinity;
import savilerow.SymbolTable;
import savilerow.WeightedSum;

public class SumVector
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public SumVector(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new SumVector(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in sum function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof Identifier && this.getChild(0).getCategory() == 0) {
            ASTNode aSTNode = this.getChildConst(0);
            long l = 0L;
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                l += aSTNode.getChild(i).getValue();
            }
            return NumberConstant.make(l);
        }
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            ASTNode[] aSTNodeArray = this.getChild(0).getChildrenArray(1);
            for (int i = 0; i < aSTNodeArray.length; ++i) {
                aSTNodeArray[i].setParent(null);
            }
            return new WeightedSum(aSTNodeArray);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PairASTNode getBoundsAST() {
        return new PairASTNode(new NegInfinity(), new PosInfinity());
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public String toString() {
        return "sum(" + this.getChild(0) + ")";
    }
}

