/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.Model;
import savilerow.SATSolver;

public abstract class InteractiveSATSolver
extends SATSolver {
    protected ArrayList<Long> assumptionQueue;
    protected long[] assumptions;

    public InteractiveSATSolver(Model model) {
        super(model);
        this.initISATSolver();
        this.assumptions = null;
        this.assumptionQueue = new ArrayList();
    }

    protected abstract void initISATSolver();

    public abstract void setRndSeedToISATSolver(long var1);

    public abstract void addClauseToISATSolver(long[] var1);

    protected abstract void handleFreshSolution(int[] var1);

    public abstract long getNbLearntClausesFromISATSolver();

    public void cleanAssumptionQueue() {
        this.assumptionQueue.clear();
    }

    public void addToAssumptionQueue(long l) {
        this.assumptionQueue.add(l);
    }

    protected void finaliseAssumptions() {
        this.assumptions = this.assumptionQueue.stream().mapToLong(l -> l).toArray();
    }

    @Override
    public void findOneSolution(String string, String string2, Model model) {
        super.findOneSolution(string, string2, model);
        this.cleanAssumptionQueue();
    }

    @Override
    public void findMultipleSolutions(String string, String string2, Model model) {
        super.findMultipleSolutions(string, string2, model);
        this.cleanAssumptionQueue();
    }
}

