/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.Pair;

public class MDD {
    public static final long serialVersionUID = 1L;
    int id;
    ArrayList<Long> selectors;
    ArrayList<MDD> children;
    MDD elsechild;
    boolean istrivialtrue;
    boolean istrivialfalse;
    int vardepth;
    int realdepth;
    static MDD mddtrue;
    static MDD mddfalse;

    private MDD(boolean bl) {
        this.id = bl ? 1 : 0;
        this.istrivialtrue = bl;
        this.istrivialfalse = !bl;
        this.vardepth = 1;
        this.realdepth = 1;
        this.selectors = new ArrayList();
        this.children = new ArrayList();
    }

    public MDD(int n, int n2) {
        this.id = n;
        this.istrivialtrue = false;
        this.istrivialfalse = false;
        this.vardepth = n2 + 1;
        this.realdepth = 0;
        this.selectors = new ArrayList();
        this.children = new ArrayList();
    }

    public static MDD MDDFalse() {
        if (mddfalse == null) {
            mddfalse = new MDD(false);
        }
        return mddfalse;
    }

    public static MDD MDDTrue() {
        if (mddtrue == null) {
            mddtrue = new MDD(true);
        }
        return mddtrue;
    }

    public ArrayList<Long> getSelectors() {
        return this.selectors;
    }

    public MDD getChildByIdx(int n) {
        return this.children.get(n);
    }

    public MDD getChild(long l) {
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (this.selectors.get(i) != l) continue;
            return this.children.get(i);
        }
        return null;
    }

    public MDD getElseChild() {
        return this.elsechild;
    }

    public int getId() {
        return this.id;
    }

    public int getVarDepth() {
        return this.vardepth;
    }

    public int getRealDepth() {
        return this.realdepth;
    }

    public int getSize() {
        if (this.isLeafMDD()) {
            return 1;
        }
        return this.getSize(new boolean[this.id + 1]);
    }

    private int getSize(boolean[] blArray) {
        if (!blArray[this.id]) {
            blArray[this.id] = true;
            int n = 1;
            if (!this.isLeafMDD()) {
                for (int i = 0; i < this.children.size(); ++i) {
                    n += this.children.get(i).getSize(blArray);
                }
                n += this.elsechild.getSize(blArray);
            }
            return n;
        }
        return 0;
    }

    public int getIdBasedSize() {
        return this.isLeafMDD() ? 1 : this.id + 1;
    }

    public int getNBinClauses() {
        return this.isLeafMDD() ? 0 : this.getSize() - 2;
    }

    public int getNSelectors() {
        return this.selectors.size();
    }

    public boolean isLeafMDD() {
        return this.istrivialtrue || this.istrivialfalse;
    }

    public boolean isTrueMDD() {
        return this.istrivialtrue;
    }

    public boolean isFalseMDD() {
        return this.istrivialfalse;
    }

    public Pair<Long, MDD> getSelectorAndChild(int n) {
        return new Pair<Long, MDD>(this.selectors.get(n), this.children.get(n));
    }

    public void addChild(long l, MDD mDD) {
        this.children.add(mDD);
        this.selectors.add(l);
        if (mDD.realdepth >= this.realdepth) {
            this.realdepth = mDD.realdepth + 1;
        }
    }

    public void setElseChild(MDD mDD) {
        this.elsechild = mDD;
        if (mDD.realdepth >= this.realdepth) {
            this.realdepth = mDD.realdepth + 1;
        }
    }
}

