/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import savilerow.ASTNode;
import savilerow.Intpair;
import savilerow.Pair;
import savilerow.Sat;

public class MDDUtils {
    public static void MDDEncode(ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, Sat sat) throws IOException {
        Pair<MDDNode, ArrayList<MDDNode>> pair = MDDUtils.constructMDD(arrayList2);
        MDDUtils.encodeMDDSAT(sat, arrayList, pair.getFirst(), pair.getSecond());
    }

    public static Pair<MDDNode, ArrayList<MDDNode>> constructMDD(ArrayList<ASTNode> arrayList) {
        int n;
        ArrayList<MDDNode> arrayList2 = new ArrayList<MDDNode>();
        MDDNode mDDNode = new MDDNode(null);
        arrayList2.add(mDDNode);
        int n2 = arrayList.get(0).getTupleLength();
        long[] lArray = new long[n2];
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = 0; i < n2; ++i) {
                lArray[i] = arrayList.get(n).getValueIdx(i + 1);
            }
            MDDNode mDDNode2 = mDDNode;
            for (int i = 0; i < n2; ++i) {
                int n3 = Collections.binarySearch(mDDNode2.values, lArray[i]);
                if (n3 < 0) {
                    MDDNode mDDNode3 = new MDDNode(mDDNode2);
                    if (i == n2 - 1) {
                        mDDNode3.type = (byte)-1;
                    }
                    arrayList2.add(mDDNode3);
                    MDDUtils.mklink(mDDNode2, mDDNode3, lArray[i], n3);
                    mDDNode2 = mDDNode3;
                    continue;
                }
                mDDNode2 = mDDNode2.links.get(n3);
            }
            assert (mDDNode2.type == -1);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            ((MDDNode)arrayList2.get((int)n)).id = n;
        }
        MDDUtils.compress_from_leaves(arrayList2, mDDNode, n2);
        return new Pair<MDDNode, ArrayList<MDDNode>>(mDDNode, arrayList2);
    }

    private static void mklink(MDDNode mDDNode, MDDNode mDDNode2, long l, int n) {
        mDDNode.values.add(-(n + 1), l);
        mDDNode.links.add(-(n + 1), mDDNode2);
    }

    private static void compress_from_leaves(ArrayList<MDDNode> arrayList, MDDNode mDDNode, int n) {
        int n2;
        for (n2 = n; n2 >= 0; --n2) {
            ArrayList<MDDNode> arrayList2 = new ArrayList<MDDNode>();
            MDDUtils.find_layer(0, n2, mDDNode, arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                for (int j = i + 1; j < arrayList2.size(); ++j) {
                    boolean bl = true;
                    MDDNode mDDNode2 = arrayList2.get(i);
                    MDDNode mDDNode3 = arrayList2.get(j);
                    if (mDDNode2.type != mDDNode3.type) {
                        bl = false;
                    }
                    if (mDDNode2.links.size() != mDDNode3.links.size()) {
                        bl = false;
                    }
                    for (int k = 0; k < mDDNode2.links.size() && bl; ++k) {
                        if (mDDNode2.links.get(k) == mDDNode3.links.get(k) && mDDNode2.values.get(k) == mDDNode3.values.get(k)) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    MDDNode mDDNode4 = arrayList2.get(j);
                    arrayList2.set(j, arrayList2.get(arrayList2.size() - 1));
                    arrayList2.remove(arrayList2.size() - 1);
                    --j;
                    arrayList.set(mDDNode4.id, arrayList.get(arrayList.size() - 1));
                    arrayList.remove(arrayList.size() - 1);
                    if (mDDNode4.id != arrayList.size()) {
                        arrayList.get((int)mDDNode4.id).id = mDDNode4.id;
                    }
                    ArrayList<MDDNode> arrayList3 = mDDNode4.parent.links;
                    for (int k = 0; k < arrayList3.size(); ++k) {
                        if (arrayList3.get(k) != mDDNode4) continue;
                        mDDNode4.parent.links.set(k, arrayList2.get(i));
                    }
                }
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            assert (arrayList.get((int)n2).id == n2);
        }
    }

    private static void find_layer(int n, int n2, MDDNode mDDNode, ArrayList<MDDNode> arrayList) {
        if (n < n2) {
            for (int i = 0; i < mDDNode.links.size(); ++i) {
                MDDUtils.find_layer(n + 1, n2, mDDNode.links.get(i), arrayList);
            }
        } else {
            assert (n == n2);
            arrayList.add(mDDNode);
        }
    }

    public static void encodeMDDSAT(Sat sat, ArrayList<ASTNode> arrayList, MDDNode mDDNode, ArrayList<MDDNode> arrayList2) throws IOException {
        int n;
        long[] lArray = new long[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            lArray[n] = sat.createAuxSATVariable();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ASTNode aSTNode = arrayList.get(n);
            ArrayList<Intpair> arrayList3 = aSTNode.getIntervalSetExp();
            ArrayList<MDDNode> arrayList4 = new ArrayList<MDDNode>();
            MDDUtils.find_layer(0, n, mDDNode, arrayList4);
            HashSet<Long> hashSet = new HashSet<Long>();
            for (int i = 0; i < arrayList4.size(); ++i) {
                int n2;
                MDDNode mDDNode2 = arrayList4.get(i);
                ArrayList<Long> arrayList5 = new ArrayList<Long>();
                ArrayList<Long> arrayList6 = new ArrayList<Long>();
                hashSet.clear();
                for (n2 = 0; n2 < mDDNode2.links.size(); ++n2) {
                    MDDNode mDDNode3 = mDDNode2.links.get(n2);
                    sat.addClause(lArray[mDDNode3.id], -aSTNode.directEncode(sat, mDDNode2.values.get(n2)), -lArray[mDDNode2.id]);
                    sat.addClause(-lArray[mDDNode3.id], -aSTNode.directEncode(sat, mDDNode2.values.get(n2)), lArray[mDDNode2.id]);
                    arrayList5.add(-lArray[mDDNode3.id]);
                    arrayList6.add(lArray[mDDNode3.id]);
                    hashSet.add(mDDNode2.values.get(n2));
                }
                for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                    for (long j = arrayList3.get((int)n2).lower; j <= arrayList3.get((int)n2).upper; ++j) {
                        if (hashSet.contains(j)) continue;
                        sat.addClause(-aSTNode.directEncode(sat, j), -lArray[mDDNode2.id]);
                        arrayList5.add(sat.getTrue());
                    }
                }
                arrayList5.add(lArray[mDDNode2.id]);
                sat.addClause(arrayList5);
                arrayList6.add(-lArray[mDDNode2.id]);
                sat.addClause(arrayList6);
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            if (arrayList2.get((int)n).type == -1) {
                sat.addClause(lArray[arrayList2.get((int)n).id]);
            }
            if (arrayList2.get((int)n).type != -2) continue;
            sat.addClause(-lArray[arrayList2.get((int)n).id]);
        }
        sat.addClause(lArray[mDDNode.id]);
    }

    public static class MDDNode {
        MDDNode parent;
        ArrayList<Long> values;
        ArrayList<MDDNode> links;
        int id;
        byte type;

        MDDNode(MDDNode mDDNode) {
            this.parent = mDDNode;
            this.type = 0;
            this.values = new ArrayList();
            this.links = new ArrayList();
        }
    }
}

