/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.PairASTNode;
import savilerow.SymbolTable;

public class Popcount
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Popcount(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Popcount(this.getChild(0));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getCategory() >= 3) {
            System.out.println("ERROR: Popcount may not contain decision variables:" + this);
            return false;
        }
        if (this.getChild(0).getDimension() > 0) {
            System.out.println("ERROR: Popcount may not contain a matrix:" + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant()) {
            long l = this.getChild(0).getValue();
            return NumberConstant.make(Long.bitCount(l));
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(0L, 64L);
    }

    public PairASTNode getBoundsAST() {
        return new PairASTNode(NumberConstant.make(0L), NumberConstant.make(64L));
    }

    @Override
    public String toString() {
        return "popcount(" + this.getChild(0) + ")";
    }
}

