/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.EmptyMatrix;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.SymbolTable;
import savilerow.Unpack;

public class SafeMatrixDeref
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public SafeMatrixDeref(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        super(aSTNode, arrayList.toArray(new ASTNode[arrayList.size()]));
    }

    @Override
    public ASTNode copy() {
        return new SafeMatrixDeref(this.getChild(0), this.getChildren(1));
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNumerical() {
        return !this.getChild(0).isRelation() && !this.getChild(0).isSet();
    }

    @Override
    public boolean isSet() {
        return this.getChild(0).isSet();
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower > 0L) {
            intpair.lower = 0L;
        }
        if (intpair.upper < 0L) {
            intpair.upper = 0L;
        }
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>(1);
        arrayList.add(new Intpair(0L, 0L));
        return Intpair.union(this.getChild(0).getIntervalSetExp(), arrayList);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        if (this.isNumerical()) {
            return true;
        }
        return super.toFlatten(bl);
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode;
        int n;
        for (n = 1; n < this.numChildren(); ++n) {
            if (!(this.getChild(n) instanceof Unpack)) continue;
            ArrayList<ASTNode> arrayList = ((Unpack)this.getChild(1)).items();
            if (arrayList != null) {
                int n2;
                this.detachChildren();
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>(this.numChildren() + arrayList.size() - 2);
                for (n2 = 1; n2 < n; ++n2) {
                    arrayList2.add(this.getChild(n2));
                }
                arrayList2.addAll(arrayList);
                for (n2 = n + 1; n2 < this.numChildren(); ++n2) {
                    arrayList2.add(this.getChild(n2));
                }
                return new SafeMatrixDeref(this.getChild(0), arrayList2);
            }
            return null;
        }
        n = 0;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).getCategory() == 0) continue;
            n = 1;
            break;
        }
        if (n == 0 && ((aSTNode = this.getChildConst(0)) instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix)) {
            ASTNode aSTNode2 = SafeMatrixDeref.derefCompoundMatrix(aSTNode, this.getChildren(1));
            return aSTNode2 == null ? null : aSTNode2;
        }
        return null;
    }

    public static ASTNode derefCompoundMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            if (!(aSTNode instanceof CompoundMatrix) && !(aSTNode instanceof EmptyMatrix)) {
                return null;
            }
            if (aSTNode instanceof EmptyMatrix) {
                return NumberConstant.make(0L);
            }
            ASTNode aSTNode2 = aSTNode.getChild(0);
            long l = arrayList.get(i).getValue();
            ArrayList<Intpair> arrayList2 = aSTNode2.getIntervalSet();
            if (arrayList2 == null) {
                return null;
            }
            if (Intpair.numValues(arrayList2) != (long)(aSTNode.numChildren() - 1)) {
                CmdFlags.warning("Index domain size does not match number of elements: " + aSTNode);
            }
            if ((n = (int)Intpair.location(arrayList2, l)) == -1) {
                return NumberConstant.make(0L);
            }
            int n2 = n + 1;
            aSTNode = aSTNode.getChildConst(n2);
        }
        return aSTNode;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < this.numChildren(); ++n) {
            if (this.getChild(n).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != this.numChildren() - 1) {
            System.out.println("ERROR: Dimension mismatch in matrix deref: " + this);
            return false;
        }
        for (n = 1; n < this.numChildren(); ++n) {
            if (this.getChild(n).isNumerical() || this.getChild(n).isRelation()) continue;
            System.out.println("ERROR: In matrix deref " + this + ", index " + this.getChild(n) + " is not numerical or relational.");
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (bl) {
            if (CmdFlags.getUseBoundVars() && this.exceedsBoundThreshold()) {
                bufferedWriter.append("eq(");
            } else {
                bufferedWriter.append("w-literal(");
            }
        }
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(bufferedWriter, false);
            if (i >= this.numChildren() - 1) continue;
            bufferedWriter.append(",");
        }
        bufferedWriter.append("]");
        if (bl) {
            bufferedWriter.append(",1)");
        }
    }

    @Override
    public String toString() {
        String string = this.getChild(0).toString() + "[";
        for (int i = 1; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + ", ";
        }
        return string + "]";
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }
}

