/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import savilerow.ASTNode;
import savilerow.BinOp;
import savilerow.BinOpPlaceholder;

class ShuntingYard {
    private HashMap<String, Integer> precedence = new HashMap();
    private HashMap<String, Boolean> left_associative = new HashMap();

    ShuntingYard() {
        this.precedence.put("^", 11);
        this.precedence.put("**", 11);
        this.precedence.put("*", 10);
        this.precedence.put("/", 10);
        this.precedence.put("%", 10);
        this.precedence.put("+", 1);
        this.precedence.put("-", 1);
        this.precedence.put("=", 0);
        this.precedence.put("!=", 0);
        this.precedence.put("<=", 0);
        this.precedence.put("<", 0);
        this.precedence.put(">=", 0);
        this.precedence.put(">", 0);
        this.precedence.put("<lex", 0);
        this.precedence.put("<=lex", 0);
        this.precedence.put(">lex", 0);
        this.precedence.put(">=lex", 0);
        this.precedence.put("in", 0);
        this.precedence.put("/\\", -1);
        this.precedence.put("xor", -2);
        this.precedence.put("\\/", -3);
        this.precedence.put("=>", -4);
        this.precedence.put("<=>", -4);
        this.precedence.put("->", -4);
        this.precedence.put("<->", -4);
        this.precedence.put("intersect", 2);
        this.precedence.put("union", 1);
        this.precedence.put("subsetEq", 0);
        for (Map.Entry<String, Integer> entry : this.precedence.entrySet()) {
            this.left_associative.put(entry.getKey(), true);
        }
        this.left_associative.put("^", false);
        this.left_associative.put("**", false);
    }

    public ASTNode convertToTree(ArrayList<ASTNode> arrayList) {
        return this.evaluate(this.toRPN(arrayList));
    }

    private ArrayList<ASTNode> toRPN(ArrayList<ASTNode> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i);
            if (!(aSTNode instanceof BinOpPlaceholder)) {
                arrayList2.add(aSTNode);
                continue;
            }
            while (arrayList3.size() > 0) {
                ASTNode aSTNode2 = (ASTNode)arrayList3.get(arrayList3.size() - 1);
                String string = ((BinOpPlaceholder)aSTNode).op;
                if (this.left_associative.get(string).booleanValue() && this.precedence.get(string) <= this.precedence.get(((BinOpPlaceholder)aSTNode2).op)) {
                    arrayList2.add(aSTNode2);
                    arrayList3.remove(arrayList3.size() - 1);
                    continue;
                }
                if (this.left_associative.get(string).booleanValue() || this.precedence.get(string) >= this.precedence.get(((BinOpPlaceholder)aSTNode2).op)) break;
                arrayList2.add(aSTNode2);
                arrayList3.remove(arrayList3.size() - 1);
            }
            arrayList3.add(aSTNode);
        }
        while (arrayList3.size() > 0) {
            arrayList2.add((ASTNode)arrayList3.get(arrayList3.size() - 1));
            arrayList3.remove(arrayList3.size() - 1);
        }
        return arrayList2;
    }

    private ASTNode evaluate(ArrayList<ASTNode> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i);
            if (aSTNode instanceof BinOpPlaceholder) {
                ASTNode aSTNode2 = (ASTNode)arrayList2.get(arrayList2.size() - 2);
                ASTNode aSTNode3 = (ASTNode)arrayList2.get(arrayList2.size() - 1);
                arrayList2.remove(arrayList2.size() - 1);
                arrayList2.remove(arrayList2.size() - 1);
                String string = ((BinOpPlaceholder)aSTNode).op;
                ASTNode aSTNode4 = BinOp.makeBinOp(string, aSTNode2, aSTNode3);
                arrayList2.add(aSTNode4);
                continue;
            }
            arrayList2.add(aSTNode);
        }
        assert (arrayList2.size() == 1);
        return (ASTNode)arrayList2.get(0);
    }
}

