/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.BooleanDomainFull;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Constants;
import savilerow.Container;
import savilerow.Domain;
import savilerow.Identifier;
import savilerow.IntegerDomain;
import savilerow.Intersect;
import savilerow.Intpair;
import savilerow.MatrixDomain;
import savilerow.Model;
import savilerow.Negate;
import savilerow.NumberConstant;
import savilerow.Range;
import savilerow.ReplaceASTNode;
import savilerow.SimpleDomain;
import savilerow.TransformFixSTRef;
import savilerow.TransformSimplify;
import savilerow.TreeTransformer;
import savilerow.categoryentry;
import savilerow.replaces_matrix_entry;

public class SymbolTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public transient Model m;
    public ArrayDeque<ASTNode> lettings_givens = new ArrayDeque();
    public HashMap<String, categoryentry> category;
    public categoryentry category_first = null;
    public categoryentry category_last = null;
    private ArrayList<categoryentry> category_list;
    private HashMap<String, ASTNode> domains = new HashMap();
    public transient HashMap<String, String> represents_ct;
    public HashMap<String, ASTNode> deleted_matrices;
    public HashMap<String, replaces_matrix_entry> replaces_matrix;
    int auxvarcounter = 0;
    public HashMap<ASTNode, ASTNode> replacements;
    public HashMap<ASTNode, ASTNode> replacements_domains;
    public HashMap<ASTNode, Integer> replacements_category;
    HashSet<String> boolvar_bool;
    HashSet<String> boolvar_int;
    HashSet<String> directvar_sat;
    HashSet<String> ordervar_sat;
    HashSet<String> var_integer;
    HashSet<String> var_bitVector;
    HashSet<String> var_boolean;
    private HashSet<ASTNode> presVarsSet;

    public SymbolTable() {
        this.category = new HashMap();
        this.represents_ct = new HashMap();
        this.boolvar_bool = new HashSet();
        this.boolvar_int = new HashSet();
        this.deleted_matrices = new HashMap();
        this.replaces_matrix = new HashMap();
        this.replacements = new HashMap();
        this.replacements_domains = new HashMap();
        this.replacements_category = new HashMap();
    }

    private void category_put_end(String string, int n) {
        if (this.category_last == null) {
            assert (this.category_first == null);
            this.category_first = this.category_last = new categoryentry(string, n, null, null);
        } else {
            categoryentry categoryentry2;
            this.category_last.next = categoryentry2 = new categoryentry(string, n, this.category_last, null);
            this.category_last = categoryentry2;
        }
        this.category.put(string, this.category_last);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SymbolTable)) {
            return false;
        }
        SymbolTable symbolTable = (SymbolTable)object;
        if (!Arrays.equals(this.lettings_givens.toArray(), symbolTable.lettings_givens.toArray())) {
            return false;
        }
        if (!symbolTable.category.equals(this.category)) {
            return false;
        }
        categoryentry categoryentry2 = this.category_first;
        categoryentry categoryentry3 = symbolTable.category_first;
        while (categoryentry2 != null || categoryentry3 != null) {
            if (categoryentry2 == null || categoryentry3 == null) {
                return false;
            }
            if (!categoryentry2.equals(categoryentry3)) {
                return false;
            }
            assert (categoryentry2.next == null || categoryentry2.next.prev == categoryentry2);
            assert (categoryentry3.next == null || categoryentry3.next.prev == categoryentry3);
            assert (categoryentry2.next != null || categoryentry2 == this.category_last);
            assert (categoryentry3.next != null || categoryentry3 == symbolTable.category_last);
            categoryentry2 = categoryentry2.next;
            categoryentry3 = categoryentry3.next;
        }
        if (!symbolTable.domains.equals(this.domains)) {
            return false;
        }
        if (!symbolTable.represents_ct.equals(this.represents_ct)) {
            return false;
        }
        if (!symbolTable.deleted_matrices.equals(this.deleted_matrices)) {
            return false;
        }
        if (!symbolTable.replaces_matrix.equals(this.replaces_matrix)) {
            return false;
        }
        if (symbolTable.auxvarcounter != this.auxvarcounter) {
            return false;
        }
        if (!symbolTable.replacements.equals(this.replacements)) {
            return false;
        }
        if (!symbolTable.replacements_domains.equals(this.replacements_domains)) {
            return false;
        }
        return symbolTable.replacements_category.equals(this.replacements_category);
    }

    public int hashCode() {
        int n = 0;
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            n = 6091 * n + categoryentry2.name.hashCode();
            categoryentry2 = categoryentry2.next;
        }
        return Objects.hash(Arrays.hashCode(this.lettings_givens.toArray()), this.category, n, this.domains, this.represents_ct, this.deleted_matrices, this.replaces_matrix, this.auxvarcounter, this.replacements, this.replacements_domains, this.replacements_category);
    }

    public SymbolTable copy(Model model) {
        SymbolTable symbolTable = new SymbolTable();
        symbolTable.m = model;
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(model);
        for (ASTNode iterator : this.lettings_givens) {
            symbolTable.lettings_givens.addLast(transformFixSTRef.transform(iterator.copy()));
        }
        Object object = this.category_first;
        while (object != null) {
            symbolTable.category_put_end(((categoryentry)object).name, ((categoryentry)object).cat);
            object = ((categoryentry)object).next;
        }
        for (String string : this.domains.keySet()) {
            symbolTable.domains.put(string, transformFixSTRef.transform(this.domains.get(string).copy()));
        }
        symbolTable.represents_ct = new HashMap<String, String>(this.represents_ct);
        for (String string : this.deleted_matrices.keySet()) {
            symbolTable.deleted_matrices.put(string, transformFixSTRef.transform(this.deleted_matrices.get(string).copy()));
        }
        for (String string : this.replaces_matrix.keySet()) {
            replaces_matrix_entry replaces_matrix_entry2 = new replaces_matrix_entry(this.replaces_matrix.get((Object)string).name, new ArrayList<Long>(this.replaces_matrix.get((Object)string).idx));
            symbolTable.replaces_matrix.put(string, replaces_matrix_entry2);
        }
        symbolTable.auxvarcounter = this.auxvarcounter;
        for (ASTNode aSTNode : this.replacements.keySet()) {
            symbolTable.replacements.put(transformFixSTRef.transform(aSTNode.copy()), transformFixSTRef.transform(this.replacements.get(aSTNode).copy()));
        }
        for (ASTNode aSTNode : this.replacements_domains.keySet()) {
            symbolTable.replacements_domains.put(transformFixSTRef.transform(aSTNode.copy()), transformFixSTRef.transform(this.replacements_domains.get(aSTNode).copy()));
        }
        for (ASTNode aSTNode : this.replacements_category.keySet()) {
            symbolTable.replacements_category.put(transformFixSTRef.transform(aSTNode.copy()), (int)this.replacements_category.get(aSTNode));
        }
        return symbolTable;
    }

    public void newVariable(String string, ASTNode aSTNode, int n) {
        assert (!this.category.containsKey(string));
        this.domains.put(string, aSTNode);
        this.category_put_end(string, n);
    }

    public void newVariable(String string, ASTNode aSTNode, int n, ASTNode aSTNode2, ArrayList<Long> arrayList) {
        Serializable serializable;
        assert (!this.category.containsKey(string));
        this.domains.put(string, aSTNode);
        if (aSTNode.getCategory() == 0 && (serializable = aSTNode.getIntervalSet()).size() == 0) {
            CmdFlags.println("ERROR: Empty domain");
        }
        serializable = this.category.get(aSTNode2.toString());
        categoryentry categoryentry2 = new categoryentry(string, n, ((categoryentry)serializable).prev, (categoryentry)serializable);
        if (categoryentry2.next == null) {
            this.category_last = categoryentry2;
        } else {
            categoryentry2.next.prev = categoryentry2;
        }
        if (categoryentry2.prev == null) {
            this.category_first = categoryentry2;
        } else {
            categoryentry2.prev.next = categoryentry2;
        }
        this.category.put(string, categoryentry2);
        this.replaces_matrix.put(string, new replaces_matrix_entry(aSTNode2.toString(), new ArrayList<Long>(arrayList)));
    }

    public void unifyVariables(ASTNode aSTNode, ASTNode aSTNode2) {
        Serializable serializable;
        assert (aSTNode.getCategory() == 3 && aSTNode2.getCategory() == 3);
        if (this.category.get((Object)aSTNode.toString()).cat == 10 || aSTNode.toString().length() >= 10 && aSTNode.toString().substring(0, 10).equals("incumbent_") || !this.preserveVariable(aSTNode) && this.preserveVariable(aSTNode2)) {
            serializable = aSTNode;
            aSTNode = aSTNode2;
            aSTNode2 = serializable;
        }
        serializable = this.getDomain(aSTNode.toString()).getIntervalSet();
        ArrayList<Intpair> arrayList = this.getDomain(aSTNode2.toString()).getIntervalSet();
        ArrayList<Intpair> arrayList2 = Intpair.intersection((ArrayList<Intpair>)serializable, arrayList);
        ASTNode aSTNode3 = Intpair.makeDomain(arrayList2, this.getDomain(aSTNode.toString()).isBooleanSet());
        assert (!this.preserveVariable(aSTNode2));
        this.setDomain(aSTNode.toString(), aSTNode3);
        this.replacements.put(aSTNode2, aSTNode);
        this.replacements_domains.put(aSTNode2, this.getDomain(aSTNode2.toString()));
        this.replacements_category.put(aSTNode2, this.category.get((Object)aSTNode2.toString()).cat);
        this.deleteSymbol(aSTNode2.toString());
    }

    public void unifyVariablesNegated(ASTNode aSTNode, ASTNode aSTNode2) {
        assert (aSTNode.getCategory() == 3 && aSTNode2.getCategory() == 3);
        assert (aSTNode2 instanceof Negate);
        aSTNode2 = aSTNode2.getChild(0);
        assert (aSTNode.isRelation() && aSTNode2.isRelation());
        if (this.category.get((Object)aSTNode.toString()).cat == 10 || !this.preserveVariable(aSTNode) && this.preserveVariable(aSTNode2)) {
            ASTNode aSTNode3 = aSTNode;
            aSTNode = aSTNode2;
            aSTNode2 = aSTNode3;
        }
        assert (!this.preserveVariable(aSTNode2));
        this.replacements.put(aSTNode2, new Negate(aSTNode));
        this.replacements_domains.put(aSTNode2, this.getDomain(aSTNode2.toString()));
        this.replacements_category.put(aSTNode2, this.category.get((Object)aSTNode2.toString()).cat);
        this.deleteSymbol(aSTNode2.toString());
    }

    public void unifyVariablesLinear(ASTNode aSTNode, ASTNode aSTNode2) {
        assert (aSTNode.getCategory() == 3 && aSTNode2.getCategory() == 3);
        assert (aSTNode instanceof Identifier);
        assert (!this.preserveVariable(aSTNode));
        this.replacements.put(aSTNode, aSTNode2);
        this.replacements_domains.put(aSTNode, this.getDomain(aSTNode.toString()));
        this.replacements_category.put(aSTNode, this.category.get((Object)aSTNode.toString()).cat);
        this.deleteSymbol(aSTNode.toString());
    }

    public void assignVariable(ASTNode aSTNode, ASTNode aSTNode2) {
        assert (!CmdFlags.getUseAggregate() || CmdFlags.getAfterAggregate());
        assert (aSTNode instanceof Identifier);
        assert (aSTNode2.isConstant());
        assert (this.getDomain(aSTNode.toString()).containsValue(aSTNode2.getValue()));
        assert (aSTNode.getModel().global_symbols == this);
        assert (!this.preserveVariable(aSTNode));
        if (aSTNode.isRelation() && !aSTNode2.isRelation()) {
            long l = aSTNode2.getValue();
            assert (l >= 0L && l <= 1L);
            aSTNode2 = new BooleanConstant(l == 1L);
        }
        this.replacements.put(aSTNode, aSTNode2);
        this.replacements_domains.put(aSTNode, this.getDomain(aSTNode.toString()));
        this.replacements_category.put(aSTNode, this.category.get((Object)aSTNode.toString()).cat);
        this.deleteSymbol(aSTNode.toString());
        if (this.m.sns != null && CmdFlags.getMinionSNStrans()) {
            ASTNode aSTNode3 = this.m.sns.getChild(0).getChild(0);
            ASTNode aSTNode4 = this.m.sns.getChild(0).getChild(1);
            for (int i = 1; i < aSTNode3.numChildren(); ++i) {
                if (!aSTNode3.getChild(i).equals(aSTNode)) continue;
                ASTNode aSTNode5 = aSTNode4.getChild(i);
                if (this.getDomain(aSTNode5.toString()) == null || this.preserveVariable(aSTNode5)) break;
                this.assignVariable(aSTNode5, aSTNode2.copy());
                break;
            }
        }
    }

    public boolean preserveVariable(ASTNode aSTNode) {
        if (this.m.preserveVariables == null) {
            return false;
        }
        if (this.presVarsSet == null) {
            if (!(this.m.preserveVariables instanceof CompoundMatrix)) {
                return true;
            }
            this.presVarsSet = new HashSet<ASTNode>(this.m.preserveVariables.getChildren(1));
        }
        return this.presVarsSet.contains(aSTNode);
    }

    public ASTNode getDomain(String string) {
        return this.domains.get(string);
    }

    public void setDomain(String string, ASTNode aSTNode) {
        this.domains.put(string, aSTNode);
    }

    public boolean isAuxiliary(String string) {
        return this.category.get((Object)string).cat == 10;
    }

    public HashMap<String, ASTNode> getDomains() {
        return this.domains;
    }

    public categoryentry getCategoryFirst() {
        return this.category_first;
    }

    public int getCategory(String string) {
        if (this.category.get(string) == null) {
            return 20;
        }
        int n = this.category.get((Object)string).cat;
        if (n == 10) {
            return 3;
        }
        if (n == 11) {
            return 0;
        }
        return n;
    }

    public boolean hasVariable(String string) {
        return this.category.containsKey(string);
    }

    public String newAuxId() {
        String string = "aux" + this.auxvarcounter;
        while (this.category.containsKey(string)) {
            ++this.auxvarcounter;
            string = "aux" + this.auxvarcounter;
        }
        ++this.auxvarcounter;
        return string;
    }

    public Identifier newAuxiliaryVariable(long l, long l2) {
        String string = this.newAuxId();
        if (l != 0L || l2 != 1L) {
            this.domains.put(string, new IntegerDomain(new Range((ASTNode)NumberConstant.make(l), NumberConstant.make(l2))));
        } else {
            this.domains.put(string, new BooleanDomainFull());
        }
        this.category_put_end(string, 10);
        return new Identifier(this.m, string);
    }

    public Identifier newAuxiliaryVariable(ASTNode aSTNode) {
        String string = this.newAuxId();
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
        if (arrayList.size() == 1 && arrayList.get((int)0).lower == 0L && arrayList.get((int)0).upper == 1L) {
            this.domains.put(string, new BooleanDomainFull());
        } else {
            this.domains.put(string, aSTNode.copy());
        }
        this.category_put_end(string, 10);
        return new Identifier(this.m, string);
    }

    public ASTNode newAuxHelper(ASTNode aSTNode) {
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSetExp();
        ASTNode aSTNode2 = Intpair.makeDomain(arrayList, aSTNode.isRelation());
        aSTNode2 = this.m.filt.constructDomain(aSTNode, aSTNode2);
        Identifier identifier = this.newAuxiliaryVariable(aSTNode2);
        this.m.filt.auxVarRepresentsAST(((ASTNode)identifier).toString(), aSTNode);
        return identifier;
    }

    public ASTNode newAuxHelper(ASTNode aSTNode, ASTNode aSTNode2) {
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSetExp();
        Intersect intersect = new Intersect(Intpair.makeDomain(arrayList, aSTNode.isRelation()), aSTNode2);
        ASTNode aSTNode3 = this.m.filt.constructDomain(aSTNode, intersect);
        aSTNode3 = new TransformSimplify().transform(aSTNode3);
        Identifier identifier = this.newAuxiliaryVariable(aSTNode3);
        this.m.filt.auxVarRepresentsAST(((ASTNode)identifier).toString(), aSTNode);
        return identifier;
    }

    public Identifier newAuxiliaryVariable(ASTNode aSTNode, ASTNode aSTNode2) {
        String string = this.newAuxId();
        this.domains.put(string, new IntegerDomain(new Range(aSTNode, aSTNode2)));
        this.category_put_end(string, 10);
        return new Identifier(this.m, string);
    }

    public Identifier newAuxiliaryVariableMatrix(ASTNode aSTNode, ASTNode aSTNode2, ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, ArrayList<ASTNode> arrayList3) {
        String string = this.newAuxId();
        this.category_put_end(string, 10);
        this.domains.put(string, new MatrixDomain((ASTNode)new IntegerDomain(new Range(aSTNode, aSTNode2)), arrayList2, (ASTNode)new Container(arrayList), (ASTNode)new And(arrayList3)));
        return new Identifier(this.m, string);
    }

    public void registerConstantMatrix(String string) {
        if (this.category.containsKey(string)) {
            assert (this.category.get((Object)string).cat == 1);
            this.category.get((Object)string).cat = 11;
        } else {
            this.category_put_end(string, 11);
        }
    }

    public void auxVarRepresentsConstraint(String string, String string2) {
        this.represents_ct.put(string, string2.replaceAll("\n", ""));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            String string = categoryentry2.name;
            ASTNode aSTNode = this.getDomain(string);
            if (this.getCategory(string) == 1) {
                stringBuilder.append("given ");
            } else if (this.getCategory(string) == 3) {
                stringBuilder.append("find ");
            }
            stringBuilder.append(string);
            stringBuilder.append(" : ");
            stringBuilder.append(aSTNode.toString());
            stringBuilder.append("\n");
            categoryentry2 = categoryentry2.next;
        }
        return stringBuilder.toString();
    }

    public boolean simplify() {
        Object object;
        ASTNode aSTNode;
        int n;
        TransformSimplify transformSimplify = new TransformSimplify();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.lettings_givens.size();
        for (n = 0; n < n2; ++n) {
            this.lettings_givens.addLast(transformSimplify.transform(this.lettings_givens.removeFirst()));
        }
        n = 0;
        for (Map.Entry<String, ASTNode> entry : this.domains.entrySet()) {
            aSTNode = entry.getValue();
            aSTNode = transformSimplify.transform(aSTNode);
            entry.setValue(aSTNode);
            if (aSTNode.getCategory() != 0 || !aSTNode.isFiniteSet()) continue;
            object = aSTNode.getBounds();
            if (((Intpair)object).upper < ((Intpair)object).lower) {
                n = 1;
            }
            if (!CmdFlags.getUseDeleteVars() || ((Intpair)object).lower != ((Intpair)object).upper) continue;
            arrayList.add(entry.getKey());
        }
        if (CmdFlags.getUseDeleteVars() && (!CmdFlags.getUseAggregate() || CmdFlags.getAfterAggregate())) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (this.getDomain((String)arrayList.get(i)) == null || this.preserveVariable(aSTNode = new Identifier(this.m, (String)arrayList.get(i)))) continue;
                object = NumberConstant.make(this.getDomain((String)((String)arrayList.get((int)i))).getBounds().lower);
                this.assignVariable(aSTNode, (ASTNode)object);
            }
        }
        return n == 0;
    }

    public void transform_all(TreeTransformer treeTransformer) {
        Object object;
        Iterator<Map.Entry<ASTNode, ASTNode>> iterator;
        int n = this.lettings_givens.size();
        for (int i = 0; i < n; ++i) {
            this.lettings_givens.addLast(treeTransformer.transform(this.lettings_givens.removeFirst()));
        }
        for (Map.Entry<String, ASTNode> object32 : this.domains.entrySet()) {
            iterator = object32.getValue();
            object32.setValue(treeTransformer.transform((ASTNode)((Object)iterator)));
        }
        for (Map.Entry<String, ASTNode> entry : this.deleted_matrices.entrySet()) {
            iterator = entry.getValue();
            entry.setValue(treeTransformer.transform((ASTNode)((Object)iterator)));
        }
        HashMap<ASTNode, ASTNode> hashMap = new HashMap<ASTNode, ASTNode>();
        for (Map.Entry entry : this.replacements.entrySet()) {
            ASTNode aSTNode = treeTransformer.transform((ASTNode)entry.getKey());
            object = treeTransformer.transform((ASTNode)entry.getValue());
            hashMap.put(aSTNode, (ASTNode)object);
        }
        this.replacements = hashMap;
        HashMap<Object, ASTNode> hashMap2 = new HashMap<Object, ASTNode>();
        for (Map.Entry<ASTNode, ASTNode> entry : this.replacements_domains.entrySet()) {
            object = treeTransformer.transform(entry.getKey());
            ASTNode aSTNode = treeTransformer.transform(entry.getValue());
            hashMap2.put(object, aSTNode);
        }
        this.replacements_domains = hashMap2;
        HashMap<ASTNode, Integer> hashMap3 = new HashMap<ASTNode, Integer>();
        for (Map.Entry entry : this.replacements_category.entrySet()) {
            ASTNode aSTNode = treeTransformer.transform((ASTNode)entry.getKey());
            hashMap3.put(aSTNode, (Integer)entry.getValue());
        }
        this.replacements_category = hashMap3;
    }

    public void substitute(ASTNode aSTNode, ASTNode aSTNode2) {
        ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode, aSTNode2);
        for (Map.Entry<String, ASTNode> entry : this.domains.entrySet()) {
            ASTNode aSTNode3 = entry.getValue();
            entry.setValue(replaceASTNode.transform(aSTNode3));
        }
        int n = this.lettings_givens.size();
        for (int i = 0; i < n; ++i) {
            ASTNode aSTNode4 = this.lettings_givens.removeFirst();
            ASTNode aSTNode5 = aSTNode4.getChild(0);
            aSTNode4 = replaceASTNode.transform(aSTNode4);
            aSTNode4.setChild(0, aSTNode5);
            this.lettings_givens.addLast(aSTNode4);
        }
    }

    public boolean typecheck() {
        for (String string : this.domains.keySet()) {
            ASTNode aSTNode = this.domains.get(string);
            if (!(aSTNode instanceof Domain)) {
                CmdFlags.println("ERROR: Found " + aSTNode + " when expecting domain for symbol " + string);
                return false;
            }
            if (!aSTNode.typecheck(this)) {
                return false;
            }
            if (this.getCategory(string) != 3) continue;
            if (aSTNode instanceof MatrixDomain) {
                for (int i = 3; i < aSTNode.numChildren(); ++i) {
                    if (aSTNode.getChild(i) instanceof MatrixDomain || aSTNode.getChild(i).isFiniteSet()) continue;
                    CmdFlags.println("ERROR: Found " + aSTNode.getChild(i) + " when expecting finite integer domain for indices of matrix variable " + string);
                    return false;
                }
                if (aSTNode.getChild(0).isFiniteSet()) continue;
                CmdFlags.println("ERROR: Found " + aSTNode.getChild(0) + " when expecting finite integer domain for decision variable " + string);
                return false;
            }
            if (aSTNode.isFiniteSet()) continue;
            CmdFlags.println("ERROR: Found " + aSTNode + " when expecting finite integer domain for decision variable " + string);
            return false;
        }
        return true;
    }

    public void deleteSymbol(String string) {
        assert (this.category.containsKey(string));
        categoryentry categoryentry2 = this.category.get(string);
        if (categoryentry2.prev != null) {
            categoryentry2.prev.next = categoryentry2.next;
        } else {
            this.category_first = categoryentry2.next;
        }
        if (categoryentry2.next != null) {
            categoryentry2.next.prev = categoryentry2.prev;
        } else {
            this.category_last = categoryentry2.prev;
        }
        this.category.remove(string);
        if (this.domains.containsKey(string)) {
            this.domains.remove(string);
        }
        if (this.m.cmstore.hasConstantMatrix(string)) {
            this.m.cmstore.removeConstantMatrix(string);
        }
    }

    public void deleteMatrix(String string) {
        assert (this.category.containsKey(string));
        categoryentry categoryentry2 = this.category.get(string);
        if (categoryentry2.prev != null) {
            categoryentry2.prev.next = categoryentry2.next;
        } else {
            this.category_first = categoryentry2.next;
        }
        if (categoryentry2.next != null) {
            categoryentry2.next.prev = categoryentry2.prev;
        } else {
            this.category_last = categoryentry2.prev;
        }
        this.category.remove(string);
        assert (this.domains.containsKey(string));
        this.deleted_matrices.put(string, this.domains.get(string));
        this.domains.remove(string);
    }

    private void mangle_before_serialization() {
        this.category_list = new ArrayList();
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            this.category_list.add(categoryentry2);
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            categoryentry2.prev = null;
            categoryentry2 = categoryentry2.next;
            if (categoryentry2 == null) continue;
            categoryentry2.prev.next = null;
        }
    }

    public void unmangle_after_serialization() {
        if (this.category_list.size() > 0) {
            this.category_first = this.category_list.get(0);
            this.category_last = this.category_list.get(this.category_list.size() - 1);
        } else {
            this.category_first = null;
            this.category_last = null;
        }
        for (int i = 0; i < this.category_list.size(); ++i) {
            this.category_list.get((int)i).prev = i > 0 ? this.category_list.get(i - 1) : null;
            this.category_list.get((int)i).next = i < this.category_list.size() - 1 ? this.category_list.get(i + 1) : null;
        }
        this.category_list = null;
    }

    protected void serialize() {
        this.mangle_before_serialization();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(CmdFlags.auxfile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            CmdFlags.println(Thread.currentThread().getStackTrace());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                System.out.println(stackTraceElement);
            }
            CmdFlags.println("WARNING: Failed to serialise: " + exception);
        }
        this.unmangle_after_serialization();
    }

    public void toMinion(BufferedWriter bufferedWriter) throws IOException {
        assert (this.m.global_symbols == this);
        if (CmdFlags.getSaveSymbols()) {
            this.serialize();
        }
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 && !categoryentry2.already_written) {
                this.output_variable(bufferedWriter, categoryentry2.name, (Domain)this.domains.get(categoryentry2.name));
                categoryentry2.already_written = true;
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 10 && !categoryentry2.already_written) {
                this.output_variable(bufferedWriter, categoryentry2.name, (Domain)this.domains.get(categoryentry2.name));
                categoryentry2.already_written = true;
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public void printPrintStmt(BufferedWriter bufferedWriter) throws IOException {
        Object object;
        bufferedWriter.append("PRINT[");
        String string = "";
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            object = categoryentry2.name;
            if (categoryentry2.cat == 3) {
                bufferedWriter.append(string);
                if (this.getDomain((String)object) instanceof SimpleDomain) {
                    bufferedWriter.append("[");
                    bufferedWriter.append((CharSequence)object);
                    bufferedWriter.append("]");
                } else {
                    bufferedWriter.append((CharSequence)object);
                }
                string = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
        if (this.m.objective != null) {
            object = this.m.objective.getChild(0);
            bufferedWriter.append(string);
            if (object instanceof CompoundMatrix) {
                for (int i = 1; i < ((ASTNode)object).numChildren(); ++i) {
                    bufferedWriter.append("[");
                    bufferedWriter.append(((ASTNode)object).getChild(i).toString());
                    bufferedWriter.append("]");
                    if (i >= ((ASTNode)object).numChildren() - 1) continue;
                    bufferedWriter.append(",");
                }
            } else {
                bufferedWriter.append("[");
                bufferedWriter.append(((ASTNode)object).toString());
                bufferedWriter.append("]");
            }
        }
        bufferedWriter.append("]\n");
    }

    public void printAllVariables(Writer writer, int n) throws IOException {
        String string = "";
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            String string2 = categoryentry2.name;
            if (categoryentry2.cat == n) {
                writer.append(string);
                writer.append(string2);
                string = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public void printAllVariables(Writer writer) throws IOException {
        String string = "";
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            String string2 = categoryentry2.name;
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                writer.append(string);
                writer.append(string2);
                string = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public boolean printAllVariablesFlatzinc(StringBuilder stringBuilder, int n) {
        String string = "";
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            String string2 = categoryentry2.name;
            if (categoryentry2.cat == n) {
                stringBuilder.append(string);
                ASTNode aSTNode = this.getDomain(string2);
                if (aSTNode.isBooleanSet() || aSTNode.isIntegerSet() && aSTNode.getBounds().equals(new Intpair(0L, 1L))) {
                    if (this.boolvar_int.contains(string2)) {
                        stringBuilder.append(string2 + "_INTEGER");
                    } else if (this.boolvar_bool.contains(string2)) {
                        stringBuilder.append(string2 + "_BOOL");
                    } else assert (false) : "Something strange has happened: var with name " + string2 + " is apparently not used anywhere.";
                } else {
                    stringBuilder.append(string2);
                }
                bl = true;
                string = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
        return bl;
    }

    public boolean printAllVariablesFlatzincExcept(StringBuilder stringBuilder, int n, String string) {
        String string2 = "";
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            String string3 = categoryentry2.name;
            if (categoryentry2.cat == n && !string3.equals(string)) {
                stringBuilder.append(string2);
                ASTNode aSTNode = this.getDomain(string3);
                if (aSTNode.isBooleanSet() || aSTNode.isIntegerSet() && aSTNode.getBounds().equals(new Intpair(0L, 1L))) {
                    if (this.boolvar_int.contains(string3)) {
                        stringBuilder.append(string3 + "_INTEGER");
                    } else if (this.boolvar_bool.contains(string3)) {
                        stringBuilder.append(string3 + "_BOOL");
                    } else assert (false) : "Something strange has happened: var with name " + string3 + " is apparently not used anywhere.";
                } else {
                    stringBuilder.append(string3);
                }
                bl = true;
                string2 = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
        return bl;
    }

    private void output_variable(BufferedWriter bufferedWriter, String string, Domain domain) throws IOException {
        String string2 = this.represents_ct.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (domain.isBooleanSet()) {
            bufferedWriter.append("BOOL " + string + " #" + string2 + "\n");
            if (!domain.containsValue(0L) && !domain.containsValue(1L)) {
                bufferedWriter.append("**CONSTRAINTS**\n");
                bufferedWriter.append("false()  # Empty Boolean domain, faked with false() constraint.\n");
                bufferedWriter.append("**VARIABLES**\n");
            } else if (!domain.containsValue(0L) || !domain.containsValue(1L)) {
                bufferedWriter.append("**CONSTRAINTS**\n");
                Intpair intpair = domain.getBounds();
                bufferedWriter.append("w-inintervalset(" + string + ", [");
                bufferedWriter.append(String.valueOf(intpair.lower));
                bufferedWriter.append(",");
                bufferedWriter.append(String.valueOf(intpair.upper));
                bufferedWriter.append("])\n");
                bufferedWriter.append("**VARIABLES**\n");
            }
        } else if (domain instanceof SimpleDomain) {
            ArrayList<Intpair> arrayList = domain.getIntervalSet();
            if (arrayList.size() > 0) {
                long l = arrayList.get((int)(arrayList.size() - 1)).upper - arrayList.get((int)0).lower + 1L;
                if (CmdFlags.getUseBoundVars() && l > (long)Constants.boundvar_threshold) {
                    bufferedWriter.append("BOUND " + string + " #" + string2 + "\n");
                } else {
                    bufferedWriter.append("DISCRETE " + string + " #" + string2 + "\n");
                }
                bufferedWriter.append("{" + arrayList.get((int)0).lower + ".." + arrayList.get((int)(arrayList.size() - 1)).upper + "}\n");
                if (arrayList.size() > 1) {
                    bufferedWriter.append("**CONSTRAINTS**\n");
                    bufferedWriter.append("w-inintervalset(" + string + ", [");
                    for (int i = 0; i < arrayList.size(); ++i) {
                        bufferedWriter.append(String.valueOf(arrayList.get((int)i).lower));
                        bufferedWriter.append(",");
                        bufferedWriter.append(String.valueOf(arrayList.get((int)i).upper));
                        if (i >= arrayList.size() - 1) continue;
                        bufferedWriter.append(",");
                    }
                    bufferedWriter.append("])\n");
                    bufferedWriter.append("**VARIABLES**\n");
                }
            } else {
                bufferedWriter.append("DISCRETE " + string + " #" + string2 + "\n");
                bufferedWriter.append("{0..0}  #  This is an empty domain. Faking that by using 0..0 and the false() constraint below.\n");
                bufferedWriter.append("**CONSTRAINTS**\n");
                bufferedWriter.append("false()\n");
                bufferedWriter.append("**VARIABLES**\n");
            }
        } else assert (false);
    }

    public void markAsBoolFlatzinc(String string) {
        this.boolvar_bool.add(string);
    }

    public void markAsIntFlatzinc(String string) {
        this.boolvar_int.add(string);
    }

    public void toFlatzinc(BufferedWriter bufferedWriter) throws IOException {
        Object object;
        categoryentry categoryentry2 = this.category_first;
        StringBuffer stringBuffer = new StringBuffer();
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                object = (Domain)this.getDomain(categoryentry2.name);
                this.output_variable_flatzinc(bufferedWriter, categoryentry2.name, (Domain)object, stringBuffer, categoryentry2.cat == 10);
            }
            categoryentry2 = categoryentry2.next;
        }
        bufferedWriter.append(stringBuffer);
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            object = categoryentry2.name;
            Domain domain = (Domain)this.getDomain((String)object);
            if ((categoryentry2.cat == 3 || categoryentry2.cat == 10) && (domain.isBooleanSet() || domain.isIntegerSet() && domain.getBounds().equals(new Intpair(0L, 1L))) && this.boolvar_bool.contains(object) && this.boolvar_int.contains(object)) {
                bufferedWriter.append("constraint bool2int(" + (String)object + "_BOOL," + (String)object + "_INTEGER);\n");
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    private void output_variable_flatzinc(BufferedWriter bufferedWriter, String string, Domain domain, StringBuffer stringBuffer, boolean bl) throws IOException {
        String string2 = this.represents_ct.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (domain.isBooleanSet() || domain.isIntegerSet() && domain.getBounds().equals(new Intpair(0L, 1L))) {
            boolean bl2;
            boolean bl3 = this.m.boolForFznSearch(new Identifier(this.m, string));
            boolean bl4 = this.boolvar_bool.contains(string) || bl3;
            boolean bl5 = bl2 = this.boolvar_int.contains(string) || !bl3;
            if (bl4) {
                bufferedWriter.append("var bool: " + string + "_BOOL");
                if (!bl && !this.boolvar_int.contains(string)) {
                    bufferedWriter.append(":: output_var ");
                }
                if (bl) {
                    bufferedWriter.append(":: var_is_introduced ");
                }
                bufferedWriter.append(";\n");
            }
            if (bl2) {
                bufferedWriter.append("var {0,1}: " + string + "_INTEGER ");
                if (!bl) {
                    bufferedWriter.append(":: output_var ");
                }
                if (bl) {
                    bufferedWriter.append(":: var_is_introduced ");
                }
                bufferedWriter.append(";\n");
            }
            ArrayList<Intpair> arrayList = domain.getIntervalSet();
            assert (arrayList.size() <= 1);
            if (arrayList.size() == 0 || arrayList.get((int)0).lower != 0L || arrayList.get((int)0).upper != 1L) {
                if (arrayList.size() == 0) {
                    stringBuffer.append("constraint int_eq(0,1); % Variable " + string + " has empty domain.\n");
                } else {
                    if (bl4) {
                        stringBuffer.append("constraint bool_eq(" + string + "_BOOL," + (arrayList.get((int)0).lower != 0L) + "); % Variable " + string + " has singleton domain.\n");
                    }
                    if (bl2) {
                        stringBuffer.append("constraint int_eq(" + string + "_INTEGER," + arrayList.get((int)0).lower + "); % Variable " + string + " has singleton domain.\n");
                    }
                }
            }
        } else if (domain instanceof SimpleDomain) {
            ArrayList<Intpair> arrayList = domain.getIntervalSet();
            if (arrayList.size() == 0) {
                bufferedWriter.append("var 0..1 : " + string);
                if (!bl) {
                    bufferedWriter.append(":: output_var ");
                }
                if (bl) {
                    bufferedWriter.append(":: var_is_introduced ");
                }
                bufferedWriter.append(";\n");
                stringBuffer.append("constraint int_eq(0,1); % Variable " + string + " has empty domain.\n");
            } else {
                bufferedWriter.append("var ");
                if (arrayList.size() == 1) {
                    bufferedWriter.append(arrayList.get((int)0).lower + ".." + arrayList.get((int)0).upper);
                } else {
                    bufferedWriter.append("{");
                    for (int i = 0; i < arrayList.size(); ++i) {
                        for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                            bufferedWriter.append(String.valueOf(j));
                            if (i >= arrayList.size() - 1 && j >= arrayList.get((int)i).upper) continue;
                            bufferedWriter.append(",");
                        }
                    }
                    bufferedWriter.append("}");
                }
                bufferedWriter.append(": ");
                bufferedWriter.append(string);
                if (!bl) {
                    bufferedWriter.append(":: output_var ");
                }
                if (bl) {
                    bufferedWriter.append(":: var_is_introduced ");
                }
                bufferedWriter.append(";\n");
            }
        } else assert (false);
    }

    public void toMinizinc(StringBuilder stringBuilder) {
        Domain domain;
        String string;
        if (CmdFlags.getSaveSymbols()) {
            this.serialize();
        }
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            domain = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 3) {
                this.output_variable_minizinc(stringBuilder, string, domain, false);
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            domain = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 10) {
                this.output_variable_minizinc(stringBuilder, string, domain, true);
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            domain = (Domain)this.getDomain(string);
            if ((categoryentry2.cat == 3 || categoryentry2.cat == 10) && (domain.isBooleanSet() || domain.isIntegerSet() && domain.getBounds().equals(new Intpair(0L, 1L))) && this.boolvar_bool.contains(string) && this.boolvar_int.contains(string)) {
                stringBuilder.append("constraint bool2int(" + string + "_BOOL) = " + string + "_INTEGER;\n");
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    private void output_variable_minizinc(StringBuilder stringBuilder, String string, Domain domain, boolean bl) {
        String string2;
        String string3 = this.represents_ct.get(string);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string2 = bl ? " :: var_is_introduced :: is_defined_var " : "";
        if (domain.isBooleanSet() || domain.isIntegerSet() && domain.getBounds().equals(new Intpair(0L, 1L))) {
            if (this.boolvar_bool.contains(string)) {
                stringBuilder.append("var bool: " + string + "_BOOL" + string2 + "; %" + string3 + "\n");
            }
            if (this.boolvar_int.contains(string)) {
                stringBuilder.append("var {0,1}: " + string + "_INTEGER" + string2 + "; %" + string3 + "\n");
            }
        } else if (domain instanceof SimpleDomain) {
            ArrayList<Intpair> arrayList = domain.getIntervalSet();
            if (arrayList.size() == 0) {
                stringBuilder.append("var 1..0: " + string);
            } else if (arrayList.size() > 1) {
                String string5 = this.newAuxId();
                stringBuilder.append("set of int : " + string5 + " = ");
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuilder.append(arrayList.get((int)i).lower + ".." + arrayList.get((int)i).upper);
                    if (i >= arrayList.size() - 1) continue;
                    stringBuilder.append(" union ");
                }
                stringBuilder.append(";\n");
                stringBuilder.append("var " + string5 + " : " + string);
            } else {
                stringBuilder.append("var " + arrayList.get((int)0).lower + ".." + arrayList.get((int)0).upper + ": " + string);
            }
            stringBuilder.append(string2);
            stringBuilder.append("; %" + string3 + "\n");
        } else assert (false);
    }

    public void showVariablesMinizinc(StringBuilder stringBuilder) {
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            String string = categoryentry2.name;
            Domain domain = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 3) {
                stringBuilder.append("show(");
                if (domain.isBooleanSet() || domain.isIntegerSet() && domain.getBounds().equals(new Intpair(0L, 1L))) {
                    if (this.boolvar_bool.contains(string)) {
                        stringBuilder.append(string + "_BOOL");
                    } else if (this.boolvar_int.contains(string)) {
                        stringBuilder.append(string + "_INTEGER");
                    }
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append("),\" \",");
                bl = true;
            }
            categoryentry2 = categoryentry2.next;
        }
        if (bl) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
    }

    public void markAsDirectSAT(String string) {
        if (this.directvar_sat == null) {
            this.directvar_sat = new HashSet();
        }
        this.directvar_sat.add(string);
    }

    public void markAsOrderSAT(String string) {
        if (this.ordervar_sat == null) {
            this.ordervar_sat = new HashSet();
        }
        this.ordervar_sat.add(string);
    }

    public boolean isDirectSAT(String string) {
        if (this.directvar_sat == null) {
            return false;
        }
        return this.directvar_sat.contains(string);
    }

    public void markAsInteger(String string) {
        if (this.var_integer == null) {
            this.var_integer = new HashSet();
        }
        this.var_integer.add(string);
    }

    public boolean isInteger(String string) {
        if (this.var_integer == null) {
            return false;
        }
        return this.var_integer.contains(string);
    }

    public boolean isBitVector(String string) {
        if (this.var_bitVector == null) {
            return false;
        }
        return this.var_bitVector.contains(string);
    }

    public void markAsBitVector(String string) {
        if (this.var_bitVector == null) {
            this.var_bitVector = new HashSet();
        }
        this.var_bitVector.add(string);
    }

    public void markAsBoolean(String string) {
        if (this.var_boolean == null) {
            this.var_boolean = new HashSet();
        }
        this.var_boolean.add(string);
    }

    public boolean isBoolean(String string) {
        if (this.var_boolean == null) {
            return false;
        }
        return this.var_boolean.contains(string);
    }

    public boolean isOrderSAT(String string) {
        if (this.ordervar_sat == null) {
            return false;
        }
        return this.ordervar_sat.contains(string);
    }

    public void writeVarDomainsAsJSON(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                if (bl) {
                    stringBuilder.append(",");
                } else {
                    bl = true;
                }
                stringBuilder.append("\n");
                ASTNode aSTNode = this.getDomain(categoryentry2.name);
                stringBuilder.append("{\n\"name\": \"" + this.escapeVar(categoryentry2.name) + "\",\n");
                stringBuilder.append("\"domain\": [");
                ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuilder.append("[" + arrayList.get((int)i).lower + ", " + arrayList.get((int)i).upper + "]");
                    if (i >= arrayList.size() - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]\n}");
            }
            categoryentry2 = categoryentry2.next;
        }
        stringBuilder.append("]");
    }

    public void writeVarListAsJSON(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                if (bl) {
                    stringBuilder.append(",");
                } else {
                    bl = true;
                }
                stringBuilder.append("\"" + this.escapeVar(categoryentry2.name) + "\"");
            }
            categoryentry2 = categoryentry2.next;
        }
        stringBuilder.append("]");
    }

    String escapeVar(String string) {
        return "$" + string;
    }

    public static String unescapeVar(String string) {
        return string.replaceAll("^\\$(.*)$", "$1");
    }

    public ArrayList<String> getVarNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                arrayList.add(categoryentry2.name);
            }
            categoryentry2 = categoryentry2.next;
        }
        return arrayList;
    }
}

