/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.ASTNode;
import savilerow.CmdFlags;
import savilerow.IntegerDomainConcrete;
import savilerow.Intpair;
import savilerow.SMT;

public class CompoundMatrixInt1D
extends ASTNode {
    public static final long serialVersionUID = 1L;
    public int[] values;

    public CompoundMatrixInt1D(int[] nArray) {
        this.values = nArray;
    }

    @Override
    public boolean strongProp() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public ASTNode copy() {
        return new CompoundMatrixInt1D(this.values);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CompoundMatrixInt1D)) {
            return false;
        }
        return Arrays.equals(this.values, ((CompoundMatrixInt1D)object).values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public Intpair getBounds() {
        int n = this.values[0];
        int n2 = this.values[0];
        for (int i = 1; i < this.values.length; ++i) {
            int n3 = this.values[i];
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return new Intpair(n, n2);
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        for (int i = 0; i < this.values.length; ++i) {
            arrayList.add(new Intpair(this.values[i], this.values[i]));
        }
        Intpair.normalise(arrayList);
        return arrayList;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean isRegularMatrix() {
        return true;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(new IntegerDomainConcrete(1, this.values.length));
        return arrayList;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomainsIrregular() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(new IntegerDomainConcrete(1, this.values.length));
        return arrayList;
    }

    @Override
    public boolean isMatrixLiteral() {
        return true;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public int getTupleLength() {
        return this.values.length;
    }

    @Override
    public long getValueIdx(int n) {
        return this.values[n - 1];
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (!bl);
        bufferedWriter.append("[");
        for (int i = 0; i < this.values.length; ++i) {
            bufferedWriter.append(String.valueOf(this.values[i]));
            if (i >= this.values.length - 1) continue;
            bufferedWriter.append(", ");
        }
        bufferedWriter.append("]");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i >= this.values.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("[");
        for (int i = 0; i < this.values.length; ++i) {
            bufferedWriter.append(String.valueOf(this.values[i]));
            if (i >= this.values.length - 1) continue;
            bufferedWriter.append(", ");
        }
        bufferedWriter.append("]");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i >= this.values.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Domain\":");
        new IntegerDomainConcrete(1, this.values.length).toJSON(stringBuilder);
        stringBuilder.append(",\n");
        stringBuilder.append("\"Children\": [");
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.values[i] + "\n");
            if (i >= this.values.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        String string = "";
        for (int i = 0; i < this.values.length; ++i) {
            string = string + SMT.toSMTInt(this.values[i]);
            if (i >= this.values.length - 1) continue;
            string = string + " ";
        }
        return string;
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        String string = "";
        for (int i = 0; i < this.values.length; ++i) {
            string = string + SMT.toSMTBV(this.values[i]);
            if (i >= this.values.length - 1) continue;
            string = string + " ";
        }
        return string;
    }

    @Override
    public boolean childrenAreSymmetric() {
        return this.getParent().isChildSymmetric(this.getChildNo());
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL();
    }
}

