/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import savilerow.ACCSE;
import savilerow.ASTNode;
import savilerow.And;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.ConstantMatrixStore;
import savilerow.DominanceRelation;
import savilerow.FilteredDomainStore;
import savilerow.IncomparabilityFunction;
import savilerow.IntegerDomainConcrete;
import savilerow.InteractiveSATSolver;
import savilerow.InteractiveSMT;
import savilerow.InteractiveSMTSolver;
import savilerow.LessEqual;
import savilerow.MinionSolver;
import savilerow.Model;
import savilerow.ModelContainer;
import savilerow.NumberConstant;
import savilerow.SATLiteral;
import savilerow.SATSolver;
import savilerow.SMT;
import savilerow.SMTSolver;
import savilerow.Sat;
import savilerow.Solver;
import savilerow.Stats;
import savilerow.SymbolTable;
import savilerow.Top;
import savilerow.TransformCollectSATDirect;
import savilerow.TransformDistributeLogical;
import savilerow.TransformEqualConst;
import savilerow.TransformNormalise;
import savilerow.TransformQuantifiedExpression;
import savilerow.TransformSATEncoding;
import savilerow.TransformSimplify;
import savilerow.TransformSubInSolution;
import savilerow.TransformToFlat;
import savilerow.TreeTransformer;
import savilerow.TreeTransformerBottomUpNoWrapper;

public class DominanceModelContainer
extends ModelContainer {
    private Model parent;
    private Solver solver;
    private ASTNode incompOrderSign;
    private ASTNode incompPartialOrder;
    private ArrayList<IntegerDomainConcrete> iterDomains;
    private FileOutputStream fw;
    private BufferedWriter out;

    public DominanceModelContainer(Model model, ArrayList<ASTNode> arrayList, Solver solver) {
        super(model, arrayList);
        this.solver = solver;
        this.incompOrderSign = null;
        this.incompPartialOrder = null;
        this.iterDomains = new ArrayList();
        this.fw = null;
        this.out = null;
    }

    @Override
    public void process() {
        this.preprocessIncomparability();
        try {
            this.processDominance();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            CmdFlags.errorExit("Could not process dominance problem: " + iOException);
        }
    }

    private void preprocessIncomparability() {
        ASTNode aSTNode = null;
        ASTNode aSTNode2 = DominanceRelation.incl;
        ASTNode aSTNode3 = this.m.constraints.getChild(0);
        if (aSTNode3 instanceof And) {
            for (int i = 0; i < aSTNode3.numChildren() && (aSTNode == null || aSTNode2 == null); ++i) {
                Object object;
                if (!(aSTNode3.getChild(i) instanceof IncomparabilityFunction)) continue;
                if (CmdFlags.getSMTtrans()) {
                    object = new TransformEqualConst(true);
                    this.m.transform((TreeTransformer)object);
                }
                aSTNode = aSTNode3.getChild(i).getChild(0);
                this.incompPartialOrder = aSTNode3.getChild(i).getChild(1);
                if (this.incompPartialOrder instanceof CompoundMatrix) {
                    object = new ArrayList();
                    for (int j = 1; j < this.incompPartialOrder.numChildren(); ++j) {
                        ASTNode aSTNode4 = this.m.global_symbols.getDomain(this.incompPartialOrder.getChild(j).toString());
                        IntegerDomainConcrete integerDomainConcrete = (IntegerDomainConcrete)aSTNode4;
                        this.iterDomains.add(integerDomainConcrete);
                    }
                } else {
                    object = this.m.global_symbols.getDomain(this.incompPartialOrder.toString());
                    IntegerDomainConcrete integerDomainConcrete = (IntegerDomainConcrete)object;
                    this.iterDomains.add(integerDomainConcrete);
                }
                aSTNode3.setChild(i, new BooleanConstant(true));
            }
        } else if (aSTNode3 instanceof IncomparabilityFunction) {
            Object object;
            if (CmdFlags.getSMTtrans()) {
                object = new TransformEqualConst(true);
                this.m.transform((TreeTransformer)object);
            }
            aSTNode = aSTNode3.getChild(0);
            this.incompPartialOrder = aSTNode3.getChild(1);
            if (this.incompPartialOrder instanceof CompoundMatrix) {
                object = new ArrayList();
                for (int i = 1; i < this.incompPartialOrder.numChildren(); ++i) {
                    ASTNode aSTNode5 = this.m.global_symbols.getDomain(this.incompPartialOrder.getChild(i).toString());
                    IntegerDomainConcrete integerDomainConcrete = (IntegerDomainConcrete)aSTNode5;
                    this.iterDomains.add(integerDomainConcrete);
                }
            } else {
                object = this.m.global_symbols.getDomain(this.incompPartialOrder.toString());
                IntegerDomainConcrete integerDomainConcrete = (IntegerDomainConcrete)object;
                this.iterDomains.add(integerDomainConcrete);
            }
            this.m.constraints.setChild(0, new BooleanConstant(true));
        }
        if (aSTNode == null) {
            CmdFlags.println("Operating w/o IncomparabilityFunction. Might get dominated solutions.");
        }
        if (aSTNode2 == null) {
            CmdFlags.errorExit("Could not find DominanceRelation function.");
        }
        this.m.simplify();
        this.incompOrderSign = aSTNode;
    }

    private void processDominance() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.infofile, false));
        bufferedWriter.close();
        if (CmdFlags.getSattrans() && !CmdFlags.getSMTtrans()) {
            this.satOutput();
        } else if (CmdFlags.getSMTtrans()) {
            this.smtOutput();
        }
        this.cleanLastLine();
        int n = 0;
        if (this.incompOrderSign == null) {
            boolean bl = true;
            while (bl) {
                bl = this.processEachDominance(null, ++n);
            }
        } else {
            Boolean bl = this.incompOrderSign.getValue() == 0L;
            ArrayList<List<Long>> arrayList = new ArrayList<List<Long>>();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            this.combinations(arrayList, this.iterDomains, 0, arrayList2, bl);
            for (List list : arrayList) {
                if (CmdFlags.noblockDom && this.incompPartialOrder != null) {
                    boolean bl2 = true;
                    while (bl2) {
                        this.processEachDominance(list, ++n);
                        if (DominanceRelation.sollist != null && DominanceRelation.sollist.size() != 0) continue;
                        bl2 = false;
                    }
                    continue;
                }
                this.processEachDominance(list, ++n);
            }
        }
    }

    private void combinations(List<List<Long>> list, List<IntegerDomainConcrete> list2, int n, List<Long> list3, Boolean bl) {
        if (n == list2.size()) {
            list.add(new ArrayList<Long>(list3));
            return;
        }
        for (Long l : this.getValuesDomainConcrete(list2.get(n), bl)) {
            list3.add(l);
            this.combinations(list, list2, n + 1, list3, bl);
            list3.remove(list3.size() - 1);
        }
    }

    private ArrayList<Long> getValuesDomainConcrete(IntegerDomainConcrete integerDomainConcrete, boolean bl) {
        long l;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = l = bl ? integerDomainConcrete.getBounds().lower : integerDomainConcrete.getBounds().upper;
        while (integerDomainConcrete.containsValue(l)) {
            arrayList.add(l);
            l = bl ? l + 1L : l - 1L;
        }
        return arrayList;
    }

    private boolean processEachDominance(List<Long> list, long l) throws IOException {
        ASTNode aSTNode = this.constructIncompConstraint(list);
        this.reOpenFiles();
        boolean bl = this.encodeNewDominanceConstrainsts(l);
        if (!bl) {
            return false;
        }
        this.markModelAndClean();
        if (list != null) {
            this.encodeIncompConst(aSTNode);
        }
        this.finaliseAndRunSolver(list);
        this.restoreModel();
        return true;
    }

    private ASTNode constructIncompConstraint(List<Long> list) throws IOException {
        ASTNode aSTNode = new BooleanConstant(true);
        if (list != null) {
            Object object;
            CmdFlags.println("Looking for solution on incomp value(s): " + list);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.infofile, true));
            bufferedWriter.write("Partial order: " + String.valueOf(list) + "\n");
            bufferedWriter.close();
            if (list.size() == 1) {
                object = new LessEqual(this.incompPartialOrder, NumberConstant.make(list.get(0)));
                LessEqual lessEqual = new LessEqual((ASTNode)NumberConstant.make(list.get(0)), this.incompPartialOrder);
                ASTNode[] aSTNodeArray = new ASTNode[]{aSTNode, object, lessEqual};
                aSTNode = new And(aSTNodeArray);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    LessEqual lessEqual = new LessEqual(this.incompPartialOrder.getChild(i + 1), NumberConstant.make(list.get(i)));
                    LessEqual lessEqual2 = new LessEqual((ASTNode)NumberConstant.make(list.get(i)), this.incompPartialOrder.getChild(i + 1));
                    ASTNode[] aSTNodeArray = new ASTNode[]{aSTNode, lessEqual, lessEqual2};
                    aSTNode = new And(aSTNodeArray);
                }
            }
            object = new TransformSimplify();
            aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode);
        }
        return aSTNode;
    }

    private void reOpenFiles() throws IOException {
        if ((CmdFlags.getSattrans() || CmdFlags.getSMTtrans()) && !CmdFlags.interactiveSolver) {
            this.m.satModel.reopenFile();
        } else if (this.solver instanceof MinionSolver) {
            this.fw = new FileOutputStream(CmdFlags.minionfile, true);
            this.out = new BufferedWriter(new OutputStreamWriter(this.fw));
        }
    }

    private void cleanLastLine() throws IOException {
        if (this.solver instanceof MinionSolver) {
            this.m.BTRemoveLastLine();
        } else if (CmdFlags.getSMTtrans()) {
            ((SMT)this.m.satModel).removeSolvingInstructions();
        }
    }

    private void markModelAndClean() throws IOException {
        if ((CmdFlags.getSattrans() || CmdFlags.getSMTtrans()) && !CmdFlags.interactiveSolver) {
            this.m.satModel.BTMark();
        }
        if (this.solver instanceof MinionSolver) {
            this.m.BTMark();
        }
        if (DominanceRelation.sollist != null) {
            DominanceRelation.sollist.clear();
        }
    }

    private void restoreModel() throws IOException {
        if ((CmdFlags.getSattrans() || CmdFlags.getSMTtrans()) && !CmdFlags.interactiveSolver) {
            this.m.satModel.BTRestore();
        } else if (this.solver instanceof MinionSolver) {
            this.m.BTRestore();
        }
    }

    private boolean encodeNewDominanceConstrainsts(long l) throws IOException {
        ASTNode aSTNode = DominanceRelation.incl;
        if (DominanceRelation.sollist != null && DominanceRelation.sollist.size() > 0) {
            Object object;
            if (this.incompPartialOrder == null) {
                return false;
            }
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
            TransformSimplify transformSimplify = new TransformSimplify();
            HashMap<String, ASTNode> hashMap = new HashMap<String, ASTNode>();
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            for (int i = 0; i < DominanceRelation.sollist.size(); ++i) {
                object = DominanceRelation.sollist.get(i);
                ASTNode aSTNode2 = aSTNode.copy();
                for (int j = 0; j < ((ASTNode)object).numChildren(); ++j) {
                    hashMap.put(((ASTNode)object).getChild(j).getChild(0).toString(), ((ASTNode)object).getChild(j).getChild(1));
                }
                TransformSubInSolution transformSubInSolution = new TransformSubInSolution(hashMap);
                aSTNode2 = transformSubInSolution.transform(aSTNode2);
                aSTNode2 = transformSimplify.transform(transformQuantifiedExpression.transform(transformSimplify.transform(aSTNode2)));
                arrayList.add(aSTNode2);
            }
            if (arrayList.size() > 0) {
                Top top = new Top(new And(arrayList));
                object = this.prepareSubModel(top);
                if (CmdFlags.dom_flatten_strategy.equals("full")) {
                    this.flattenDominanceConstraintsFull(top);
                } else if (CmdFlags.dom_flatten_strategy.equals("semi")) {
                    this.flattenDominanceConstraintsSemi(top);
                } else if (CmdFlags.dom_flatten_strategy.equals("basic")) {
                    this.flattenDominanceConstraintsNaive(top);
                }
            }
        } else if (this.incompPartialOrder == null && l != 1L) {
            return false;
        }
        return true;
    }

    private void flattenDominanceConstraintsNaive(ASTNode aSTNode) throws IOException {
        TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
        TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
        TransformSimplify transformSimplify = new TransformSimplify();
        if (!CmdFlags.compressDominance) {
            if (CmdFlags.getSattrans()) {
                aSTNode = transformSATEncoding.transform(aSTNode);
                TransformDistributeLogical transformDistributeLogical = new TransformDistributeLogical(false, false);
                aSTNode = transformDistributeLogical.transform(aSTNode);
                aSTNode = transformSimplify.transform(transformQuantifiedExpression.transform(transformSimplify.transform(aSTNode)));
                aSTNode.toSAT(this.m.satModel);
                if (!CmdFlags.interactiveSolver) {
                    this.m.satModel.finaliseOutput();
                }
            } else if (this.solver instanceof MinionSolver) {
                aSTNode.toMinion(this.out, true);
                this.out.append("\n");
            } else if (CmdFlags.getSMTtrans()) assert (false);
        } else {
            CmdFlags.errorExit("This flattening cannot do accse.");
        }
    }

    private void flattenDominanceConstraintsSemi(ASTNode aSTNode) throws IOException {
        Object object;
        TreeTransformer treeTransformer;
        Model model = this.prepareSubModel(aSTNode);
        if (CmdFlags.compressDominance) {
            treeTransformer = new TransformNormalise(model);
            model.transform(treeTransformer);
            model.simplify();
            object = new ACCSE();
            ((ACCSE)object).flattenCSEs(model, "\\/");
            System.out.println("AC-CSE-Or_number " + ((ACCSE)object).numcse);
            System.out.println("AC-CSE-Or_eliminated_expressions " + ((ACCSE)object).countcse);
            System.out.println("AC-CSE-Or_total_size " + ((ACCSE)object).totallength);
            ((ACCSE)object).flattenCSEs(model, "/\\");
            System.out.println("AC-CSE-And_number " + ((ACCSE)object).numcse);
            System.out.println("AC-CSE-And_eliminated_expressions " + ((ACCSE)object).countcse);
            System.out.println("AC-CSE-And_total_size " + ((ACCSE)object).totallength);
        }
        treeTransformer = new TransformToFlat(model, true);
        model.transform(treeTransformer);
        if (CmdFlags.getSattrans()) {
            object = new TransformCollectSATDirect(model);
            ((TreeTransformerBottomUpNoWrapper)object).transform(model.constraints);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(model);
            TransformDistributeLogical transformDistributeLogical = new TransformDistributeLogical(false, false);
            model.constraints = transformDistributeLogical.transform(model.constraints);
            TransformSimplify transformSimplify = new TransformSimplify();
            model.constraints = transformSimplify.transform(transformQuantifiedExpression.transform(transformSimplify.transform(model.constraints)));
            model.satModel.generateVariableEncoding(((TransformCollectSATDirect)object).getVarsInConstraints(), false);
            TransformSATEncoding transformSATEncoding = new TransformSATEncoding(model);
            model.constraints = transformSATEncoding.transform(model.constraints);
            model.toSAT();
            this.m.satModel.variableNumber = model.satModel.variableNumber;
            this.m.satModel.numClauses += model.satModel.numClauses;
        } else if (this.solver instanceof MinionSolver) {
            model.toMinion(this.out, false);
            this.out.append("\n");
        } else if (CmdFlags.getSMTtrans()) assert (false);
    }

    private void flattenDominanceConstraintsFull(ASTNode aSTNode) throws IOException {
        Model model = this.prepareSubModel(aSTNode);
        this.parent = this.m;
        this.m = model;
        this.instancePreFlattening1();
        this.instancePreFlattening2(false);
        this.instanceFlattening(false);
        this.postFlattening(false);
        this.m = this.parent;
        if (CmdFlags.getSattrans() && !CmdFlags.getSMTtrans()) {
            model.toSAT();
        } else if (this.solver instanceof MinionSolver) {
            model.toMinion(this.out, false);
            this.cleanLastLine();
            this.out.append("\n");
        } else if (CmdFlags.getSMTtrans()) {
            model.toSMT();
        }
    }

    private Model prepareSubModel(ASTNode aSTNode) {
        Model model = new Model();
        model.subModelFlag = true;
        SymbolTable symbolTable = this.m.global_symbols;
        FilteredDomainStore filteredDomainStore = this.m.filt.copy(symbolTable);
        ConstantMatrixStore constantMatrixStore = this.m.cmstore;
        model.setup(aSTNode, symbolTable, filteredDomainStore, constantMatrixStore, null, null, null, null, null);
        if (CmdFlags.getSattrans() && !CmdFlags.interactiveSolver && !CmdFlags.getSMTtrans()) {
            model.satModel = new Sat(this.m.satModel);
        } else if (CmdFlags.getSattrans() && CmdFlags.interactiveSolver && !CmdFlags.getSMTtrans()) {
            model.satModel = this.m.satModel;
        } else if (CmdFlags.getSMTtrans() && !CmdFlags.interactiveSolver) {
            model.satModel = new SMT((SMT)this.m.satModel);
        } else if (CmdFlags.getSMTtrans() && CmdFlags.interactiveSolver) {
            model.satModel = (InteractiveSMT)this.m.satModel;
        }
        return model;
    }

    private void encodeIncompConst(ASTNode aSTNode) throws IOException {
        if (CmdFlags.getSattrans() && !CmdFlags.interactiveSolver && !CmdFlags.getSMTtrans()) {
            this.m.satModel.reopenFile();
            TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
            aSTNode = transformSATEncoding.transform(aSTNode);
            aSTNode.toSAT(this.m.satModel);
            this.m.satModel.finaliseOutput();
        } else if (CmdFlags.getSMTtrans() && !CmdFlags.interactiveSolver) {
            this.m.satModel.reopenFile();
            TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
            aSTNode = transformSATEncoding.transform(aSTNode);
            aSTNode.toSMT((SMT)this.m.satModel);
            this.m.satModel.finaliseOutput();
        } else if (this.solver instanceof MinionSolver) {
            this.fw = new FileOutputStream(CmdFlags.minionfile, true);
            this.out = new BufferedWriter(new OutputStreamWriter(this.fw));
            aSTNode.toMinion(this.out, true);
            this.out.append("\n");
            this.m.finaliseOutput(this.out, this.fw);
        } else if (CmdFlags.getSattrans() && CmdFlags.interactiveSolver && !CmdFlags.getSMTtrans()) {
            TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
            aSTNode = transformSATEncoding.transform(aSTNode);
            assert (aSTNode instanceof And || aSTNode instanceof SATLiteral);
            if (aSTNode instanceof And) {
                for (int i = 0; i < aSTNode.numChildren(); ++i) {
                    ASTNode aSTNode2 = aSTNode.getChild(i);
                    assert (aSTNode2 instanceof SATLiteral);
                    ((SATLiteral)aSTNode2).toSATAssumption(this.m.satModel);
                }
            } else {
                ((SATLiteral)aSTNode).toSATAssumption(this.m.satModel);
            }
        } else if (CmdFlags.getSMTtrans() && CmdFlags.interactiveSolver) {
            TransformSATEncoding transformSATEncoding = new TransformSATEncoding(this.m);
            aSTNode = transformSATEncoding.transform(aSTNode);
            assert (aSTNode instanceof And || aSTNode instanceof LessEqual);
            if (aSTNode instanceof And) {
                for (int i = 0; i < aSTNode.numChildren(); ++i) {
                    ASTNode aSTNode3 = aSTNode.getChild(i);
                    assert (aSTNode3 instanceof LessEqual);
                    ((InteractiveSMT)this.m.satModel).addSMTAssumption(((LessEqual)aSTNode3).smtEncodeBool((SMT)this.m.satModel));
                }
            } else {
                assert (aSTNode instanceof LessEqual);
                ((InteractiveSMT)this.m.satModel).addSMTAssumption(((LessEqual)aSTNode).smtEncodeBool((SMT)this.m.satModel));
            }
        }
    }

    private void finaliseAndRunSolver(List<Long> list) throws IOException {
        try {
            if (CmdFlags.getSattrans() && CmdFlags.noblockDom && this.incompPartialOrder != null && !CmdFlags.getSMTtrans()) {
                if (!CmdFlags.interactiveSolver) {
                    System.out.println("Dimacs file size: " + Files.size(Paths.get(CmdFlags.satfile, new String[0])) + " in " + list);
                }
                ((SATSolver)this.solver).findOneSolution(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
            } else if (CmdFlags.getSattrans() && !CmdFlags.interactiveSolver && !CmdFlags.getSMTtrans()) {
                System.out.println("Dimacs file size: " + Files.size(Paths.get(CmdFlags.satfile, new String[0])) + " in " + list);
                if (CmdFlags.getVerbose()) {
                    Files.deleteIfExists(Paths.get(CmdFlags.satfile + "-" + list, new String[0]));
                    Files.copy(Paths.get(CmdFlags.satfile, new String[0]), Paths.get(CmdFlags.satfile + "-" + list, new String[0]), new CopyOption[0]);
                }
                this.solver.findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
            } else if (CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans()) {
                this.out = new BufferedWriter(new FileWriter(CmdFlags.fznfile));
                this.m.toFlatzinc(this.out);
                if (CmdFlags.getVerbose()) {
                    Files.deleteIfExists(Paths.get(CmdFlags.fznfile + "-" + list, new String[0]));
                    Files.copy(Paths.get(CmdFlags.fznfile, new String[0]), Paths.get(CmdFlags.fznfile + "-" + list, new String[0]), new CopyOption[0]);
                }
                String string = CmdFlags.getFznSolver();
                this.solver.findSolutions(string, CmdFlags.fznfile, this.m);
            } else if (this.solver instanceof MinionSolver) {
                this.fw = new FileOutputStream(CmdFlags.minionfile, true);
                this.out = new BufferedWriter(new OutputStreamWriter(this.fw));
                this.out.append("**EOF**\n");
                this.m.finaliseOutput(this.out, this.fw);
                System.out.println("Minion file size: " + Files.size(Paths.get(CmdFlags.minionfile, new String[0])) + " in " + list);
                if (CmdFlags.getVerbose()) {
                    Files.deleteIfExists(Paths.get(CmdFlags.minionfile + "-" + list, new String[0]));
                    Files.copy(Paths.get(CmdFlags.minionfile, new String[0]), Paths.get(CmdFlags.minionfile + "-" + list, new String[0]), new CopyOption[0]);
                }
                this.solver.findSolutions(CmdFlags.getMinion(), CmdFlags.minionfile, this.m);
            } else if (this.solver instanceof InteractiveSATSolver) {
                this.solver.findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
                ((InteractiveSATSolver)this.solver).cleanAssumptionQueue();
            } else if (CmdFlags.getSMTtrans() && !CmdFlags.interactiveSolver) {
                System.out.println("SMT file size: " + Files.size(Paths.get(CmdFlags.smtfile, new String[0])) + " in " + list);
                if (CmdFlags.getVerbose()) {
                    Files.deleteIfExists(Paths.get(CmdFlags.smtfile + "-" + list, new String[0]));
                    Files.copy(Paths.get(CmdFlags.smtfile, new String[0]), Paths.get(CmdFlags.smtfile + "-" + list, new String[0]), new CopyOption[0]);
                }
                ((SMTSolver)this.solver).findSolutions(CmdFlags.getSMTSolverPath(), CmdFlags.smtfile, this.m);
            } else if (CmdFlags.getSMTtrans() && CmdFlags.interactiveSolver) {
                ((InteractiveSMTSolver)this.solver).findSolutions(CmdFlags.getSMTSolverPath(), CmdFlags.smtfile, this.m);
            }
        }
        catch (InterruptedException interruptedException) {
            CmdFlags.errorExit("Could not run the solver: " + interruptedException);
        }
    }

    private void satOutput() {
        boolean bl = this.m.toSAT();
        if (!bl) {
            Stats stats = new Stats();
            stats.putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
            stats.putValue("SavileRowClauseOut", "1");
            stats.makeInfoFiles();
            CmdFlags.errorExit("Failed when writing SAT encoding.");
        }
    }
}

