/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import savilerow.ASTNode;
import savilerow.BitVector;
import savilerow.CmdFlags;
import savilerow.Identifier;
import savilerow.Intpair;
import savilerow.Minimising;
import savilerow.Sat;
import savilerow.SymbolTable;

public class SMT
extends Sat {
    private static final long CHECK_SAT_LENGTH = ("(check-sat)" + System.lineSeparator()).length();
    protected List<String> variables;
    protected Set<String> integer_aux_variables;
    private long checkSatLocation = 0L;

    public SMT(SymbolTable symbolTable) {
        super(symbolTable);
        try {
            this.trueVar = this.getNextVariableNumber();
            this.addClause(this.trueVar);
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Failed to write to SMT output file.");
        }
        this.integer_aux_variables = new HashSet<String>();
    }

    public SMT(SMT sMT) {
        super(sMT);
        this.variables = sMT.variables;
        this.integer_aux_variables = sMT.integer_aux_variables;
    }

    @Override
    protected void createHeader() throws IOException {
        this.addInfo("smt-lib-version", "2.6");
        this.addInfo("source", "| Auto-generated by Savile Row |");
        this.addLogic(CmdFlags.getLogic().toString());
        if (!CmdFlags.usingBoolector()) {
            this.addOption("random-seed", CmdFlags.smtseed);
        }
    }

    public void addInfo(String string, String string2) throws IOException {
        this.outstream.write("(set-info :" + string + " " + string2 + ")");
        this.outstream.newLine();
    }

    public void addLogic(String string) throws IOException {
        this.outstream.write("(set-logic " + string + ")");
        this.outstream.newLine();
    }

    public void addOption(String string, String string2) throws IOException {
        this.outstream.write("(set-option :" + string + " " + string2 + ")");
        this.outstream.newLine();
    }

    public void addVariable(String string, String string2) throws IOException {
        this.outstream.write("(declare-fun " + string + " () " + string2 + ")");
        this.outstream.newLine();
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }
        this.variables.add(string);
    }

    @Override
    protected long getNextVariableNumber() {
        long l = super.getNextVariableNumber();
        try {
            this.addVariable("x" + String.valueOf(l), "Bool");
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Failed to open or write to SMT output file.");
        }
        return l;
    }

    @Override
    public void generateVariableEncoding1Val(String string, boolean bl) throws IOException {
        long l;
        Intpair intpair;
        ASTNode aSTNode;
        if (this.global_symbols.isBoolean(string)) {
            super.generateVariableEncoding1Val(string, false);
        }
        if (this.global_symbols.isInteger(string)) {
            this.addVariable(string, "Int");
            aSTNode = this.global_symbols.getDomain(string);
            intpair = aSTNode.getBounds();
            l = intpair.lower;
            this.addSMTClause("(= " + string + " " + SMT.toSMTInt(l) + ")");
        }
        if (this.global_symbols.isBitVector(string)) {
            this.addVariable(string, "(_ BitVec " + BitVector.getBits() + ")");
            aSTNode = this.global_symbols.getDomain(string);
            intpair = aSTNode.getBounds();
            l = intpair.lower;
            this.addSMTClause("(= " + string + " " + SMT.toSMTBV(l) + ")");
        }
    }

    @Override
    public void generateVariableEncoding2Vals(String string, boolean bl, boolean bl2) throws IOException {
        long l;
        long l2;
        long l3;
        Intpair intpair;
        ASTNode aSTNode;
        if (bl) {
            if (CmdFlags.getUseBV()) {
                this.global_symbols.markAsBitVector(string);
            } else if (CmdFlags.getUseInt()) {
                this.global_symbols.markAsInteger(string);
            } else {
                this.global_symbols.markAsBoolean(string);
            }
        }
        if (this.global_symbols.isBoolean(string)) {
            super.generateVariableEncoding2Vals(string, bl, false);
        }
        if (this.global_symbols.isInteger(string)) {
            this.addVariable(string, "Int");
            aSTNode = this.global_symbols.getDomain(string);
            intpair = aSTNode.getBounds();
            l3 = intpair.lower;
            l2 = intpair.upper;
            if (this.global_symbols.isBoolean(string)) {
                l = this.getOrderVariable(string, l3);
                this.addSMTClause("(ite" + SMT.toLiteral(l) + " (= " + string + " " + SMT.toSMTInt(l3) + ") (= " + string + " " + SMT.toSMTInt(l2) + "))");
            } else {
                this.addSMTClause("(or (= " + string + " " + SMT.toSMTInt(l3) + ") (= " + string + " " + SMT.toSMTInt(l2) + "))");
            }
        }
        if (this.global_symbols.isBitVector(string)) {
            this.addVariable(string, "(_ BitVec " + BitVector.getBits() + ")");
            aSTNode = this.global_symbols.getDomain(string);
            intpair = aSTNode.getBounds();
            l3 = intpair.lower;
            l2 = intpair.upper;
            if (this.global_symbols.isBoolean(string)) {
                l = this.getOrderVariable(string, l3);
                this.addSMTClause("(ite" + SMT.toLiteral(l) + " (= " + string + " " + SMT.toSMTBV(l3) + ") (= " + string + " " + SMT.toSMTBV(l2) + "))");
            } else {
                this.addSMTClause("(or (= " + string + " " + SMT.toSMTBV(l3) + ") (= " + string + " " + SMT.toSMTBV(l2) + "))");
            }
        }
    }

    @Override
    public void generateVariableEncodingNVals(String string, boolean bl) throws IOException {
        ArrayList<Intpair> arrayList;
        ASTNode aSTNode;
        if (this.global_symbols.isBoolean(string)) {
            super.generateVariableEncodingNVals(string, false);
        }
        if (this.global_symbols.isInteger(string)) {
            String string2;
            this.addVariable(string, "Int");
            aSTNode = this.global_symbols.getDomain(string);
            arrayList = aSTNode.getIntervalSet();
            if (arrayList.size() > 1) {
                string2 = "(or";
                for (Intpair intpair : arrayList) {
                    if (intpair.lower == intpair.upper) {
                        string2 = string2 + " (= " + SMT.toSMTInt(intpair.lower) + " " + string + ")";
                        continue;
                    }
                    string2 = string2 + " (<= " + SMT.toSMTInt(intpair.lower) + " " + string + " " + SMT.toSMTInt(intpair.upper) + ")";
                }
                this.addSMTClause(string2 + ")");
            } else {
                string2 = "";
                string2 = arrayList.get((int)0).lower == arrayList.get((int)0).upper ? string2 + "(= " + SMT.toSMTInt(arrayList.get((int)0).lower) + " " + string + ")" : string2 + "(<= " + SMT.toSMTInt(arrayList.get((int)0).lower) + " " + string + " " + SMT.toSMTInt(arrayList.get((int)0).upper) + ")";
                this.addSMTClause(string2);
            }
            if (this.global_symbols.isBoolean(string)) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Intpair intpair = arrayList.get(i);
                    for (long j = intpair.lower; j <= intpair.upper; ++j) {
                        long l = this.getOrderVariable(string, j);
                        if (l == this.getTrue()) continue;
                        this.addSMTClause("(ite" + SMT.toLiteral(l) + " (<= " + string + " " + SMT.toSMTInt(j) + ") (> " + string + " " + SMT.toSMTInt(j) + "))");
                    }
                }
            }
        }
        if (this.global_symbols.isBitVector(string)) {
            this.addVariable(string, "(_ BitVec " + BitVector.getBits() + ")");
            aSTNode = this.global_symbols.getDomain(string);
            arrayList = aSTNode.getIntervalSet();
            String string3 = "";
            int n = arrayList.size();
            if (n > 1) {
                string3 = "(or";
            }
            for (Intpair intpair : arrayList) {
                if (n > 1) {
                    string3 = string3 + " ";
                }
                if (intpair.lower == intpair.upper) {
                    string3 = string3 + "(= " + SMT.toSMTBV(intpair.lower) + " " + string + ")";
                    continue;
                }
                string3 = string3 + "(and (bvsle " + SMT.toSMTBV(intpair.lower) + " " + string + ") (bvsle " + string + " " + SMT.toSMTBV(intpair.upper) + "))";
            }
            if (n > 1) {
                string3 = string3 + ")";
            }
            this.addSMTClause(string3);
            if (this.global_symbols.isBoolean(string)) {
                for (n = 0; n < arrayList.size(); ++n) {
                    Intpair intpair = arrayList.get(n);
                    for (long i = intpair.lower; i <= intpair.upper; ++i) {
                        long l = this.getOrderVariable(string, i);
                        if (l == this.getTrue()) continue;
                        this.addSMTClause("(ite" + SMT.toLiteral(l) + " (bvsle " + string + " " + SMT.toSMTBV(i) + ") (bvsgt " + string + " " + SMT.toSMTBV(i) + "))");
                    }
                }
            }
        }
    }

    public String createAuxSMTVariableFor(ASTNode aSTNode, long l) throws IOException {
        boolean bl;
        if (!(aSTNode instanceof Identifier)) {
            CmdFlags.errorExit("Attempted to create an auxiliary SMT variable for " + aSTNode.toString() + " which is not an identifier");
        }
        if (!CmdFlags.getUseAuxSMT()) {
            CmdFlags.errorExit("Attempted to create an auxiliary SMT variable when they are not allowed");
        }
        String string = aSTNode.smtEncodeInt(this);
        if (l == 1L) {
            CmdFlags.warning("Trying to create an auxiliary variable for " + string + " with multiplier 1");
            return string;
        }
        String string2 = "_" + l + "_" + string;
        boolean bl2 = bl = aSTNode.isRelation() && this.global_symbols.isBoolean(aSTNode.toString());
        if (bl) {
            string2 = "_" + l + "_" + aSTNode.toString();
        }
        if (!this.integer_aux_variables.contains(string2)) {
            if (!this.variables.contains(string) && !bl) {
                CmdFlags.errorExit("The auxiliary variable " + string2 + "could not be created because " + string + " has not been defined");
            }
            this.addComment("Adding auxiliary variable " + string2 + " which will have the value of " + l + " * " + string);
            this.addVariable(string2, "Int");
            ASTNode aSTNode2 = this.global_symbols.getDomain(aSTNode.toString());
            ArrayList<Intpair> arrayList = aSTNode2.getIntervalSet();
            for (Intpair intpair : arrayList) {
                for (long i = intpair.lower; i <= intpair.upper; ++i) {
                    String string3 = SMT.toSMTInt(i);
                    String string4 = SMT.toSMTInt(i * l);
                    this.addSMTClause("(ite (= " + string + " " + string3 + ") (= " + string2 + " " + string4 + ") (distinct " + string2 + " " + string4 + "))");
                }
            }
            this.integer_aux_variables.add(string2);
        }
        return string2;
    }

    protected void unitClauseStart() throws IOException {
        this.outstream.write("(assert");
    }

    @Override
    protected void clauseStart() throws IOException {
        this.outstream.write("(assert (or");
    }

    protected void unitClauseEnd() throws IOException {
        this.outstream.write(")");
        this.outstream.newLine();
    }

    @Override
    protected void clauseEnd() throws IOException {
        this.outstream.write("))");
        this.outstream.newLine();
    }

    protected void addEmptyClause() throws IOException {
        this.outstream.write("(assert false)\n");
    }

    @Override
    public void addClause(long l) throws IOException {
        if (l != -this.trueVar) {
            this.unitClauseStart();
            this.writeLiteral(l);
            this.unitClauseEnd();
        } else {
            this.addEmptyClause();
        }
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    @Override
    public void addClause(long l, long l2) throws IOException {
        if (l == -this.trueVar) {
            this.addClause(l2);
        } else if (l2 == -this.trueVar) {
            this.addClause(l);
        } else if (l == -this.trueVar && l2 == -this.trueVar) {
            this.addEmptyClause();
        } else {
            super.addClause(l, l2);
        }
    }

    @Override
    public void addClause(long l, long l2, long l3) throws IOException {
        if (l == -this.trueVar && l2 == -this.trueVar) {
            this.addClause(l3);
        } else if (l == -this.trueVar && l3 == -this.trueVar) {
            this.addClause(l2);
        } else if (l2 == -this.trueVar && l3 == -this.trueVar) {
            this.addClause(l);
        } else if (l == -this.trueVar && l2 == -this.trueVar && l3 == -this.trueVar) {
            this.addEmptyClause();
        } else {
            super.addClause(l, l2, l3);
        }
    }

    @Override
    public void addClause(ArrayList<Long> arrayList) throws IOException {
        if (arrayList.size() == 0) {
            this.addEmptyClause();
        } else if (arrayList.size() == 1) {
            this.addClause(arrayList.get(0));
        } else {
            super.addClause(arrayList);
        }
    }

    @Override
    public void addClauseReified(ArrayList<Long> arrayList, long l) throws IOException {
        if (arrayList.size() == 0) {
            this.addClause(-l);
        } else {
            super.addClauseReified(arrayList, l);
        }
    }

    public static String toLiteral(long l) {
        if (l > 0L) {
            return " x" + String.valueOf(l);
        }
        return " (not x" + String.valueOf(-l) + ")";
    }

    public static String toSMTInt(long l) {
        if (l < 0L) {
            return "(- " + Long.toString(-l) + ")";
        }
        return Long.toString(l);
    }

    public static String toSMTBV(long l) {
        return BitVector.toHexString(l);
    }

    @Override
    protected void writeLiteral(long l) throws IOException {
        this.outstream.write(SMT.toLiteral(l));
    }

    @Override
    public void addComment(String string) throws IOException {
        this.outstream.write("; ");
        this.outstream.write(string);
        this.outstream.newLine();
    }

    @Override
    public void finaliseOutput() throws IOException {
        this.outstream.flush();
        this.checkSatLocation = this.fw.getChannel().position();
        this.outstream.write("(check-sat)");
        this.outstream.newLine();
        this.addComment("Adding commands to receive the value of the variables");
        for (String string : this.variables) {
            this.outstream.write("(get-value (" + string + "))");
            this.outstream.newLine();
        }
        if (!CmdFlags.usingBoolector()) {
            this.outstream.write("(get-info :all-statistics)");
        }
        this.outstream.newLine();
        this.outstream.flush();
        this.fw.getFD().sync();
        this.outstream.close();
    }

    public static boolean checkParenthesis(String string) {
        if (string.length() == 0) {
            CmdFlags.typeError("Trying to add an empty clause");
            return false;
        }
        if (string.charAt(0) != '(' || string.charAt(string.length() - 1) != ')') {
            CmdFlags.typeError("The following clause is not completely inside parenthesis: " + string);
            return false;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                ++n;
            } else if (string.charAt(i) == ')') {
                --n;
            }
            if (n > 0 || i >= string.length() - 1) continue;
            CmdFlags.typeError("The clause is closed before the end (multiple clauses): " + string);
            return false;
        }
        if (n > 0) {
            CmdFlags.typeError("Not all the opened parenthesis are closed for this clause: " + string);
            return false;
        }
        return true;
    }

    public void addObjective(ASTNode aSTNode) throws IOException {
        assert (aSTNode.getChild(0) instanceof Identifier);
        if (aSTNode instanceof Minimising) {
            this.outstream.write("(minimize " + ((Identifier)aSTNode.getChild(0)).getName() + ")\n");
        } else {
            this.outstream.write("(maximize " + ((Identifier)aSTNode.getChild(0)).getName() + ")\n");
        }
    }

    public void addSMTClause(String string) throws IOException {
        if (string == null) {
            this.outstream.close();
            System.exit(0);
        }
        assert (SMT.checkParenthesis(string));
        this.outstream.write("(assert ");
        this.outstream.write(string);
        this.outstream.write(")");
        this.outstream.newLine();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    @Override
    public void removeFinalClause() throws IOException {
        assert (!CmdFlags.interactiveSolver);
        RandomAccessFile randomAccessFile = new RandomAccessFile(CmdFlags.smtfile, "rws");
        randomAccessFile.setLength(this.filesizeBackup);
        randomAccessFile.close();
        this.numClauses = this.numClausesBackup;
        this.fw = new FileOutputStream(CmdFlags.smtfile, true);
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.finaliseOutput();
    }

    public void removeSolvingInstructions() throws IOException {
        assert (!CmdFlags.interactiveSolver);
        RandomAccessFile randomAccessFile = new RandomAccessFile(CmdFlags.smtfile, "rw");
        randomAccessFile.setLength(this.checkSatLocation);
        randomAccessFile.close();
    }

    @Override
    public void addClauseAfterFinalise(ArrayList<Long> arrayList) throws IOException {
        assert (!CmdFlags.interactiveSolver);
        this.removeSolvingInstructions();
        super.addClauseAfterFinalise(arrayList);
    }

    @Override
    public void addClauseAfterFinalise(long l, boolean bl) throws IOException {
        assert (!CmdFlags.interactiveSolver);
        this.removeSolvingInstructions();
        super.addClauseAfterFinalise(l, false);
    }

    @Override
    public void addClauseAfterFinalise2(long l, long l2, boolean bl) throws IOException {
        assert (!CmdFlags.interactiveSolver);
        this.removeSolvingInstructions();
        super.addClauseAfterFinalise2(l, l2, false);
    }

    public void addSMTClauseAfterFinalise(String string, boolean bl) throws IOException {
        assert (!CmdFlags.interactiveSolver);
        this.removeSolvingInstructions();
        this.fw = new FileOutputStream(CmdFlags.smtfile, true);
        this.numClausesBackup = this.numClauses;
        this.filesizeBackup = this.fw.getChannel().position();
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.addSMTClause(string);
        this.finaliseOutput();
    }

    public void addSMTClauseAfterFinalise2(String string, String string2, boolean bl) throws IOException {
        assert (!CmdFlags.interactiveSolver);
        this.removeSolvingInstructions();
        this.fw = new FileOutputStream(CmdFlags.smtfile, true);
        this.numClausesBackup = this.numClauses;
        this.filesizeBackup = this.fw.getChannel().position();
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.addSMTClause(string);
        this.addSMTClause(string2);
        this.finaliseOutput();
    }

    @Override
    public long getNumVars() {
        return this.variables.size();
    }
}

