/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Constants;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.WeightedSum;
import savilerow.model.SMT;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Times
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Times(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    public Times(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public Times(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    @Override
    public ASTNode copy() {
        return new Times(this.getChildrenArray());
    }

    @Override
    public ASTNode simplify() {
        int n;
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = false;
        long l = 1L;
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n).isConstant()) {
                if (l != 1L) {
                    bl = true;
                }
                l = Times.multiply(l, arrayList.get(n).getValue());
                arrayList.remove(n);
                --n;
                continue;
            }
            if (CmdFlags.getOutputReady() || !(arrayList.get(n) instanceof Times)) continue;
            bl = true;
            arrayList.addAll(arrayList.get(n).getChildren());
            arrayList.remove(n);
            --n;
        }
        if (l == 0L) {
            return NumberConstant.make(0L);
        }
        if (arrayList.size() == 0) {
            return NumberConstant.make(l);
        }
        if (arrayList.size() == 1) {
            arrayList.get(0).setParent(null);
            if (l == 1L) {
                return arrayList.get(0);
            }
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            arrayList2.add(l);
            return new WeightedSum(arrayList, arrayList2);
        }
        if (l != 1L) {
            arrayList.add(NumberConstant.make(l));
        }
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList.get(n).setParent(null);
            }
            return new Times(arrayList);
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() > 0) {
                CmdFlags.println("ERROR: Unexpected matrix in product: " + this);
                return false;
            }
            if (!this.getChild(i).isSet()) continue;
            CmdFlags.println("ERROR: Unexpected set in product: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Times.sortByHashcode(arrayList);
        if (bl) {
            return new Times(arrayList);
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Times.sortByAlpha(arrayList);
        if (bl) {
            return new Times(arrayList);
        }
        return null;
    }

    @Override
    public long getValue() {
        long l = 1L;
        for (int i = 0; i < this.numChildren(); ++i) {
            assert (this.getChild(i).isConstant());
            l = Times.multiply(l, this.getChild(i).getValue());
        }
        return l;
    }

    static long multiply(long l, long l2) {
        return Intpair.BigIntegerToLong(BigInteger.valueOf(l).multiply(BigInteger.valueOf(l2)));
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        for (int i = 1; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            long l = Times.multiply(intpair.lower, intpair2.lower);
            long l2 = Times.multiply(intpair.upper, intpair2.lower);
            long l3 = Times.multiply(intpair.lower, intpair2.upper);
            long l4 = Times.multiply(intpair.upper, intpair2.upper);
            intpair.lower = Math.min(l, Math.min(l2, Math.min(l3, l4)));
            intpair.upper = Math.max(l, Math.max(l2, Math.max(l3, l4)));
        }
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        if (this.numChildren() > 2) {
            return super.getIntervalSetExp();
        }
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        if (Intpair.numValues(arrayList) * Intpair.numValues(arrayList2) > (long)Constants.intervallim) {
            return super.getIntervalSetExp();
        }
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                for (int k = 0; k < arrayList2.size(); ++k) {
                    for (long i2 = arrayList2.get((int)k).lower; i2 <= arrayList2.get((int)k).upper; ++i2) {
                        long l = j * i2;
                        arrayList3.add(new Intpair(l, l));
                    }
                }
            }
        }
        Intpair.normalise(arrayList3);
        return arrayList3;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isCommAssoc() {
        return true;
    }

    @Override
    public String toString() {
        String string = "(";
        for (int i = 0; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + " * ";
        }
        return string + ")";
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        assert (this.numChildren() == 2);
        bufferedWriter.append("product(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        assert (this.numChildren() == 2);
        bufferedWriter.append("constraint int_times(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (this.numChildren() == 2);
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("*");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return this.func(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        return Times.multiply(l, l2);
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA();
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        if (this.numChildren() > 2) {
            CmdFlags.errorExit("too many children");
        }
        if (CmdFlags.getUseBV()) {
            return "(bvmul " + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")";
        }
        return null;
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        if (this.numChildren() > 2) {
            CmdFlags.errorExit("too many children");
        }
        if (CmdFlags.getUseNIA()) {
            return "(* " + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
        }
        return null;
    }
}

