/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.stream.Collectors;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.NumberConstant;
import savilerow.expression.Table;
import savilerow.model.Model;

public class FactorEncoding {
    private ArrayList<ASTNode> tableCons = new ArrayList();
    private ArrayList<Constraint> constraints = new ArrayList();
    private ArrayList<Factor> factors = new ArrayList();
    private int highestVarId = 0;
    private int lastPrimaryVar = 0;

    public void factorEncoding(Model model) {
        Object object;
        Serializable serializable;
        ArrayList<ArrayList<Integer>> arrayList;
        Serializable serializable2;
        ArrayList<Integer> arrayList2;
        int n;
        int n2;
        ASTNode aSTNode = model.constraints.getChild(0);
        if (!(aSTNode instanceof And)) {
            return;
        }
        for (n2 = 0; n2 < aSTNode.numChildren(); ++n2) {
            if (!(aSTNode.getChild(n2) instanceof Table)) continue;
            this.tableCons.add(aSTNode.getChild(n2));
        }
        if (this.tableCons.size() < 2) {
            return;
        }
        n2 = 0;
        HashMap<ASTNode, Integer> hashMap = new HashMap<ASTNode, Integer>();
        HashMap<Integer, ASTNode> hashMap2 = new HashMap<Integer, ASTNode>();
        for (n = 0; n < this.tableCons.size(); ++n) {
            ASTNode aSTNode2 = this.tableCons.get(n).getChild(0);
            arrayList2 = new ArrayList<Integer>(aSTNode2.numChildren() - 1);
            for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                if (!hashMap.containsKey(aSTNode2.getChild(i))) {
                    hashMap.put(aSTNode2.getChild(i), ++n2);
                    hashMap2.put(n2, aSTNode2.getChild(i));
                }
                arrayList2.add(hashMap.get(aSTNode2.getChild(i)));
            }
            serializable2 = this.tableCons.get(n).getChildConst(1);
            arrayList = new ArrayList<ArrayList<Integer>>(((ASTNode)serializable2).numChildren() - 1);
            for (int i = 1; i < ((ASTNode)serializable2).numChildren(); ++i) {
                serializable = ((ASTNode)serializable2).getChildConst(i);
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>(((ASTNode)serializable).getTupleLength());
                for (int j = 1; j <= ((ASTNode)serializable).getTupleLength(); ++j) {
                    arrayList3.add((int)((ASTNode)serializable).getValueIdx(j));
                }
                arrayList.add(arrayList3);
            }
            object = new Constraint(arrayList2, arrayList);
            this.constraints.add((Constraint)object);
            this.highestVarId = Math.max(this.highestVarId, (Integer)Collections.max(((Constraint)object).varIds));
        }
        this.lastPrimaryVar = this.highestVarId;
        this.createFactors();
        this.augmentConstraints();
        if (CmdFlags.factor_encoding_mode > 1) {
            this.createFactorConstraints();
            this.filterOriginalScopes();
            if (CmdFlags.factor_encoding_mode == 3) {
                this.resetState(model, hashMap, hashMap2);
                this.createFactors();
                this.augmentConstraints();
                this.createFactorConstraints();
                this.filterOriginalScopes();
            } else if (CmdFlags.factor_encoding_mode == 4) {
                this.filterScopesPlus();
            }
        }
        for (n = 0; n < this.factors.size(); ++n) {
            int n3 = this.factors.get(n).proj_table.size();
            arrayList2 = model.global_symbols.newAuxiliaryVariable(0L, n3);
            hashMap.put((ASTNode)((Object)arrayList2), n + 1 + this.lastPrimaryVar);
            hashMap2.put(n + 1 + this.lastPrimaryVar, (ASTNode)((Object)arrayList2));
        }
        ASTNode aSTNode3 = this.tableCons.get(0);
        for (int i = 1; i < this.tableCons.size(); ++i) {
            this.tableCons.get(i).getParent().setChild(this.tableCons.get(i).getChildNo(), new BooleanConstant(true));
        }
        ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
        for (int i = 0; i < this.constraints.size(); ++i) {
            serializable2 = this.constraints.get(i).varIds;
            arrayList = new ArrayList(((ArrayList)serializable2).size());
            for (int j = 0; j < ((ArrayList)serializable2).size(); ++j) {
                arrayList.add((ArrayList<Integer>)((Object)hashMap2.get(((ArrayList)serializable2).get(j))));
            }
            object = this.constraints.get(i).rows;
            serializable = new ArrayList(((ArrayList)object).size());
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                ArrayList<ASTNode> arrayList5 = new ArrayList<ASTNode>(((ArrayList)((ArrayList)object).get(j)).size());
                for (int k = 0; k < ((ArrayList)((ArrayList)object).get(j)).size(); ++k) {
                    arrayList5.add(NumberConstant.make(((Integer)((ArrayList)((ArrayList)object).get(j)).get(k)).intValue()));
                }
                ((ArrayList)serializable).add(CompoundMatrix.make(arrayList5));
            }
            arrayList4.add(new Table(model, CompoundMatrix.make(arrayList), CompoundMatrix.make((ArrayList<ASTNode>)serializable)));
        }
        aSTNode3.getParent().setChild(aSTNode3.getChildNo(), new And(arrayList4));
    }

    void resetState(Model model, HashMap<ASTNode, Integer> hashMap, HashMap<Integer, ASTNode> hashMap2) {
        for (int i = 0; i < this.factors.size(); ++i) {
            int n = this.factors.get(i).proj_table.size();
            Identifier identifier = model.global_symbols.newAuxiliaryVariable(0L, n);
            hashMap.put(identifier, i + 1 + this.lastPrimaryVar);
            hashMap2.put(i + 1 + this.lastPrimaryVar, identifier);
        }
        this.lastPrimaryVar += this.factors.size();
        this.factors.clear();
    }

    public Constraint deepCopyOf(Constraint constraint) {
        return new Constraint(constraint.getPrimitiveTable());
    }

    public void createFactors() {
        for (int i = 0; i < this.constraints.size() - 1; ++i) {
            for (int j = i + 1; j < this.constraints.size(); ++j) {
                Constraint constraint = this.constraints.get(i);
                Constraint constraint2 = this.constraints.get(j);
                TreeSet treeSet = new TreeSet();
                treeSet.addAll(constraint.varIds);
                treeSet.retainAll(constraint2.varIds);
                if (treeSet.size() < 2) continue;
                boolean bl = true;
                HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(i, j));
                for (Factor factor : this.factors) {
                    if (!treeSet.equals(factor.scope)) continue;
                    bl = false;
                    factor.constraint_idxs.addAll(hashSet);
                    break;
                }
                if (!bl) continue;
                Factor factor = new Factor();
                factor.scope.addAll(treeSet);
                factor.constraint_idxs.addAll(hashSet);
                this.factors.add(factor);
            }
        }
    }

    public void augmentConstraints() {
        for (Factor factor : this.factors) {
            int n = ++this.highestVarId;
            Iterator iterator = factor.constraint_idxs.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                Constraint constraint = this.constraints.get(n2);
                Constraint constraint2 = this.deepCopyOf(constraint);
                for (ArrayList arrayList : constraint2.rows) {
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    Object object = factor.scope.iterator();
                    while (object.hasNext()) {
                        int n3 = (Integer)object.next();
                        int n4 = constraint2.varIds.indexOf(n3);
                        arrayList2.add((Integer)arrayList.get(n4));
                    }
                    if (factor.proj_table.contains(arrayList2)) {
                        object = factor.proj_table.indexOf(arrayList2);
                    } else {
                        object = factor.proj_table.size();
                        factor.proj_table.add(arrayList2);
                    }
                    arrayList.add(((Integer)object).intValue());
                }
                constraint2.varIds.add(n);
                this.constraints.set(n2, constraint2);
            }
        }
    }

    void createFactorConstraints() {
        for (int i = 0; i < this.factors.size(); ++i) {
            int n = this.lastPrimaryVar + 1 + i;
            Factor factor = this.factors.get(i);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(factor.scope);
            arrayList.add(n);
            ArrayList<ArrayList<Integer>> arrayList2 = new ArrayList<ArrayList<Integer>>();
            for (int j = 0; j < factor.proj_table.size(); ++j) {
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>((Collection)factor.proj_table.get(j));
                arrayList3.add(j);
                arrayList2.add(arrayList3);
            }
            this.constraints.add(new Constraint(arrayList, arrayList2));
            factor.factor_ct = this.constraints.size() - 1;
        }
    }

    void filterOriginalScopes() {
        for (Factor factor : this.factors) {
            Iterator iterator = factor.constraint_idxs.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.filterScope(this.constraints.get(n), factor.scope);
            }
        }
    }

    void filterScope(Constraint constraint, TreeSet<Integer> treeSet) {
        int n;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(constraint.varIds.size());
        int n2 = 0;
        for (n = 0; n < constraint.varIds.size(); ++n) {
            boolean bl = !treeSet.contains(constraint.varIds.get(n));
            arrayList.add(bl);
            if (!bl) continue;
            ++n2;
        }
        for (n = 0; n < constraint.rows.size(); ++n) {
            ArrayList arrayList2 = (ArrayList)constraint.rows.get(n);
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (!((Boolean)arrayList.get(i)).booleanValue()) continue;
                arrayList3.add((Integer)arrayList2.get(i));
            }
            constraint.rows.set(n, arrayList3);
        }
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        for (int i = 0; i < constraint.varIds.size(); ++i) {
            if (!((Boolean)arrayList.get(i)).booleanValue()) continue;
            arrayList4.add((Integer)constraint.varIds.get(i));
        }
        constraint.varIds = arrayList4;
    }

    void filterScopesPlus() {
        for (int i = 0; i < this.factors.size(); ++i) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            Iterator iterator = this.factors.get(i).scope.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (!this.checkConnected(i, n)) continue;
                treeSet.add(n);
            }
            if (treeSet.size() <= 0) continue;
            System.out.println("From factor " + i + " deleting variables:" + treeSet);
            this.filterScope(this.constraints.get(this.factors.get(i).factor_ct), treeSet);
        }
    }

    boolean checkConnected(int n, int n2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        treeSet.add(n);
        arrayList.add(n);
        while (arrayList.size() > 0) {
            int n3 = (Integer)arrayList.remove(arrayList.size() - 1);
            Iterator iterator = this.factors.get(n3).constraint_idxs.iterator();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                Constraint constraint = this.constraints.get(n4);
                Iterator iterator2 = constraint.varIds.iterator();
                while (iterator2.hasNext()) {
                    int n5;
                    Factor factor;
                    int n6 = (Integer)iterator2.next();
                    if (n6 <= this.lastPrimaryVar || treeSet.contains(n6 - this.lastPrimaryVar - 1) || !(factor = this.factors.get(n5 = n6 - this.lastPrimaryVar - 1)).scope.contains(n2)) continue;
                    if (this.constraints.get(factor.factor_ct).varIds.indexOf(n2) > -1) {
                        return true;
                    }
                    treeSet.add(n5);
                    arrayList.add(n5);
                }
            }
        }
        return false;
    }

    public String printConstraints() {
        String string = "";
        for (Constraint constraint : this.constraints) {
            string = string + "Constraint with variables:\n";
            string = string + constraint.varIds.stream().map(String::valueOf).collect(Collectors.joining(", "));
            string = string + "\n--- and values ---\n";
            for (ArrayList arrayList : constraint.rows) {
                string = string + arrayList.stream().map(String::valueOf).collect(Collectors.joining(", "));
                string = string + "\n";
            }
        }
        return string;
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public int[][] getPrimitiveTableFor(int n) {
        return this.constraints.get(n).getPrimitiveTable();
    }

    public ArrayList<Factor> getFactors() {
        return this.factors;
    }

    private class Constraint {
        private ArrayList<Integer> varIds = new ArrayList();
        private ArrayList<ArrayList<Integer>> rows = new ArrayList();

        public Constraint(int[][] nArray) {
            int n;
            if (nArray.length < 2) {
                throw new IllegalArgumentException("Expecting a row of variable ids and some rows of supporting values");
            }
            for (n = 0; n < nArray[0].length; ++n) {
                this.varIds.add(nArray[0][n]);
            }
            for (n = 1; n < nArray.length; ++n) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray[n].length);
                for (int i = 0; i < nArray[n].length; ++i) {
                    arrayList.add(nArray[n][i]);
                }
                this.rows.add(arrayList);
            }
        }

        public Constraint(ArrayList<Integer> arrayList, ArrayList<ArrayList<Integer>> arrayList2) {
            this.varIds = arrayList;
            this.rows = arrayList2;
        }

        public int[][] getPrimitiveTable() {
            int n2 = this.varIds.size();
            int[][] nArray = new int[this.rows.size() + 1][n2];
            nArray[0] = this.varIds.stream().mapToInt(n -> n).toArray();
            for (int i = 0; i < this.rows.size(); ++i) {
                nArray[i + 1] = this.rows.get(i).stream().mapToInt(n -> n).toArray();
            }
            return nArray;
        }
    }

    private class Factor {
        private TreeSet<Integer> scope = new TreeSet();
        private TreeSet<Integer> constraint_idxs = new TreeSet();
        private ArrayList<ArrayList<Integer>> proj_table = new ArrayList();
        private int factor_ct = 0;

        private Factor() {
        }
    }
}

