/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.Unary;
import savilerow.expression.UnaryMinus;
import savilerow.model.BitVector;
import savilerow.model.SMT;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Absolute
extends Unary {
    public static final long serialVersionUID = 1L;

    public Absolute(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Absolute(this.getChild(0));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant()) {
            long l = this.getChild(0).getValue();
            if (l < 0L) {
                return NumberConstant.make(-l);
            }
            return NumberConstant.make(l);
        }
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower >= 0L) {
            return this.getChild(0);
        }
        if (intpair.upper <= 0L) {
            this.getChild(0).setParent(null);
            return new UnaryMinus(this.getChild(0));
        }
        if (this.getChild(0) instanceof UnaryMinus || this.getChild(0) instanceof Absolute) {
            this.getChild(0).getChild(0).setParent(null);
            return new Absolute(this.getChild(0).getChild(0));
        }
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() > 0) {
            CmdFlags.println("ERROR: Cannot apply absolute value operation to a matrix: " + this);
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower == Long.MIN_VALUE) {
            ++intpair.lower;
        }
        if (intpair.upper < 0L) {
            long l = intpair.upper;
            intpair.upper = -intpair.lower;
            intpair.lower = -l;
        } else if (intpair.lower < 0L) {
            if (intpair.upper > -intpair.lower) {
                intpair.lower = 0L;
            } else {
                intpair.upper = -intpair.lower;
                intpair.lower = 0L;
            }
        }
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        arrayList = Intpair.union(arrayList, Intpair.multIntervalSet(arrayList, -1L));
        ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>();
        arrayList2.add(new Intpair(0L, Long.MAX_VALUE));
        return Intpair.intersection(arrayList, arrayList2);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("abs(");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public String toString() {
        return "|" + this.getChild(0) + "|";
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint int_abs(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append("abs(");
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.supportEncodingBinary(this, this.getChild(0), aSTNode);
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseNIA() || CmdFlags.getUseBV() || CmdFlags.getUseLIA();
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(abs " + this.getChild(0).smtEncodeInt(sMT) + ")";
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite (bvslt " + this.getChild(0).smtEncodeBV(sMT) + " " + BitVector.toHexString(0L) + ") (bvneg " + this.getChild(0).smtEncodeBV(sMT) + ") " + this.getChild(0).smtEncodeBV(sMT) + ")";
    }

    @Override
    public boolean test(long l, long l2) {
        return (l < 0L ? -l : l) == l2;
    }

    @Override
    public boolean canChildBeConvertedToDifference(int n) {
        return true;
    }
}

