/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Divide;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.LessEqual;
import savilerow.expression.NotEqual;
import savilerow.expression.NumberConstant;
import savilerow.expression.SATLiteral;
import savilerow.expression.ShiftMapper;
import savilerow.expression.UnaryMinus;
import savilerow.expression.WeightedSum;
import savilerow.model.SMT;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Less
extends BinOp {
    public static final long serialVersionUID = 1L;
    static boolean useOrderEnc = true;

    public Less(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Less(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!super.typecheck(symbolTable)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(this.getChild(i) instanceof Less) && !(this.getChild(i) instanceof LessEqual) && !(this.getChild(i) instanceof Equals) && !(this.getChild(i) instanceof NotEqual)) continue;
            CmdFlags.println("ERROR: Nested non-associative operators: " + this);
            CmdFlags.println("ERROR: Add brackets to remove ambiguity.");
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        Pair<ASTNode, ASTNode> pair;
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(false);
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.upper < intpair2.lower) {
            return new BooleanConstant(true);
        }
        if (intpair.lower >= intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            if (this.getChild(0).getValue() < this.getChild(1).getValue()) {
                return new BooleanConstant(true);
            }
            return new BooleanConstant(false);
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1) instanceof WeightedSum) {
            this.detachChildren();
            return new LessEqual(BinOp.makeBinOp("-", this.getChild(0), this.getChild(1)), NumberConstant.make(-1L));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() == 3 && this.getChild(1).getCategory() < 3) {
            Pair<ASTNode, ASTNode> pair2 = ((WeightedSum)this.getChild(0)).retrieveConstant();
            if (pair2 != null) {
                this.getChild(1).setParent(null);
                return new Less(pair2.getSecond(), BinOp.makeBinOp("-", this.getChild(1), pair2.getFirst()));
            }
            this.detachChildren();
            return new LessEqual(this.getChild(0), BinOp.makeBinOp("-", this.getChild(1), NumberConstant.make(1L)));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() == 3 && this.getChild(0).getCategory() < 3) {
            Pair<ASTNode, ASTNode> pair3 = ((WeightedSum)this.getChild(1)).retrieveConstant();
            if (pair3 != null) {
                this.getChild(0).setParent(null);
                return new Less(BinOp.makeBinOp("-", this.getChild(0), pair3.getFirst()), pair3.getSecond());
            }
            this.detachChildren();
            return new LessEqual(BinOp.makeBinOp("+", this.getChild(0), NumberConstant.make(1L)), this.getChild(1));
        }
        if (this.getChild(0) instanceof UnaryMinus && this.getChild(1).isConstant()) {
            return new Less((ASTNode)new UnaryMinus(this.getChild(1)), this.getChild(0).getChild(0));
        }
        if (this.getChild(1) instanceof UnaryMinus && this.getChild(0).isConstant()) {
            return new Less(this.getChild(1).getChild(0), new UnaryMinus(this.getChild(0)));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1).isConstant() && (pair = ((WeightedSum)this.getChild(0)).factorOutGCD()) != null) {
            long l = pair.getFirst().getValue();
            long l2 = this.getChild(1).getValue();
            long l3 = Divide.div(l2, l);
            if (l3 * l != l2) {
                return new LessEqual(pair.getSecond(), NumberConstant.make(l3));
            }
            return new Less(pair.getSecond(), NumberConstant.make(l3));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(0).isConstant() && (pair = ((WeightedSum)this.getChild(1)).factorOutGCD()) != null) {
            long l = pair.getFirst().getValue();
            long l4 = this.getChild(0).getValue();
            long l5 = Divide.divceil(l4, l);
            if (l5 * l != l4) {
                return new LessEqual((ASTNode)NumberConstant.make(l5), pair.getSecond());
            }
            return new Less((ASTNode)NumberConstant.make(l5), pair.getSecond());
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new LessEqual(this.getChild(1), this.getChild(0));
    }

    @Override
    public int polarity(int n) {
        return this.polarity() * (n == 0 ? -1 : 1);
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        bufferedWriter.append("ineq(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", -1)");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "<" + this.getChild(1) + ")";
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint int_lt(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("<");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            if (this.getChild(1) instanceof SATLiteral) {
                assert (this.getChild(0).getValue() == 0L);
                return ((SATLiteral)this.getChild(1)).getLit();
            }
            return -this.getChild(1).orderEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant()) {
            if (this.getChild(0) instanceof SATLiteral) {
                assert (this.getChild(1).getValue() == 1L);
                return -((SATLiteral)this.getChild(0)).getLit();
            }
            return this.getChild(0).orderEncode(sat, this.getChild(1).getValue() - 1L);
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (useOrderEnc) {
            this.toSATOrderEnc(sat, 0L);
        } else {
            sat.supportEncodingBinary(this, this.getChild(0), this.getChild(1));
        }
    }

    @Override
    public void toSMT(SMT sMT) throws IOException {
        if (this.usesSMTEncoding()) {
            sMT.addSMTClause(this.smtEncodeBool(sMT));
        } else {
            this.toSAT(sMT);
        }
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL() && this.canIDLEncode();
    }

    @Override
    public boolean canIDLEncode() {
        if (this.getChild(0) instanceof Identifier && this.getChild(1) instanceof Identifier) {
            return true;
        }
        if (this.getChild(0) instanceof ShiftMapper && this.getChild(1) instanceof Identifier) {
            return true;
        }
        if (this.getChild(0) instanceof Identifier && this.getChild(1) instanceof ShiftMapper) {
            return true;
        }
        boolean bl = this.getChild(0) instanceof NumberConstant && this.getChild(1).canIDLEncode();
        boolean bl2 = this.getChild(0).canIDLEncode() && this.getChild(1) instanceof NumberConstant;
        return bl || bl2;
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        if (CmdFlags.getUseNIA() || CmdFlags.getUseLIA()) {
            String string = "(< ";
            string = string + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
            return string;
        }
        if (CmdFlags.getUseBV()) {
            String string = "(bvslt ";
            string = string + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")";
            return string;
        }
        if (CmdFlags.getUseIDL()) {
            String string = "(< ";
            string = string + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
            return string;
        }
        return null;
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " " + SMT.toSMTBV(1L) + " " + SMT.toSMTBV(0L) + ")";
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " 1 0)";
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        if (useOrderEnc) {
            this.toSATOrderEnc(sat, -l);
            new LessEqual(this.getChild(1), this.getChild(0)).toSATOrderEnc(sat, l);
        } else {
            sat.supportEncodingBinaryWithAuxVar(this, this.getChild(0), this.getChild(1), l);
        }
    }

    public void toSATOrderEnc(Sat sat, long l) throws IOException {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        arrayList = Intpair.union(arrayList, Intpair.shiftIntervalSet(this.getChild(1).getIntervalSetExp(), -1L));
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                if (l != 0L) {
                    sat.addClause(this.getChild(0).orderEncode(sat, i), -this.getChild(1).orderEncode(sat, i + 1L), l);
                    continue;
                }
                sat.addClause(this.getChild(0).orderEncode(sat, i), -this.getChild(1).orderEncode(sat, i + 1L));
            }
        }
    }

    @Override
    public boolean test(long l, long l2) {
        return l < l2;
    }
}

