/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.expression.Solution;
import savilerow.model.Model;
import savilerow.model.SymbolTable;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;
import savilerow.solver.Solver;
import savilerow.solver.Stats;

public class FznSolver
extends Solver {
    private Stats stats = null;

    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        this.runFznSolver(string, string2, model);
    }

    private void runFznSolver(String string, String string2, Model model) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            if (CmdFlags.getFindAllSolutions()) {
                if (model.objective != null) {
                    CmdFlags.warning("Ignoring -all-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindAllSolutions(false);
                } else {
                    arrayList.add("-n");
                    arrayList.add("0");
                }
            }
            if (CmdFlags.getFindNumSolutions() > 1L) {
                if (model.objective != null) {
                    CmdFlags.warning("Ignoring -num-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindNumSolutions(1L);
                } else {
                    arrayList.add("-n");
                    arrayList.add(String.valueOf(CmdFlags.getFindNumSolutions()));
                }
            }
            if ((CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans() || CmdFlags.getOrtoolstrans()) && !CmdFlags.getSolverExtraFlags().contains("-s")) {
                CmdFlags.addSolverFlag("-s");
            }
            arrayList.addAll(CmdFlags.getSolverExtraFlags());
            arrayList.add(string2);
            if (CmdFlags.getChuffedtrans() || CmdFlags.getOrtoolstrans()) {
                arrayList.add("-f");
            }
            double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
            this.stats = new Stats();
            this.stats.putValue("SavileRowTotalTime", String.valueOf(d));
            if (CmdFlags.getChuffedtrans() || CmdFlags.getGecodetrans() || CmdFlags.getOrtoolstrans()) {
                this.stats.putValue("SolverTimeOut", "0");
                if (CmdFlags.getGecodetrans() || CmdFlags.getChuffedtrans()) {
                    this.stats.putValue("SolverNodes", "0");
                }
                this.stats.putValue("SolverFailures", "0");
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ReadFznOutput readFznOutput = new ReadFznOutput(this, model.global_symbols);
            double d2 = System.currentTimeMillis();
            int n = RunCommand.runCommand(true, arrayList, arrayList2, readFznOutput);
            d2 = ((double)System.currentTimeMillis() - d2) / 1000.0;
            if (!this.stats.hasValue("SolverTotalTime")) {
                this.stats.putValue("SolverTotalTime", String.valueOf(d2));
            }
            if (arrayList2.size() != 0 || n != 0) {
                CmdFlags.println("Solver exited with error code:" + n + " and message:");
                CmdFlags.println(arrayList2);
                CmdFlags.rmTempFiles();
            }
            this.stats.makeInfoFiles();
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            throw interruptedException;
        }
    }

    @Override
    void parseAllSolverSolutions(SymbolTable symbolTable, BufferedReader bufferedReader) {
        this.parseFznSolverOut(symbolTable, bufferedReader, true);
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return null;
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return this.parseFznSolverOut(symbolTable, bufferedReader, false);
    }

    Solution parseFznSolverOut(SymbolTable symbolTable, BufferedReader bufferedReader, boolean bl) {
        Serializable serializable;
        Serializable serializable2 = null;
        String string = null;
        while (true) {
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string = null;
            }
            if (string == null) break;
            if ((string = string.trim()).equals("Top level failure!")) continue;
            if (string.startsWith("%%%mzn-stat:")) {
                this.readSolverStats(string);
                continue;
            }
            if (string.contains("Time limit exceeded!")) {
                this.stats.putValue("SolverTimeOut", "1");
            }
            if (string.startsWith("%") || string.equals("")) continue;
            if (string.equals("=====UNSATISFIABLE=====")) {
                this.stats.putValue("SolverSatisfiable", "0");
                continue;
            }
            if (string.equals("==========")) continue;
            if (string.equals("=====UNKNOWN=====")) {
                this.stats.putValue("SolverTimeOut", "1");
                continue;
            }
            serializable = new ArrayList();
            while (!string.equals("----------")) {
                ((ArrayList)serializable).add(string);
                try {
                    string = bufferedReader.readLine();
                    string = string.trim();
                }
                catch (IOException iOException) {
                    string = null;
                }
                if (string != null) continue;
            }
            if (bl) {
                this.stats.putValue("SolverSatisfiable", "1");
                Solution solution = this.solverSolToAST((ArrayList<String>)serializable, symbolTable);
                this.createSolutionFile(solution, true);
                continue;
            }
            serializable2 = serializable;
        }
        if (bl) {
            return null;
        }
        if (serializable2 != null) {
            this.stats.putValue("SolverSatisfiable", "1");
            serializable = this.solverSolToAST((ArrayList<String>)serializable2, symbolTable);
            return serializable;
        }
        this.stats.putValue("SolverSatisfiable", "0");
        return null;
    }

    private void readSolverStats(String string) {
        if (string.startsWith("%%%mzn-stat: nodes")) {
            this.stats.putValue("SolverNodes", string.split("=")[1]);
        } else if (string.startsWith("%%%mzn-stat: time")) {
            this.stats.putValue("SolverTotalTime", string.split("=")[1]);
        } else if (string.startsWith("%%%mzn-stat: failures")) {
            this.stats.putValue("SolverFailures", string.split("=")[1]);
        }
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray;
            String string = arrayList.get(i);
            if (string.isEmpty() || (stringArray = string.split(" = ")).length != 2) continue;
            String[] stringArray2 = stringArray[1].split(";");
            String string2 = stringArray2[0].trim();
            if (string2.equals("true")) {
                hashMap.put(stringArray[0], 1L);
                continue;
            }
            if (string2.equals("false")) {
                hashMap.put(stringArray[0], 0L);
                continue;
            }
            hashMap.put(stringArray[0], Long.parseLong(string2));
        }
        return hashMap;
    }

    class ReadFznOutput
    extends ReadProcessOutput {
        BufferedReader br;
        FznSolver fs;
        SymbolTable st;

        ReadFznOutput(FznSolver fznSolver2, SymbolTable symbolTable) {
            this.fs = fznSolver2;
            this.st = symbolTable;
        }

        @Override
        public void giveInputStream(BufferedReader bufferedReader) {
            this.br = bufferedReader;
        }

        @Override
        public void run() {
            if (!(CmdFlags.getFindAllSolutions() || CmdFlags.getFindNumSolutions() != -1L && CmdFlags.getFindNumSolutions() != 1L)) {
                Solution solution = this.fs.parseLastSolverSolution(this.st, this.br);
                if (solution != null || this.st.m.incumbentSolution != null) {
                    this.fs.createSolutionFile(solution != null ? solution : this.st.m.incumbentSolution, false);
                }
            } else {
                this.fs.parseAllSolverSolutions(this.st, this.br);
            }
        }
    }
}

