/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.Cat;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Flatten;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.MatrixSlice;
import savilerow.expression.NumberConstant;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.Tag;
import savilerow.expression.Unpack;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformMatrixIndexedMatrix
extends TreeTransformerBottomUpNoWrapper {
    ASTNode matid;
    long numindices;

    public TransformMatrixIndexedMatrix(String string, Model model) {
        super(model);
        this.matid = new Identifier(this.m, string);
        ASTNode aSTNode = this.m.global_symbols.getDomain(string);
        ASTNode aSTNode2 = this.flattenMatrixDimensions(aSTNode);
        this.numindices = aSTNode2.numChildren() - 3;
        this.m.global_symbols.setDomain(string, aSTNode2);
    }

    ASTNode flattenMatrixDimensions(ASTNode aSTNode) {
        assert (aSTNode instanceof MatrixDomain);
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 3; i < aSTNode.numChildren(); ++i) {
            int n;
            if (!(aSTNode.getChild(i) instanceof MatrixDomain)) {
                arrayList.add(aSTNode.getChild(i));
                continue;
            }
            ASTNode aSTNode2 = this.flattenMatrixDimensions(aSTNode.getChild(i));
            long l = 1L;
            for (n = 3; n < aSTNode2.numChildren(); ++n) {
                ArrayList<Intpair> arrayList2 = aSTNode2.getChild(n).getIntervalSet();
                l *= Intpair.numValues(arrayList2);
            }
            n = 0;
            while ((long)n < l) {
                arrayList.add(aSTNode.getChild(i).getChild(0).copy());
                ++n;
            }
        }
        return new MatrixDomain(aSTNode.getChild(0), arrayList, aSTNode.getChild(1), aSTNode.getChild(2));
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (!(aSTNode.getParent() instanceof Tag)) {
            if (aSTNode instanceof MatrixSlice && aSTNode.getChild(0).equals(this.matid)) {
                ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i).getDimension() > 0) {
                        arrayList.set(i, new Flatten(arrayList.get(i)));
                        continue;
                    }
                    arrayList.set(i, CompoundMatrix.make(arrayList.get(i)));
                }
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                arrayList2.add(new Unpack((ASTNode)NumberConstant.make(this.numindices), new Cat(arrayList)));
                System.out.println("Replacing " + aSTNode + " with " + new MatrixSlice(this.m, aSTNode.getChild(0), arrayList2));
                return new NodeReplacement(new Tag(new MatrixSlice(this.m, aSTNode.getChild(0), arrayList2)));
            }
            if ((aSTNode instanceof MatrixDeref || aSTNode instanceof SafeMatrixDeref) && aSTNode.getChild(0).equals(this.matid)) {
                ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i).getDimension() > 0) {
                        arrayList.set(i, new Flatten(arrayList.get(i)));
                        continue;
                    }
                    arrayList.set(i, CompoundMatrix.make(arrayList.get(i)));
                }
                ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                arrayList3.add(new Unpack((ASTNode)NumberConstant.make(this.numindices), new Cat(arrayList)));
                if (aSTNode instanceof MatrixDeref) {
                    System.out.println("Replacing " + aSTNode + " with " + new MatrixDeref(aSTNode.getChild(0), arrayList3));
                    return new NodeReplacement(new Tag(new MatrixDeref(aSTNode.getChild(0), arrayList3)));
                }
                System.out.println("Replacing " + aSTNode + " with " + new SafeMatrixDeref(aSTNode.getChild(0), arrayList3));
                return new NodeReplacement(new Tag(new SafeMatrixDeref(aSTNode.getChild(0), arrayList3)));
            }
        }
        return null;
    }
}

