/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.LessEqual;
import savilerow.expression.Negate;
import savilerow.expression.WeightedSum;
import savilerow.model.Model;
import savilerow.model.Sat;

public class AMODetect {
    public static ArrayList<String> varslist;
    public static HashMap<String, Integer> vartonum;
    public static TIntObjectHashMap<TIntHashSet> adjlist;
    public static ArrayList<Pair<Pair<ASTNode, ASTNode>, Pair<Boolean, Boolean>>> mutexDetect;
    private static HashMap<Long, Integer> littonum;

    public static void init() {
        varslist = new ArrayList();
        varslist.add(null);
        vartonum = new HashMap();
        adjlist = new TIntObjectHashMap();
    }

    public static void addAMOSection(BufferedWriter bufferedWriter, Model model) throws IOException {
        assert (CmdFlags.amo_detect_strong);
        bufferedWriter.append("**MUTEXDETECT**\n");
        HashSet<Pair<Pair<ASTNode, ASTNode>, Pair<Boolean, Boolean>>> hashSet = new HashSet<Pair<Pair<ASTNode, ASTNode>, Pair<Boolean, Boolean>>>();
        bufferedWriter.append("[");
        ArrayList<ASTNode> arrayList = model.constraints.getChildren();
        while (arrayList.size() > 0) {
            ASTNode aSTNode = arrayList.remove(arrayList.size() - 1);
            if (aSTNode instanceof WeightedSum) {
                System.out.println("Dumping mutex pairs for: " + aSTNode.getParent());
                boolean bl = true;
                if (aSTNode.getParent() instanceof LessEqual && aSTNode.getChildNo() == 1) {
                    bl = false;
                }
                for (int i = 0; i < aSTNode.numChildren(); ++i) {
                    if (!aSTNode.getChild(i).isRelation()) continue;
                    for (int j = i + 1; j < aSTNode.numChildren(); ++j) {
                        if (!aSTNode.getChild(j).isRelation()) continue;
                        ASTNode aSTNode2 = aSTNode.getChild(i);
                        ASTNode aSTNode3 = aSTNode.getChild(j);
                        boolean bl2 = bl ^ aSTNode2 instanceof Negate ^ ((WeightedSum)aSTNode).getWeight(i) < 0L;
                        boolean bl3 = bl ^ aSTNode3 instanceof Negate ^ ((WeightedSum)aSTNode).getWeight(j) < 0L;
                        Pair<ASTNode, ASTNode> pair = new Pair<ASTNode, ASTNode>(aSTNode2 instanceof Negate ? aSTNode2.getChild(0) : aSTNode2, aSTNode3 instanceof Negate ? aSTNode3.getChild(0) : aSTNode3);
                        Pair<Pair<ASTNode, ASTNode>, Pair<Boolean, Boolean>> pair2 = new Pair<Pair<ASTNode, ASTNode>, Pair<Boolean, Boolean>>(pair, new Pair<Boolean, Boolean>(bl2, bl3));
                        System.out.println(pair2);
                        if (hashSet.contains(pair2)) continue;
                        hashSet.add(pair2);
                        mutexDetect.add(pair2);
                        if (aSTNode2 instanceof Negate) {
                            bufferedWriter.append(aSTNode2.getChild(0).toString());
                        } else {
                            bufferedWriter.append(aSTNode2.toString());
                        }
                        bufferedWriter.append(bl2 ? ",1," : ",0,");
                        if (aSTNode3 instanceof Negate) {
                            bufferedWriter.append(aSTNode3.getChild(0).toString());
                        } else {
                            bufferedWriter.append(aSTNode3.toString());
                        }
                        bufferedWriter.append(bl3 ? ",1," : ",0,");
                    }
                }
                continue;
            }
            arrayList.addAll(aSTNode.getChildren());
        }
        bufferedWriter.append("]\n");
    }

    public static int add_variable_amo(String string) {
        if (!vartonum.containsKey(string = string.intern())) {
            int n = varslist.size();
            vartonum.put(string, n);
            varslist.add(string);
            adjlist.put(n, new TIntHashSet());
            adjlist.put(-n, new TIntHashSet());
            return n;
        }
        return vartonum.get(string);
    }

    public static void addEdge(int n, int n2) {
        adjlist.get(n).add(n2);
        adjlist.get(n2).add(n);
    }

    public static boolean hasEdge(int n, int n2) {
        return adjlist.get(n).contains(n2);
    }

    public static void addEdge(int n) {
        Pair<Pair<ASTNode, ASTNode>, Pair<Boolean, Boolean>> pair = mutexDetect.get(n);
        ASTNode aSTNode = pair.getFirst().getFirst();
        ASTNode aSTNode2 = pair.getFirst().getSecond();
        boolean bl = pair.getSecond().getFirst();
        boolean bl2 = pair.getSecond().getFirst();
        int n2 = AMODetect.add_variable_amo(aSTNode.toString());
        int n3 = AMODetect.add_variable_amo(aSTNode2.toString());
        AMODetect.addEdge(n2 * (bl ? 1 : -1), n3 * (bl2 ? 1 : -1));
    }

    private static void buildLittonum(Sat sat) {
        littonum = new HashMap();
        for (int i = 1; i < varslist.size(); ++i) {
            long l = sat.getDirectVariable(varslist.get(i), 1L);
            if (l == -sat.getTrue()) continue;
            littonum.put(l, i);
        }
    }

    public static boolean isMutex(Sat sat, long l, long l2) {
        long l3;
        if (littonum == null) {
            AMODetect.buildLittonum(sat);
        }
        long l4 = l < 0L ? -l : l;
        long l5 = l3 = l2 < 0L ? -l2 : l2;
        if (!littonum.containsKey(l4) || !littonum.containsKey(l3)) {
            return false;
        }
        int n = l < 0L ? -littonum.get(l4).intValue() : littonum.get(l4);
        int n2 = l2 < 0L ? -littonum.get(l3).intValue() : littonum.get(l3);
        return AMODetect.hasEdge(n, n2);
    }

    public static ArrayList<TreeSet<Integer>> buildCliques(TreeSet<String> treeSet, HashMap<String, ASTNode> hashMap) {
        int n;
        int n2;
        for (String object2 : treeSet) {
            AMODetect.add_variable_amo(object2);
        }
        TIntHashSet tIntHashSet = new TIntHashSet();
        class IdxDegreePair
        implements Comparable<IdxDegreePair> {
            public int idx;
            public int degree;

            public IdxDegreePair(int n, int n2) {
                this.idx = n;
                this.degree = n2;
            }

            @Override
            public int compareTo(IdxDegreePair idxDegreePair) {
                if (this.degree < idxDegreePair.degree) {
                    return 1;
                }
                if (this.degree == idxDegreePair.degree) {
                    return 0;
                }
                return -1;
            }

            public String toString() {
                return "(" + this.idx + ", " + this.degree + ")";
            }
        }
        ArrayList<IdxDegreePair> arrayList = new ArrayList<IdxDegreePair>();
        for (String l : treeSet) {
            n2 = vartonum.get(l);
            tIntHashSet.add(n2);
            tIntHashSet.add(-n2);
        }
        for (String l : treeSet) {
            n2 = vartonum.get(l);
            int arrayList2 = AMODetect.intersectionSize(adjlist.get(n2), tIntHashSet);
            arrayList.add(new IdxDegreePair(n2, arrayList2));
            n = AMODetect.intersectionSize(adjlist.get(-n2), tIntHashSet);
            arrayList.add(new IdxDegreePair(-n2, n));
        }
        Collections.sort(arrayList);
        ArrayList arrayList2 = new ArrayList();
        long l = -1L;
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = ((IdxDegreePair)arrayList.get((int)n)).idx;
            if (!tIntHashSet.contains(n3)) continue;
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            tIntHashSet.remove(n3);
            tIntHashSet.remove(-n3);
            treeSet2.add(n3);
            while (true) {
                int n4;
                int n5;
                l = -1L;
                arrayList3.clear();
                for (n5 = n + 1; n5 < arrayList.size(); ++n5) {
                    n4 = ((IdxDegreePair)arrayList.get((int)n5)).idx;
                    long i = ((IdxDegreePair)arrayList.get((int)n5)).degree;
                    if (l != -1L && i < l) break;
                    if (!tIntHashSet.contains(n4)) continue;
                    boolean string = true;
                    for (Integer n6 : treeSet2) {
                        if (AMODetect.hasEdge(n6, n4)) continue;
                        string = false;
                        break;
                    }
                    if (!string) continue;
                    assert (l == -1L || l == i);
                    l = i;
                    arrayList3.add(n4);
                }
                if (arrayList3.size() == 0) break;
                n5 = -1;
                n4 = -1;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    int n7 = (Integer)arrayList3.get(i);
                    String string = varslist.get(n7 < 0 ? -n7 : n7);
                    long l2 = hashMap.get(string).getValue();
                    int n8 = 0;
                    Iterator iterator = treeSet2.iterator();
                    while (iterator.hasNext()) {
                        int n9 = (Integer)iterator.next();
                        String string2 = varslist.get(n9 < 0 ? -n9 : n9);
                        if (hashMap.get(string2).getValue() != l2) continue;
                        ++n8;
                    }
                    if (n8 <= n4) continue;
                    n4 = n8;
                    n5 = n7;
                }
                treeSet2.add(n5);
                tIntHashSet.remove(n5);
                tIntHashSet.remove(-n5);
            }
            arrayList2.add(treeSet2);
        }
        return arrayList2;
    }

    static int intersectionSize(TIntHashSet tIntHashSet, TIntHashSet tIntHashSet2) {
        int n = 0;
        TIntHashSet tIntHashSet3 = tIntHashSet;
        TIntHashSet tIntHashSet4 = tIntHashSet2;
        if (tIntHashSet2.size() < tIntHashSet.size()) {
            tIntHashSet3 = tIntHashSet2;
            tIntHashSet4 = tIntHashSet;
        }
        TIntIterator tIntIterator = tIntHashSet3.iterator();
        while (tIntIterator.hasNext()) {
            if (!tIntHashSet4.contains(tIntIterator.next())) continue;
            ++n;
        }
        return n;
    }

    static {
        mutexDetect = new ArrayList();
    }
}

