/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.eprimeparser.EPrimeReader;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.NumberConstant;
import savilerow.model.Model;
import savilerow.model.ModelContainer;
import savilerow.model.SymbolTable;
import savilerow.solver.MinionSolver;
import savilerow.solver.Solver;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformMakeSafe;
import savilerow.treetransformer.TransformQuantifiedExpression;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerBottomUp;

public final class SRWorkThread
extends Thread {
    @Override
    public void run() {
        Object object;
        ArrayList<ASTNode> arrayList;
        Object object2;
        if (CmdFlags.getMode() == 2 || CmdFlags.getMode() == 3) {
            object2 = new MinionSolver();
            if (CmdFlags.getMode() == 2) {
                ((Solver)object2).parseSolutionMode();
            } else {
                ((Solver)object2).parseDomainStore();
            }
            System.exit(0);
        }
        if (!CmdFlags.param_to_json) {
            arrayList = new EPrimeReader(CmdFlags.eprimefile, true);
            object2 = ((EPrimeReader)((Object)arrayList)).readModel();
            assert (((Model)object2).constraints != null);
        } else {
            object2 = new Model();
            ((Model)object2).global_symbols = new SymbolTable();
        }
        arrayList = new ArrayList();
        if (CmdFlags.paramfile != null) {
            object = new EPrimeReader(CmdFlags.paramfile, true);
            arrayList = ((EPrimeReader)object).readParameterFile((Model)object2);
        }
        if (CmdFlags.paramstring != null) {
            object = new EPrimeReader(CmdFlags.paramstring, false);
            arrayList = ((EPrimeReader)object).readParameterFile((Model)object2);
        }
        object = new ModelContainer((Model)object2, new ArrayList<ASTNode>(arrayList));
        if (CmdFlags.param_to_json) {
            this.paramToJSON(arrayList, (Model)object2);
            System.exit(0);
        }
        if (CmdFlags.dryruns) {
            ModelContainer modelContainer = ((ModelContainer)object).copy();
            modelContainer.dryrun();
            CmdFlags.startTime = System.currentTimeMillis();
            modelContainer = ((ModelContainer)object).copy();
            modelContainer.dryrun();
            CmdFlags.startTime = System.currentTimeMillis();
            modelContainer = ((ModelContainer)object).copy();
            modelContainer.dryrun();
            CmdFlags.startTime = System.currentTimeMillis();
        }
        CmdFlags.startTime = System.currentTimeMillis();
        if (CmdFlags.make_tab) {
            ((ModelContainer)object).makeTableScopes();
        } else {
            ((ModelContainer)object).process();
        }
        System.exit(0);
    }

    public void paramToJSON(ArrayList<ASTNode> arrayList, Model model) {
        TransformSimplify transformSimplify;
        Object object;
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i);
            object = new TransformMakeSafe(model);
            aSTNode = ((TreeTransformerBottomUp)object).transform(aSTNode);
            transformSimplify = new TransformSimplify();
            aSTNode = transformSimplify.transform(aSTNode);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(model);
            aSTNode = transformQuantifiedExpression.transform(aSTNode);
            aSTNode = transformSimplify.transform(aSTNode);
            arrayList.set(i, aSTNode);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode.getChild(0), aSTNode.getChild(1));
            for (int j = i + 1; j < arrayList.size(); ++j) {
                arrayList.set(j, replaceASTNode.transform(arrayList.get(j)));
            }
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.paramfile + ".json"));
            bufferedWriter.write("{\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                bufferedWriter.write("\"");
                bufferedWriter.write(arrayList.get(i).getChild(0).toString());
                bufferedWriter.write("\" : ");
                object = arrayList.get(i).getChild(1);
                transformSimplify = new TransformSimplify();
                object = transformSimplify.transform((ASTNode)object);
                if (object instanceof BooleanConstant || object instanceof NumberConstant) {
                    bufferedWriter.write(((ASTNode)object).toString());
                } else if (object instanceof EmptyMatrix) {
                    bufferedWriter.write("[ ]");
                } else {
                    bufferedWriter.write(((CompoundMatrix)object).toStringSimpleMatrix());
                }
                if (i < arrayList.size() - 1) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("}\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

