/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import savilerow.CmdFlags;
import savilerow.RemoveRedundantVars;
import savilerow.TabulationUtils;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Equals;
import savilerow.expression.ExistsExpression;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.LessEqual;
import savilerow.expression.MakeTable;
import savilerow.expression.Mapping;
import savilerow.expression.Minimising;
import savilerow.expression.NegativeTable;
import savilerow.expression.NumberConstant;
import savilerow.expression.Table;
import savilerow.expression.TableShort;
import savilerow.expression.Tag;
import savilerow.expression.ToVariable;
import savilerow.expression.WeightedSum;
import savilerow.model.Model;
import savilerow.treetransformer.TransformQuantifiedExpression;

public class Tabulation {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    private static boolean verbose = false;
    private Model m;
    private TabulationUtils tu;
    private long nodelimit;
    ASTNode optVar;
    ASTNode optCt = null;
    ArrayList<ASTNode> optTerms;
    boolean[] optTermsPolarity;
    HashMap<ASTNode, ArrayList<ASTNode>> idToCons = new HashMap();
    private boolean min;

    public Tabulation(Model model) {
        this.m = model;
        this.tu = new TabulationUtils(this.m);
        this.nodelimit = CmdFlags.tabulate_nolimit ? Long.MAX_VALUE : 300000L;
    }

    public void process(boolean bl) {
        this.processMakeTable(this.m.constraints);
        if (!bl) {
            Object object;
            if (CmdFlags.make_short_tab == 3 || CmdFlags.make_short_tab == 4) {
                object = this.buildScopesList(this.m.constraints);
                this.identicalScopes(this.m.constraints, (HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>>)object);
                this.applyHeuristicsBool(this.m.constraints);
            }
            if (CmdFlags.tabulate_opt && this.m.objective != null) {
                this.tabulateObjective();
                object = new RemoveRedundantVars();
                ((RemoveRedundantVars)object).transform(this.m);
            }
            if (CmdFlags.tabulate2) {
                double d = System.currentTimeMillis();
                int n = CmdFlags.make_short_tab;
                CmdFlags.make_short_tab = 1;
                HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap = this.buildScopesList(this.m.constraints);
                this.identicalScopes(this.m.constraints, hashMap);
                this.applyHeuristicsBool2(this.m.constraints, hashMap);
                this.applyHeuristicsNumerical2(this.m.constraints, hashMap);
                CmdFlags.make_short_tab = n;
                CmdFlags.tabtime = ((double)System.currentTimeMillis() - d) / 1000.0;
            }
        }
    }

    private void processMakeTable(ASTNode aSTNode) {
        block5: {
            block6: {
                block4: {
                    if (!(aSTNode instanceof MakeTable)) break block4;
                    if (CmdFlags.make_short_tab == 0) {
                        ASTNode aSTNode2 = aSTNode.getParent();
                        int n = aSTNode.getChildNo();
                        aSTNode.getChild(0).setParent(null);
                        aSTNode2.setChild(n, aSTNode.getChild(0));
                        this.processMakeTable(aSTNode2.getChild(n));
                    } else {
                        ASTNode aSTNode3 = this.tabulate(aSTNode.getChild(0), Long.MAX_VALUE, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, "MakeTableFunction");
                        aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
                    }
                    break block5;
                }
                if (!(aSTNode instanceof Table)) break block6;
                int n = aSTNode.getChild(0).numChildren() - 1;
                ASTNode aSTNode4 = aSTNode.getChildConst(1);
                if (aSTNode4.numChildren() <= 1) break block5;
                if (aSTNode4.getChild(1).getTupleLength() != n) {
                    CmdFlags.errorExit("Table scope size does not match length of tuples.\n" + aSTNode);
                }
                if (aSTNode4.isRegularMatrix()) break block5;
                CmdFlags.errorExit("Table constraint contains irregular matrix (i.e. length of tuples differs).\n" + aSTNode);
                break block5;
            }
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.processMakeTable(aSTNode.getChild(i));
            }
        }
    }

    private void identicalScopes(ASTNode aSTNode, HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap) {
        for (Map.Entry<ArrayList<ASTNode>, ArrayList<ASTNode>> entry : hashMap.entrySet()) {
            ASTNode aSTNode2;
            ArrayList<ASTNode> arrayList = entry.getValue();
            if (arrayList.size() <= 1) continue;
            And and = new And(arrayList);
            if (verbose) {
                System.out.println("H4");
                System.out.println("Trying ct:" + and);
            }
            if ((aSTNode2 = this.tabulate(and, this.nodelimit, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, "IdenticalScopes")) == null) continue;
            this.replaceConstraintSet(arrayList, aSTNode2);
            arrayList.clear();
            arrayList.add(aSTNode2);
        }
    }

    private HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> buildScopesList(ASTNode aSTNode) {
        HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap = new HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>>();
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (aSTNode3 instanceof Table || aSTNode3 instanceof TableShort || aSTNode3 instanceof NegativeTable || aSTNode3 instanceof Tag) continue;
                assert (aSTNode3.isRelation());
                ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode3);
                ASTNode.sortByAlpha(arrayList);
                if (!hashMap.containsKey(arrayList)) {
                    hashMap.put(arrayList, new ArrayList());
                }
                hashMap.get(arrayList).add(aSTNode3);
            }
        }
        return hashMap;
    }

    private void replaceConstraintSet(ArrayList<ASTNode> arrayList, ASTNode aSTNode) {
        ASTNode aSTNode2 = arrayList.get(0);
        aSTNode2.getParent().setChild(aSTNode2.getChildNo(), aSTNode);
        for (int i = 1; i < arrayList.size(); ++i) {
            aSTNode2 = arrayList.get(i);
            aSTNode2.getParent().setChild(aSTNode2.getChildNo(), new BooleanConstant(true));
        }
    }

    private void applyHeuristicsBool(ASTNode aSTNode) {
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3;
                String string;
                ASTNode aSTNode4 = aSTNode2.getChild(i);
                if (aSTNode4 instanceof And || !aSTNode4.isRelation() || aSTNode4 instanceof Table || aSTNode4 instanceof TableShort || aSTNode4 instanceof NegativeTable || aSTNode4 instanceof BooleanConstant || (string = this.heuristic(aSTNode4)) == null || (aSTNode3 = this.tabulate(aSTNode4, this.nodelimit, CmdFlags.make_short_tab == 2 || CmdFlags.make_short_tab == 4, string)) == null) continue;
                aSTNode2.setChild(i, aSTNode3);
            }
        }
    }

    private void applyHeuristicsBool2(ASTNode aSTNode, HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap) {
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            ArrayDeque<ASTNode> arrayDeque = new ArrayDeque<ASTNode>(aSTNode2.getChildren());
            while (!arrayDeque.isEmpty()) {
                Object object;
                ASTNode aSTNode3 = arrayDeque.poll();
                if (!(!aSTNode3.isRelation() || aSTNode3.getDimension() != 0 || aSTNode3 instanceof Table || aSTNode3 instanceof TableShort || aSTNode3 instanceof NegativeTable || aSTNode3 instanceof BooleanConstant || aSTNode3.getParent().inTopAnd())) {
                    And and;
                    object = TabulationUtils.getVariablesOrdered(aSTNode3);
                    ASTNode.sortByAlpha((ArrayList<ASTNode>)object);
                    if (hashMap.containsKey(object) && (hashMap.get(object).size() > 1 || !this.contains(hashMap.get(object).get(0), aSTNode3)) && this.applyHeuristicsBool2Attempt(aSTNode3, and = new And(hashMap.get(object)), "IdenticalScopesNested")) continue;
                }
                if (aSTNode3.isRelation() && aSTNode3.getDimension() == 0 && !(aSTNode3 instanceof Table) && !(aSTNode3 instanceof TableShort) && !(aSTNode3 instanceof NegativeTable) && !(aSTNode3 instanceof BooleanConstant) && (object = this.heuristic(aSTNode3)) != null && this.applyHeuristicsBool2Attempt(aSTNode3, null, (String)(aSTNode3.getParent().inTopAnd() ? object : (String)object + "Nested"))) continue;
                arrayDeque.addAll(aSTNode3.getChildren());
            }
        }
    }

    private boolean applyHeuristicsBool2Attempt(ASTNode aSTNode, ASTNode aSTNode2, String string) {
        ASTNode aSTNode3;
        Serializable serializable;
        if (!(CmdFlags.getMiniontrans() || CmdFlags.getGecodetrans() || CmdFlags.getSattrans() || aSTNode.getParent().inTopAnd())) {
            serializable = TabulationUtils.getVariablesOrdered(aSTNode);
            double d = 1.0;
            for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                d *= (double)Intpair.numValues(((ASTNode)((ArrayList)serializable).get(i)).getIntervalSetExp());
            }
            if (d > (double)this.nodelimit) {
                return false;
            }
        }
        serializable = aSTNode.copy();
        if (aSTNode2 != null) {
            serializable = new And(aSTNode2.copy(), (ASTNode)serializable);
        }
        if ((aSTNode3 = this.tabulate((ASTNode)serializable, this.nodelimit, false, string)) != null) {
            aSTNode.getParent().setChild(aSTNode.getChildNo(), aSTNode3);
            return true;
        }
        return false;
    }

    private void applyHeuristicsNumerical2(ASTNode aSTNode, HashMap<ArrayList<ASTNode>, ArrayList<ASTNode>> hashMap) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        HashMap<ASTNode, ASTNode> hashMap2 = new HashMap<ASTNode, ASTNode>();
        if (aSTNode.getChild(0) instanceof And) {
            ASTNode aSTNode2 = aSTNode.getChild(0);
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                ArrayDeque<ASTNode> arrayDeque = new ArrayDeque<ASTNode>(aSTNode3.getChildren());
                while (!arrayDeque.isEmpty()) {
                    ASTNode aSTNode4 = arrayDeque.poll();
                    ASTNode aSTNode5 = aSTNode4.getParent();
                    if (!(!aSTNode4.isNumerical() || aSTNode4 instanceof Identifier || aSTNode4 instanceof NumberConstant || aSTNode4 instanceof Mapping || aSTNode4.getDimension() != 0 || !aSTNode4.toFlatten(false) || aSTNode5 instanceof ToVariable || aSTNode5 instanceof Equals)) {
                        ASTNode aSTNode6;
                        ASTNode aSTNode7;
                        ASTNode aSTNode8;
                        if (hashMap2.containsKey(aSTNode4)) {
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), (ASTNode)hashMap2.get(aSTNode4));
                            continue;
                        }
                        ASTNode aSTNode9 = this.m.global_symbols.newAuxHelper(aSTNode4);
                        Equals equals = new Equals(aSTNode4.copy(), aSTNode9);
                        ArrayList<ASTNode> arrayList2 = TabulationUtils.getVariablesOrdered(aSTNode4);
                        ASTNode.sortByAlpha(arrayList2);
                        if (hashMap.containsKey(arrayList2) && (hashMap.get(arrayList2).size() > 1 || !this.contains(hashMap.get(arrayList2).get(0), aSTNode4)) && (aSTNode8 = this.tabulate(new And((ASTNode)equals, aSTNode7 = new And(hashMap.get(arrayList2))), this.nodelimit, false, "IdenticalScopesNestedNum")) != null) {
                            arrayList.add(aSTNode8);
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), aSTNode9);
                            hashMap2.put(aSTNode4, aSTNode9);
                            continue;
                        }
                        aSTNode7 = aSTNode4.getParent();
                        aSTNode7.setChild(aSTNode4.getChildNo(), aSTNode9);
                        boolean bl = aSTNode3.strongProp();
                        aSTNode4.setParent(null);
                        aSTNode7.setChild(aSTNode4.getChildNo(), aSTNode4);
                        boolean bl2 = bl && !((ASTNode)equals).strongProp();
                        String string = this.heuristic(equals);
                        if ((bl2 || string != null) && (aSTNode6 = this.tabulate(equals, this.nodelimit, false, bl2 ? "WeakPropagation1NestedNum" : string + "NestedNum")) != null) {
                            arrayList.add(aSTNode6);
                            aSTNode4.getParent().setChild(aSTNode4.getChildNo(), aSTNode9);
                            hashMap2.put(aSTNode4, aSTNode9);
                            continue;
                        }
                        this.m.global_symbols.deleteSymbol(aSTNode9.toString());
                    }
                    arrayDeque.addAll(aSTNode4.getChildren());
                }
            }
            aSTNode.getChild(0).setParent(null);
            aSTNode.setChild(0, new And(aSTNode.getChild(0), new And(arrayList)));
        }
    }

    private void tabulateObjective() {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        int n;
        ASTNode aSTNode;
        this.min = this.m.objective instanceof Minimising;
        this.optVar = this.m.objective.getChild(0);
        this.findOptCt(this.m.constraints);
        System.out.println("In tabulateObjective, optimisation constraint:" + this.optCt);
        if (this.optCt instanceof ToVariable && this.optCt.getChild(1).equals(this.optVar) && this.optCt.getChild(0) instanceof WeightedSum || this.optCt instanceof Equals && this.optCt.getChild(1).equals(this.optVar) && this.optCt.getChild(0) instanceof WeightedSum || this.optCt instanceof Equals && this.optCt.getChild(0).equals(this.optVar) && this.optCt.getChild(1) instanceof WeightedSum || this.optCt instanceof LessEqual && this.optCt.getChild(1).equals(this.optVar) && this.optCt.getChild(0) instanceof WeightedSum && this.min || this.optCt instanceof LessEqual && this.optCt.getChild(0).equals(this.optVar) && this.optCt.getChild(1) instanceof WeightedSum && !this.min) {
            aSTNode = this.optCt.getChild(0) instanceof WeightedSum ? this.optCt.getChild(0) : this.optCt.getChild(1);
            this.optTerms = aSTNode.getChildren();
            this.optTermsPolarity = new boolean[this.optTerms.size()];
            for (int i = 0; i < this.optTerms.size(); ++i) {
                this.optTermsPolarity[i] = ((WeightedSum)aSTNode).getWeight(i) > 0L;
            }
        } else {
            return;
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < this.optTerms.size(); ++i) {
            arrayList.add(null);
            arrayList2.add(null);
        }
        this.collectIdentifiers(this.m.constraints);
        ArrayList<Serializable> arrayList3 = new ArrayList<Serializable>();
        for (n = 0; n < this.optTerms.size(); ++n) {
            if (this.optTerms.get(n) instanceof Identifier) {
                serializable3 = this.idToCons.get(this.optTerms.get(n));
                if (serializable3 == null) {
                    serializable3 = new ArrayList();
                }
                serializable2 = new ArrayList();
                for (int i = 0; i < ((ArrayList)serializable3).size(); ++i) {
                    if (((ArrayList)serializable3).get(i) == this.optCt) continue;
                    ((ArrayList)serializable2).add((ASTNode)((ArrayList)serializable3).get(i));
                }
                arrayList3.add(serializable2);
                continue;
            }
            serializable3 = this.m.global_symbols.newAuxHelper(this.optTerms.get(n));
            serializable2 = new Equals(this.optTerms.get(n).copy(), (ASTNode)serializable3);
            ASTNode aSTNode2 = this.optTerms.get(n).getParent();
            aSTNode2.setChild(this.optTerms.get(n).getChildNo(), (ASTNode)serializable3);
            arrayList.set(n, serializable3);
            arrayList2.set(n, this.optTerms.get(n));
            ArrayList<Serializable> arrayList4 = new ArrayList<Serializable>();
            arrayList4.add(serializable2);
            arrayList3.add(arrayList4);
            this.optTerms.set(n, (ASTNode)serializable3);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            serializable3 = new And((ArrayList)arrayList3.get(n));
            serializable2 = TabulationUtils.getVariablesOrdered((ASTNode)serializable3);
            HashSet<ASTNode> hashSet = new HashSet<ASTNode>();
            hashSet.add(this.optTerms.get(n));
            for (int i = 2; ((ArrayList)serializable2).size() == i; ++i) {
                int n2;
                serializable = null;
                for (n2 = 0; n2 < ((ArrayList)serializable2).size(); ++n2) {
                    if (hashSet.contains(((ArrayList)serializable2).get(n2))) continue;
                    serializable = (ASTNode)((ArrayList)serializable2).get(n2);
                }
                assert (serializable != null);
                for (n2 = 0; n2 < this.idToCons.get(serializable).size(); ++n2) {
                    if (this.idToCons.get(serializable).get(n2) == this.optCt) continue;
                    System.out.println("Adding to constraint set:" + this.idToCons.get(serializable).get(n2));
                    ((ArrayList)arrayList3.get(n)).add(this.idToCons.get(serializable).get(n2));
                }
                hashSet.addAll((Collection<ASTNode>)((Object)serializable2));
                serializable3 = new And((ArrayList)arrayList3.get(n));
                serializable2 = TabulationUtils.getVariablesOrdered((ASTNode)serializable3);
            }
        }
        System.out.println(this.optTerms);
        System.out.println(arrayList3);
        TabulationUtils tabulationUtils = new TabulationUtils(this.m);
        serializable3 = new ArrayList();
        for (int i = 0; i < this.optTerms.size(); ++i) {
            Serializable serializable4;
            ASTNode aSTNode3 = new And((ArrayList)arrayList3.get(i));
            boolean bl = this.optTermsPolarity[i] && this.min || !this.optTermsPolarity[i] && !this.min;
            serializable = TabulationUtils.getVariablesOrdered(aSTNode3);
            ArrayList<ASTNode> arrayList5 = tabulationUtils.getDomains((ArrayList<ASTNode>)serializable);
            boolean bl2 = false;
            for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                serializable4 = (ASTNode)((ArrayList)serializable).get(j);
                ArrayList<ASTNode> arrayList6 = TabulationUtils.getVariablesDup(aSTNode3);
                int n3 = 0;
                for (int k = 0; k < arrayList6.size(); ++k) {
                    if (!arrayList6.get(k).equals(serializable4)) continue;
                    ++n3;
                }
                if (!this.idToCons.containsKey(serializable4) || this.idToCons.get(serializable4).size() != n3) continue;
                aSTNode3 = new ExistsExpression((ASTNode)((ArrayList)serializable).get(j), arrayList5.get(j), aSTNode3);
                bl2 = true;
            }
            if (bl2) {
                TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
                aSTNode3 = transformQuantifiedExpression.transform(aSTNode3);
            }
            System.out.println("About to tabulate (objective):" + aSTNode3);
            ASTNode aSTNode4 = tabulationUtils.makeTableLongDominance(aSTNode3, this.nodelimit, this.optTerms.get(i), bl);
            if (aSTNode4 == null) {
                if (arrayList2.get(i) == null) continue;
                System.out.println("Failed to tabulate. Restoring term of objective function.");
                aSTNode.setChild(i, (ASTNode)arrayList2.get(i));
                this.m.global_symbols.deleteSymbol(((ASTNode)arrayList.get(i)).toString());
                continue;
            }
            serializable4 = (ArrayList)arrayList3.get(i);
            for (int j = 0; j < ((ArrayList)serializable4).size(); ++j) {
                if (((ASTNode)((ArrayList)serializable4).get(j)).getParent() == null) continue;
                ((ASTNode)((ArrayList)serializable4).get(j)).getParent().setChild(((ASTNode)((ArrayList)serializable4).get(j)).getChildNo(), new BooleanConstant(true));
            }
            ((ArrayList)serializable3).add(aSTNode4);
        }
        this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), new And((ArrayList<ASTNode>)serializable3)));
    }

    void findOptCt(ASTNode aSTNode) {
        if (aSTNode.equals(this.optVar)) {
            ASTNode aSTNode2 = aSTNode.getParent();
            while (!aSTNode2.isRelation()) {
                aSTNode2 = aSTNode2.getParent();
            }
            this.optCt = aSTNode2;
            return;
        }
        for (int i = 0; i < aSTNode.numChildren() && this.optCt == null; ++i) {
            this.findOptCt(aSTNode.getChild(i));
        }
    }

    void collectIdentifiers(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            ASTNode aSTNode2 = aSTNode.getParent();
            while (!aSTNode2.isRelation() || aSTNode2.getDimension() != 0) {
                aSTNode2 = aSTNode2.getParent();
            }
            if (!this.idToCons.containsKey(aSTNode)) {
                this.idToCons.put(aSTNode, new ArrayList());
            }
            this.idToCons.get(aSTNode).add(aSTNode2);
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.collectIdentifiers(aSTNode.getChild(i));
            }
        }
    }

    private String heuristic(ASTNode aSTNode) {
        ASTNode aSTNode2;
        ArrayList<ASTNode> arrayList = TabulationUtils.getVariablesOrdered(aSTNode);
        ArrayList<ASTNode> arrayList2 = TabulationUtils.getVariablesDup(aSTNode);
        if (arrayList.size() < arrayList2.size() && arrayList.size() <= 10) {
            if (verbose) {
                System.out.println("H1");
            }
            return "DuplicateVariables";
        }
        if (aSTNode.treesize() > 5 * arrayList.size()) {
            if (verbose) {
                System.out.println("H2");
            }
            return "LargeAST";
        }
        if (!aSTNode.strongProp() && arrayList.size() <= 10 && (aSTNode2 = this.m.constraints.getChild(0)) instanceof And) {
            for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                ASTNode aSTNode3 = aSTNode2.getChild(i);
                if (!aSTNode3.strongProp()) continue;
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!aSTNode3.contains(arrayList.get(j))) continue;
                    if (verbose) {
                        System.out.println("H3");
                    }
                    return "WeakPropagation";
                }
            }
        }
        return null;
    }

    public boolean contains(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == aSTNode2) {
            return true;
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            if (!this.contains(aSTNode.getChild(i), aSTNode2)) continue;
            return true;
        }
        return false;
    }

    public ASTNode tabulate(ASTNode aSTNode, long l, boolean bl, String string) {
        ASTNode aSTNode2;
        ASTNode aSTNode3 = this.tu.normalise(aSTNode);
        if (CmdFlags.tabulate_diagnostics) {
            CmdFlags.println(ANSI_RED + string + ANSI_RESET + "   Attempting tabulation: " + aSTNode3);
        }
        TabulationUtils.RetPair retPair = this.tu.tryCacheNormalised(aSTNode, bl);
        if (retPair.nodereplace != null) {
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println("\u001b[32mTabulated\u001b[0m by retrieving from cache.");
            }
            return retPair.nodereplace.current_node;
        }
        long l2 = -1L;
        if (!bl) {
            aSTNode2 = this.tu.makeTableLong(aSTNode3, l);
            l2 = this.tu.nodecount;
        } else {
            aSTNode2 = l == Long.MAX_VALUE ? this.tu.makeTableShort(aSTNode3, l, l, l) : this.tu.makeTableShort(aSTNode3, 10000L, 100000L, 100000L);
        }
        if (aSTNode2 == null) {
            this.tu.saveToFailCache(retPair.expstring);
            if (verbose) {
                System.out.println("Adding to failCache:" + retPair.expstring);
            }
        } else {
            this.tu.saveToCacheNormalised(retPair.expstring, aSTNode3, aSTNode2);
            if (CmdFlags.tabulate_diagnostics) {
                CmdFlags.println("\u001b[32mTabulated\u001b[0m in nodes:" + l2);
            }
        }
        return aSTNode2;
    }
}

