/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanDomain;
import savilerow.expression.BooleanDomainFull;
import savilerow.expression.EmptyRange;
import savilerow.expression.IntegerDomain;
import savilerow.expression.IntegerDomainConcrete;
import savilerow.expression.IntegerDomainConcreteArray;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;

public class Intpair
implements Comparable<Intpair> {
    public long lower;
    public long upper;

    public Intpair(long l, long l2) {
        this.lower = l;
        this.upper = l2;
    }

    public String toString() {
        return "(" + this.lower + "," + this.upper + ")";
    }

    public boolean isEmpty() {
        return this.lower > this.upper;
    }

    public Intpair intersect(Intpair intpair) {
        long l = this.lower < intpair.lower ? intpair.lower : this.lower;
        long l2 = this.upper < intpair.upper ? this.upper : intpair.upper;
        return new Intpair(l, l2);
    }

    public Intpair intersectNull(Intpair intpair) {
        long l;
        long l2 = this.lower < intpair.lower ? intpair.lower : this.lower;
        long l3 = l = this.upper < intpair.upper ? this.upper : intpair.upper;
        if (l2 > l) {
            return null;
        }
        return new Intpair(l2, l);
    }

    public Intpair union(Intpair intpair) {
        long l = this.lower < intpair.lower ? this.lower : intpair.lower;
        long l2 = this.upper > intpair.upper ? this.upper : intpair.upper;
        return new Intpair(l, l2);
    }

    public Intpair merge(Intpair intpair) {
        if (this.upper < intpair.lower - 1L || this.lower - 1L > intpair.upper) {
            return null;
        }
        long l = this.lower < intpair.lower ? this.lower : intpair.lower;
        long l2 = this.upper < intpair.upper ? intpair.upper : this.upper;
        return new Intpair(l, l2);
    }

    public ArrayList<Intpair> subtract(Intpair intpair) {
        Intpair intpair2;
        Intpair intpair3 = this.intersect(intpair);
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        long l = this.lower;
        long l2 = this.upper < intpair3.lower - 1L ? this.upper : intpair3.lower - 1L;
        long l3 = this.lower > intpair3.upper + 1L ? this.lower : intpair3.upper + 1L;
        long l4 = this.upper;
        Intpair intpair4 = new Intpair(l, l2);
        if (!intpair4.isEmpty()) {
            arrayList.add(intpair4);
        }
        if (!(intpair2 = new Intpair(l3, l4)).isEmpty()) {
            arrayList.add(intpair2);
        }
        return arrayList;
    }

    @Override
    public int compareTo(Intpair intpair) {
        if (this.lower > intpair.lower) {
            return 1;
        }
        if (this.lower == intpair.lower) {
            if (this.upper > intpair.upper) {
                return 1;
            }
            if (this.upper == intpair.upper) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Intpair)) {
            return false;
        }
        Intpair intpair = (Intpair)object;
        return intpair.lower == this.lower && intpair.upper == this.upper;
    }

    public int hashCode() {
        return 3853 + Objects.hash(this.lower, this.upper);
    }

    public Intpair copy() {
        return new Intpair(this.lower, this.upper);
    }

    public static boolean in(ArrayList<Intpair> arrayList, long l) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (l < arrayList.get((int)i).lower || l > arrayList.get((int)i).upper) continue;
            return true;
        }
        return false;
    }

    public static long BigIntegerToLong(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) <= 0) {
            return Long.MIN_VALUE;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
            return Long.MAX_VALUE;
        }
        return bigInteger.longValue();
    }

    public static ASTNode makeDomain(ArrayList<Intpair> arrayList, boolean bl) {
        Intpair.normalise(arrayList);
        if (bl) {
            assert (arrayList.size() <= 1);
            assert (arrayList.size() == 0 || arrayList.get((int)0).lower >= 0L && arrayList.get((int)0).upper <= 1L);
            if (arrayList.size() == 0) {
                return new BooleanDomain(new EmptyRange());
            }
            if (arrayList.get((int)0).lower == 0L && arrayList.get((int)0).upper == 1L) {
                return new BooleanDomainFull();
            }
            return new BooleanDomain(new Range((ASTNode)NumberConstant.make(arrayList.get((int)0).lower), NumberConstant.make(arrayList.get((int)0).upper)));
        }
        if (arrayList.size() == 1 && arrayList.get((int)0).lower >= Integer.MIN_VALUE && arrayList.get((int)0).upper <= Integer.MAX_VALUE) {
            return new IntegerDomainConcrete((int)arrayList.get((int)0).lower, (int)arrayList.get((int)0).upper);
        }
        if (arrayList.size() >= 1 && arrayList.get((int)0).lower > Long.MIN_VALUE && arrayList.get((int)(arrayList.size() - 1)).upper < Long.MAX_VALUE) {
            return new IntegerDomainConcreteArray(arrayList);
        }
        if (arrayList.size() == 0) {
            return new IntegerDomain(new EmptyRange());
        }
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            if (intpair.lower == intpair.upper) {
                arrayList2.add(NumberConstant.make(intpair.lower));
                continue;
            }
            NumberConstant numberConstant = intpair.lower == Long.MIN_VALUE ? null : NumberConstant.make(intpair.lower);
            NumberConstant numberConstant2 = intpair.upper == Long.MAX_VALUE ? null : NumberConstant.make(intpair.upper);
            arrayList2.add(new Range((ASTNode)numberConstant, numberConstant2));
        }
        return new IntegerDomain(arrayList2);
    }

    public static ASTNode makeDomain(long l, long l2, boolean bl) {
        if (bl) {
            if (l == 0L && l2 == 1L) {
                return new BooleanDomainFull();
            }
            return new BooleanDomain(new Range((ASTNode)NumberConstant.make(l), NumberConstant.make(l2)));
        }
        if (l < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            return new IntegerDomain(new Range((ASTNode)NumberConstant.make(l), NumberConstant.make(l2)));
        }
        return new IntegerDomainConcrete((int)l, (int)l2);
    }

    public static long numValues(ArrayList<Intpair> arrayList) {
        assert (arrayList != null);
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            l = l + arrayList.get((int)i).upper - arrayList.get((int)i).lower + 1L;
        }
        return l;
    }

    public static ArrayList<Intpair> multIntervalSet(ArrayList<Intpair> arrayList, long l) {
        if (l == 1L) {
            return arrayList;
        }
        if (l == -1L) {
            ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>(arrayList.size());
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Intpair intpair = new Intpair(-arrayList.get((int)i).upper, -arrayList.get((int)i).lower);
                arrayList2.add(intpair);
            }
            return arrayList2;
        }
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        if (l > 0L) {
            for (int i = 0; i < arrayList.size(); ++i) {
                for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                    arrayList3.add(new Intpair(j * l, j * l));
                }
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                for (long j = arrayList.get((int)i).upper; j >= arrayList.get((int)i).lower; --j) {
                    arrayList3.add(new Intpair(j * l, j * l));
                }
            }
        }
        return arrayList3;
    }

    public static ArrayList<Intpair> scaleIntervalSet(ArrayList<Intpair> arrayList, long l) {
        ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>(arrayList.size());
        if (l > 0L) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(new Intpair(arrayList.get((int)i).lower * l, arrayList.get((int)i).upper * l));
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                arrayList2.add(new Intpair(arrayList.get((int)i).upper * l, arrayList.get((int)i).lower * l));
            }
        }
        return arrayList2;
    }

    public static ArrayList<Intpair> shiftIntervalSet(ArrayList<Intpair> arrayList, long l) {
        for (Intpair intpair : arrayList) {
            intpair.lower += l;
            intpair.upper += l;
        }
        return arrayList;
    }

    public static ArrayList<Intpair> union(ArrayList<Intpair> arrayList, ArrayList<Intpair> arrayList2) {
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>(arrayList.size() + arrayList2.size());
        int n = 0;
        int n2 = 0;
        while (n < arrayList.size() || n2 < arrayList2.size()) {
            if (n == arrayList.size()) {
                arrayList3.add(arrayList2.get(n2).copy());
                ++n2;
                continue;
            }
            if (n2 == arrayList2.size()) {
                arrayList3.add(arrayList.get(n).copy());
                ++n;
                continue;
            }
            Intpair intpair = arrayList.get(n);
            Intpair intpair2 = arrayList2.get(n2);
            if (intpair.upper + 1L < intpair2.lower) {
                arrayList3.add(intpair.copy());
                ++n;
                continue;
            }
            if (intpair2.upper + 1L < intpair.lower) {
                arrayList3.add(intpair2.copy());
                ++n2;
                continue;
            }
            Intpair intpair3 = intpair.merge(intpair2);
            assert (intpair3 != null);
            ++n;
            ++n2;
            while (n < arrayList.size() || n2 < arrayList2.size()) {
                Intpair intpair4;
                boolean bl = false;
                if (n < arrayList.size() && (intpair4 = intpair3.merge(arrayList.get(n))) != null) {
                    intpair3 = intpair4;
                    ++n;
                    bl = true;
                }
                if (n2 < arrayList2.size() && (intpair4 = intpair3.merge(arrayList2.get(n2))) != null) {
                    intpair3 = intpair4;
                    ++n2;
                    bl = true;
                }
                if (bl) continue;
                break;
            }
            arrayList3.add(intpair3);
        }
        return arrayList3;
    }

    public static void normalise(ArrayList<Intpair> arrayList) {
        int n;
        int n2;
        Collections.sort(arrayList);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Intpair intpair;
            if (arrayList.get(n2) == null) continue;
            for (n = n2 + 1; n < arrayList.size() && (intpair = arrayList.get(n2).merge(arrayList.get(n))) != null; ++n) {
                arrayList.set(n2, intpair);
                arrayList.set(n, null);
            }
        }
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) == null) continue;
            arrayList.set(n2, arrayList.get(n));
            ++n2;
        }
        arrayList.subList(n2, arrayList.size()).clear();
    }

    public static ArrayList<Intpair> intersection(ArrayList<Intpair> arrayList, ArrayList<Intpair> arrayList2) {
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        int n = 0;
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = n; j < arrayList2.size(); ++j) {
                Intpair intpair = arrayList.get(i).intersectNull(arrayList2.get(j));
                if (intpair != null) {
                    arrayList3.add(intpair);
                    n = j;
                    continue;
                }
                if (arrayList2.get((int)j).lower > arrayList.get((int)i).upper) continue block0;
            }
        }
        return arrayList3;
    }

    public static ArrayList<Intpair> setDifference(ArrayList<Intpair> arrayList, ArrayList<Intpair> arrayList2) {
        return Intpair.intersection(arrayList, Intpair.complement(arrayList2));
    }

    public static ArrayList<Intpair> complement(ArrayList<Intpair> arrayList) {
        ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>(arrayList.size() + 1);
        if (arrayList.size() == 0) {
            arrayList2.add(new Intpair(Long.MIN_VALUE, Long.MAX_VALUE));
        } else {
            if (arrayList.get((int)0).lower != Long.MIN_VALUE) {
                arrayList2.add(new Intpair(Long.MIN_VALUE, arrayList.get((int)0).lower - 1L));
            }
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                arrayList2.add(new Intpair(arrayList.get((int)i).upper + 1L, arrayList.get((int)(i + 1)).lower - 1L));
            }
            if (arrayList.get((int)(arrayList.size() - 1)).upper != Long.MAX_VALUE) {
                arrayList2.add(new Intpair(arrayList.get((int)(arrayList.size() - 1)).upper + 1L, Long.MAX_VALUE));
            }
        }
        return arrayList2;
    }

    public static boolean contains(ArrayList<Intpair> arrayList, long l) {
        int n = arrayList.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = n2 + (n - n2) / 2;
            if (l < arrayList.get((int)n3).lower) {
                n = n3 - 1;
                continue;
            }
            if (l > arrayList.get((int)n3).upper) {
                n2 = n3 + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static long location(ArrayList<Intpair> arrayList, long l) {
        long l2 = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            if (l >= intpair.lower && l <= intpair.upper) {
                return l2 + l - intpair.lower;
            }
            l2 = l2 + intpair.upper - intpair.lower + 1L;
        }
        return -1L;
    }

    public static int intervalForVal(ArrayList<Intpair> arrayList, long l) {
        int n = arrayList.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = n2 + (n - n2) / 2;
            if (l < arrayList.get((int)n3).lower) {
                n = n3 - 1;
                continue;
            }
            if (l > arrayList.get((int)n3).upper) {
                n2 = n3 + 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    public static long lookup(ArrayList<Intpair> arrayList, long l) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            long l2 = intpair.upper - intpair.lower + 1L;
            if (l < l2) {
                return intpair.lower + l;
            }
            l -= l2;
        }
        assert (false);
        return 0L;
    }

    public static String printValues(ArrayList<Intpair> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                stringBuilder.append(String.valueOf(j));
                if (i >= arrayList.size() - 1 && j >= arrayList.get((int)i).upper) continue;
                stringBuilder.append(",");
            }
        }
        return stringBuilder.toString();
    }

    public static ArrayList<Intpair> makeList(long l, long l2) {
        assert (l2 >= l);
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        arrayList.add(new Intpair(l, l2));
        return arrayList;
    }
}

