/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.solver.InteractiveStats;

public class Stats {
    private HashMap<String, String> values = new HashMap();
    protected HashSet<String> toAdd;

    public Stats() {
        String[] stringArray = new String[]{"SolverSolveTime", "SolverSetupTime", "SolverTotalTime", "SolverNodes", "SolverSolutionsFound"};
        this.toAdd = new HashSet<String>(Arrays.asList(stringArray));
        this.putValue("SavileRowTimeOut", "0");
        this.putValue("SavileRowClauseOut", "0");
        if (CmdFlags.tabtime > -1.0) {
            this.putValue("TabulationTime", String.valueOf(CmdFlags.tabtime));
        }
    }

    public String getValue(String string) {
        if (this.values.containsKey(string)) {
            return this.values.get(string);
        }
        return "NA";
    }

    public void putValue(String string, String string2) {
        this.values.put(string, string2);
    }

    public boolean hasValue(String string) {
        return this.values.containsKey(string);
    }

    public String toString() {
        String string = "";
        for (String string2 : this.values.keySet()) {
            string = string + string2 + ":" + this.getValue(string2) + "\n";
        }
        return string;
    }

    public String report(String string) {
        return "Minion " + string + ": " + this.getValue(string);
    }

    public void writeR(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("\"" + CmdFlags.eprimefile + "\"  ");
        bufferedWriter.write("\"" + CmdFlags.paramfile + "\"  ");
        if (CmdFlags.getUsePropagate()) {
            bufferedWriter.write("1  ");
        } else {
            bufferedWriter.write("0  ");
        }
        if (CmdFlags.getUseACCSE()) {
            bufferedWriter.write("1  ");
        } else {
            bufferedWriter.write("0  ");
        }
        bufferedWriter.write(CmdFlags.accse_heuristic + "  ");
        bufferedWriter.write(this.getValue("SolverSolveTime") + "  ");
        bufferedWriter.write(this.getValue("SolverTotalTime") + "  ");
        bufferedWriter.write(this.getValue("SolverSetupTime") + "  ");
        bufferedWriter.write(this.getValue("SolverNodes") + "  ");
        bufferedWriter.write(this.getValue("SolverTimeOut") + "  ");
        bufferedWriter.write(this.getValue("SolverSatisfiable") + "  ");
        bufferedWriter.write(this.getValue("SavileRowTotalTime") + "  ");
        bufferedWriter.write(this.getValue("SolverMemOut") + "  ");
        bufferedWriter.write(this.getValue("SavileRowTimeOut") + "  ");
        bufferedWriter.write(this.getValue("SavileRowClauseOut") + "  ");
        bufferedWriter.write(this.getValue("SATVars") + "  ");
        bufferedWriter.write(this.getValue("SATClauses") + "\n");
    }

    public Stats add(Stats stats) {
        Stats stats2 = null;
        stats2 = stats instanceof InteractiveStats ? new InteractiveStats() : new Stats();
        for (String string : this.values.keySet()) {
            if (this.toAdd.contains(string)) {
                stats2.putValue(string, this.sum(stats.getValue(string), this.getValue(string)));
                continue;
            }
            stats2.putValue(string, this.max(stats.getValue(string), this.getValue(string)));
        }
        return stats2;
    }

    String max(String string, String string2) {
        if (string.equals("NA") && string2.equals("NA")) {
            return "NA";
        }
        if (string.equals("NA")) {
            return string2;
        }
        if (string2.equals("NA")) {
            return string;
        }
        if (Double.valueOf(string) > Double.valueOf(string2)) {
            return string;
        }
        return string2;
    }

    String sum(String string, String string2) {
        if (string.equals("NA") && string2.equals("NA")) {
            return "NA";
        }
        if (string.equals("NA")) {
            return string2;
        }
        if (string2.equals("NA")) {
            return string;
        }
        return String.valueOf(Double.valueOf(string) + Double.valueOf(string2));
    }

    public void makeInfoFiles() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.infofile, CmdFlags.dominanceRelation));
            bufferedWriter.write(this.toString());
            if (CmdFlags.dominanceRelation) {
                bufferedWriter.write("----------\n");
            }
            bufferedWriter.close();
            bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.infofile + "r"));
            this.writeR(bufferedWriter);
            bufferedWriter.close();
            CmdFlags.println("Created information file " + CmdFlags.infofile);
        }
        catch (IOException iOException) {
            CmdFlags.println("Could not open file for info output.");
        }
    }
}

