/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Intpair;
import savilerow.expression.MakeTable;
import savilerow.expression.NumberConstant;
import savilerow.expression.Quantifier;
import savilerow.expression.SimpleDomain;
import savilerow.treetransformer.ReplaceASTNode;

public class ForallExpression
extends Quantifier {
    public static final long serialVersionUID = 1L;

    public ForallExpression(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new ForallExpression(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public String toString() {
        return "(forall " + this.getChild(0) + " : " + this.getChild(1) + " . " + this.getChild(2) + ")";
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(2) instanceof BooleanConstant && this.getChild(2).getValue() == 1L) {
            return new BooleanConstant(true);
        }
        if (this.getChild(1) instanceof SimpleDomain && this.getChild(1).getCategory() == 0) {
            Intpair intpair = this.getChild(1).getBounds();
            if (intpair.lower + 100L >= intpair.upper && !this.checkMakeTable(this)) {
                ArrayList<Intpair> arrayList = this.getChild(1).getIntervalSet();
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                        ASTNode aSTNode = this.getChild(2).copy();
                        ReplaceASTNode replaceASTNode = new ReplaceASTNode(this.getChild(0), NumberConstant.make(j));
                        aSTNode = replaceASTNode.transform(aSTNode);
                        arrayList2.add(aSTNode);
                    }
                }
                return new And(arrayList2);
            }
        }
        return null;
    }

    boolean checkMakeTable(ASTNode aSTNode) {
        if (aSTNode instanceof MakeTable) {
            return true;
        }
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            if (!this.checkMakeTable(aSTNode.getChild(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inTopConjunction() {
        return this.getParent().inTopConjunction();
    }
}

