/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Xor
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Xor(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public Xor(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    public Xor(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    @Override
    public ASTNode copy() {
        return new Xor(this.getChildrenArray());
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).strongProp()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        int n;
        int n2;
        boolean bl = false;
        ArrayList<ASTNode> arrayList = this.getChildren();
        if (!CmdFlags.getOutputReady()) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (!(arrayList.get(n2) instanceof Xor)) continue;
                bl = true;
                ASTNode aSTNode = arrayList.remove(n2);
                --n2;
                arrayList.addAll(aSTNode.getChildren());
            }
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).isConstant()) continue;
            long l = arrayList.get(i).getValue();
            n2 ^= l == 1L ? 1 : 0;
            ++n3;
            arrayList.remove(i);
            --i;
        }
        if (n3 > 0 && n2 != 0) {
            arrayList.add(new BooleanConstant(true));
        }
        if (n3 > 1 || n3 == 1 && n2 == 0) {
            bl = true;
        }
        HashMap<ASTNode, Integer> hashMap = new HashMap<ASTNode, Integer>();
        for (n = 0; n < arrayList.size(); ++n) {
            ASTNode aSTNode = arrayList.get(n);
            if (hashMap.containsKey(aSTNode)) {
                int n4 = (Integer)hashMap.get(aSTNode);
                arrayList.remove(n);
                arrayList.remove(n4);
                hashMap.remove(aSTNode);
                n -= 2;
                continue;
            }
            hashMap.put(aSTNode, n);
        }
        if (arrayList.size() == 0) {
            return new BooleanConstant(false);
        }
        if (arrayList.size() == 1) {
            arrayList.get(0).setParent(null);
            return arrayList.get(0);
        }
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList.get(n).setParent(null);
            }
            return new Xor(arrayList);
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        arrayList.add(new BooleanConstant(true));
        return new Xor(arrayList);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: 'Xor' contains something other than a relation:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Xor.sortByHashcode(arrayList);
        if (bl) {
            return new Xor(arrayList);
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Xor.sortByAlpha(arrayList);
        if (bl) {
            return new Xor(arrayList);
        }
        return null;
    }

    @Override
    public boolean isCommAssoc() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i).toString());
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(" xor ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        bufferedWriter.append("diseq(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint bool_xor(");
        this.getChild(0).toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, true);
        stringBuilder.append(" xor ");
        this.getChild(1).toMinizinc(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        assert (this.numChildren() == 2);
        this.ternaryXorEncode(sat, this.getChild(0).directEncode(sat, 1L), this.getChild(1).directEncode(sat, 1L), sat.getTrue());
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        assert (this.numChildren() == 2);
        this.ternaryXorEncode(sat, this.getChild(0).directEncode(sat, 1L), this.getChild(1).directEncode(sat, 1L), l);
    }

    private void ternaryXorEncode(Sat sat, long l, long l2, long l3) throws IOException {
        sat.addClause(-l, -l2, -l3);
        sat.addClause(-l, l2, l3);
        sat.addClause(l, -l2, l3);
        sat.addClause(l, l2, -l3);
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

