/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.And;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Container;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.InSet;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;
import savilerow.model.Model;
import savilerow.model.SymbolTable;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformQuantifiedExpression;
import savilerow.treetransformer.TransformSimplify;

public class ComprehensionMatrix
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ComprehensionMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList, ASTNode aSTNode2) {
        super(aSTNode, new Container(arrayList), aSTNode2, new IntegerDomain(new Range((ASTNode)NumberConstant.make(1L), null)));
    }

    public ComprehensionMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, new Container(arrayList), aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new ComprehensionMatrix(this.getChild(0), this.getChild(1).getChildren(), this.getChild(2), this.getChild(3));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public int getDimension() {
        return 1 + this.getChild(0).getDimension();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!(this.getChild(0).typecheck(symbolTable) && this.getChild(1).typecheck(symbolTable) && this.getChild(2).typecheck(symbolTable) && this.getChild(3).typecheck(symbolTable))) {
            return false;
        }
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            ASTNode aSTNode = this.getChild(1).getChild(i);
            if (this.getParent().getDomainForId(aSTNode.getChild(0)) != null || symbolTable.hasVariable(aSTNode.getChild(0).toString())) {
                CmdFlags.println("ERROR: In matrix comprehension: " + String.valueOf(this));
                CmdFlags.println("ERROR: Variable `" + String.valueOf(aSTNode.getChild(0)) + "' is already defined.");
                return false;
            }
            for (int j = 0; j < i; ++j) {
                if (!aSTNode.getChild(0).equals(this.getChild(1).getChild(j).getChild(0))) continue;
                CmdFlags.println("ERROR: In matrix comprehension: " + String.valueOf(this));
                CmdFlags.println("ERROR: Variable `" + String.valueOf(aSTNode.getChild(0)) + "' is already defined.");
                return false;
            }
        }
        if (this.getChild(2).getCategory() > 2) {
            System.out.println("ERROR: In matrix comprehension: " + String.valueOf(this));
            System.out.println("ERROR: Decision variable in condition.");
            return false;
        }
        if (!this.getChild(2).isRelation()) {
            System.out.println("ERROR: In matrix comprehension: " + String.valueOf(this));
            System.out.println("ERROR: The condition is not a boolean expression.");
            return false;
        }
        if (this.getChild(3).getCategory() > 2) {
            System.out.println("ERROR: In matrix comprehension: " + String.valueOf(this));
            System.out.println("ERROR: Decision variable in index domain.");
            return false;
        }
        if (!this.getChild(3).isSet()) {
            System.out.println("ERROR: In matrix comprehension: " + String.valueOf(this));
            System.out.println("ERROR: Index domain is not a set.");
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(1).numChildren() == 0 && this.getChild(2).isConstant() && this.getChild(2).getValue() == 1L && this.getChild(3).getCategory() == 0) {
            ArrayList<Intpair> arrayList = this.getChild(3).getIntervalSet();
            IntegerDomain integerDomain = new IntegerDomain(new Range((ASTNode)NumberConstant.make(arrayList.get((int)0).lower), NumberConstant.make(arrayList.get((int)0).lower)));
            ASTNode aSTNode = CompoundMatrix.make((ASTNode)integerDomain, ComprehensionMatrix.list(this.getChild(0)), this.getChild(0).isRelation());
            return aSTNode;
        }
        if (this.getChild(2) instanceof Equals) {
            ASTNode aSTNode = this.getChild(1);
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                Pair<ASTNode, ASTNode> pair = this.checkEquality(this.getChild(2), aSTNode.getChild(i), i);
                if (pair == null) continue;
                ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
                arrayList.remove(i);
                ASTNode aSTNode2 = new ComprehensionMatrix(this.getChild(0), arrayList, pair.getFirst(), this.getChild(3));
                ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode.getChild(i).getChild(0), pair.getSecond());
                aSTNode2 = replaceASTNode.transform(aSTNode2);
                return aSTNode2;
            }
        }
        if (this.getChild(2) instanceof And) {
            for (int i = 0; i < this.getChild(2).numChildren(); ++i) {
                if (!(this.getChild(2).getChild(i) instanceof Equals)) continue;
                ASTNode aSTNode = this.getChild(1);
                for (int j = 0; j < aSTNode.numChildren(); ++j) {
                    Pair<ASTNode, ASTNode> pair = this.checkEquality(this.getChild(2).getChild(i), aSTNode.getChild(j), j);
                    if (pair == null) continue;
                    ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
                    arrayList.remove(j);
                    ArrayList<ASTNode> arrayList2 = this.getChild(2).getChildren();
                    arrayList2.set(i, pair.getFirst());
                    ASTNode aSTNode3 = new ComprehensionMatrix(this.getChild(0), arrayList, (ASTNode)new And(arrayList2), this.getChild(3));
                    ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode.getChild(j).getChild(0), pair.getSecond());
                    aSTNode3 = replaceASTNode.transform(aSTNode3);
                    return aSTNode3;
                }
            }
        }
        if (this.getCategory() <= 2 && this.getChild(1).numChildren() > 0) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            this.getIds(this, arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                ASTNode aSTNode = arrayList.get(i);
                if (aSTNode.getCategory() <= 0) continue;
                boolean bl = false;
                for (int j = 0; j < this.getChild(1).numChildren(); ++j) {
                    if (!this.getChild(1).getChild(j).getChild(0).equals(aSTNode)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return null;
            }
            Model model = this.getChild(1).getChild(0).getChild(0).getModel();
            ASTNode aSTNode = TransformQuantifiedExpression.allUnrollComprehension(this, model);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(model);
            aSTNode = transformQuantifiedExpression.transform(aSTNode);
            TransformSimplify transformSimplify = new TransformSimplify();
            aSTNode = transformSimplify.transform(aSTNode);
            ASTNode aSTNode4 = model.cmstore.newConstantMatrixDedup(aSTNode);
            return aSTNode4;
        }
        return null;
    }

    private void getIds(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        if (aSTNode instanceof Identifier) {
            arrayList.add(aSTNode);
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.getIds(aSTNode.getChild(i), arrayList);
            }
        }
    }

    private Pair<ASTNode, ASTNode> checkEquality(ASTNode aSTNode, ASTNode aSTNode2, int n) {
        Pair<ASTNode, ASTNode> pair = this.checkEquality(aSTNode.getChild(0), aSTNode.getChild(1), aSTNode2, n);
        if (pair != null) {
            return pair;
        }
        return this.checkEquality(aSTNode.getChild(1), aSTNode.getChild(0), aSTNode2, n);
    }

    private Pair<ASTNode, ASTNode> checkEquality(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, int n) {
        ASTNode aSTNode4 = aSTNode3.getChild(0);
        if (aSTNode.equals(aSTNode4)) {
            if (aSTNode2.isConstant()) {
                return new Pair<ASTNode, ASTNode>(new InSet(aSTNode2, aSTNode3.getChild(1)), aSTNode2);
            }
            if (aSTNode2 instanceof Identifier) {
                for (int i = n + 1; i < this.getChild(1).numChildren(); ++i) {
                    if (!this.getChild(1).getChild(i).getChild(0).equals(aSTNode2)) continue;
                    return null;
                }
                return new Pair<ASTNode, ASTNode>(new InSet(aSTNode2, aSTNode3.getChild(1)), aSTNode2);
            }
        }
        return null;
    }

    @Override
    public ASTNode getDomainForId(ASTNode aSTNode) {
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            ASTNode aSTNode2 = this.getChild(1).getChild(i);
            if (!aSTNode2.getChild(0).equals(aSTNode)) continue;
            return aSTNode2.getChild(1);
        }
        return this.getParent().getDomainForId(aSTNode);
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.getChild(0));
        stringBuilder.append("|");
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            stringBuilder.append(this.getChild(1).getChild(i).toString());
            stringBuilder.append(", ");
        }
        stringBuilder.append(this.getChild(2));
        stringBuilder.append(" ;");
        stringBuilder.append(this.getChild(3));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

