/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.Solution;
import savilerow.model.Model;
import savilerow.solver.AllMinisatStats;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;
import savilerow.solver.SATSolver;
import savilerow.solver.Stats;

public class AllMinisatSATSolver
extends SATSolver {
    public AllMinisatSATSolver(Model model) {
        super(model);
    }

    @Override
    public void findOneSolution(String string, String string2, Model model) {
        CmdFlags.warning("This solver works on all solutions mode only");
        this.findSolutionsByCommand(string, string2, model);
    }

    @Override
    public void findMultipleSolutions(String string, String string2, Model model) {
        this.findSolutionsByCommand(string, string2, model);
    }

    private void findSolutionsByCommand(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        CmdFlags.runningSolver = true;
        Stats stats = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(CmdFlags.getMinionSolsTempFile());
            arrayList.addAll(CmdFlags.getSolverExtraFlags());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList3);
            double d2 = System.currentTimeMillis();
            int n = RunCommand.runCommand(false, arrayList, arrayList2, readProcessOutput);
            d2 = ((double)System.currentTimeMillis() - d2) / 1000.0;
            CmdFlags.startTime = System.currentTimeMillis();
            AllMinisatStats allMinisatStats = new AllMinisatStats(arrayList3);
            if (n == 0) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
                while (bufferedReader.ready()) {
                    String string3 = bufferedReader.readLine();
                    ArrayList<String> arrayList4 = new ArrayList<String>(Arrays.asList(string3.split(" ")));
                    Solution solution = this.solverSolToAST(arrayList4, model.global_symbols);
                    this.createSolutionFile(solution, true);
                }
                allMinisatStats.setNontrivialStats(this.solutionCounter);
            } else if (n == 20) {
                allMinisatStats.setTrivialStats();
            } else if (arrayList2.size() != 0 || n != 0 && n != 20) {
                CmdFlags.println("SAT solver exited with error code:" + n + " and message:");
                CmdFlags.println(arrayList2);
            }
            stats = stats == null ? allMinisatStats : stats.add(allMinisatStats);
            d += ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
            CmdFlags.startTime = System.currentTimeMillis();
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
            CmdFlags.rmTempFiles();
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
        }
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        return null;
    }
}

