package savilerow.expression;
/*

    Savile Row http://savilerow.cs.st-andrews.ac.uk/
    Copyright (C) 2014-2024 Peter Nightingale
    
    This file is part of Savile Row.
    
    Savile Row is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Savile Row is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Savile Row.  If not, see <http://www.gnu.org/licenses/>.

*/


import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import savilerow.*;
import savilerow.model.*;

// Two arrays, each representing the inverse mapping of the other. 

public class Inverse extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    public Inverse(ASTNode a, ASTNode b) {
        super(a,b);
    }

    public ASTNode copy() {
        return new Inverse(getChild(0), getChild(1));
    }

    public boolean isRelation() { return true; }

    public boolean typecheck(SymbolTable st) {
        for(int i=0; i<numChildren(); i++) {
            if (!getChild(i).typecheck(st)) {
                return false;
            }
        }
        
        if (getChild(0).getDimension() != 1 || getChild(1).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in inverse constraint: " + this);
            return false;
        }
        return true;
    }
    
    /*public ASTNode simplify() {
        ASTNode mat=getChildConst(0);
        
        if((mat instanceof CompoundMatrix || mat instanceof EmptyMatrix) && getChild(0).getCategory()==ASTNode.Constant) {
            if(mat instanceof EmptyMatrix) {
                return new BooleanConstant(true);
            }
            
            // check there are no sub-cycles. 
            ArrayList<Long> seq=new ArrayList<>();
            
            ArrayList<Intpair> idx=mat.getChild(0).getIntervalSet();
            long lb=idx.get(0).lower;
            
            long cur=lb;
            seq.add(cur);  //  start at the smallest index. 
            
            while(true) {
                cur=mat.getChild((int)(cur-lb+1)).getValue();
                if(seq.contains(cur)) {
                    break;
                }
                seq.add(cur);
            }
            
            return new BooleanConstant(seq.size() == mat.numChildren()-1);
        }
        return null;
    }*/
    
    public String toString() {
        return generic_to_string("inverse");
    }
    
    //  Choco  fzn_inverse(f, min(index_set(invf)), invf, min(index_set(f)));
    //  Gecode inverse_offsets(f, min(index_set(invf)), invf, min(index_set(f)));
    //  Chuffed  inverse_offsets(f, min(index_set(invf)), invf, min(index_set(f)));
    //  CPSAT  ortools_inverse(f, invf, min(index_set(f)), min(index_set(invf)));
    
    public void toFlatzinc(BufferedWriter b, boolean bool_context) throws IOException {
        long lb0=getChild(0).getChild(0).getBounds().lower;
        long lb1=getChild(1).getChild(0).getBounds().lower;
        
        if(CmdFlags.getOrtoolstrans()) {
            b.append("constraint ortools_inverse(");
            getChild(0).toFlatzinc(b, false);
            b.append(",");
            getChild(1).toFlatzinc(b, false);
            b.append(",");
            b.append(String.valueOf(lb0));
            b.append(",");
            b.append(String.valueOf(lb1));
            b.append(");");
        }
        else {
            if(CmdFlags.getChocotrans()) {
                b.append("constraint fzn_inverse(");
            }
            else {
                //  Gecode or Chuffed
                b.append("constraint inverse_offsets(");
            }
            getChild(0).toFlatzinc(b, false);
            b.append(",");
            b.append(String.valueOf(lb1));
            b.append(",");
            getChild(1).toFlatzinc(b, false);
            b.append(",");
            b.append(String.valueOf(lb0));
            b.append(");");
        }
    }
    
    public void toMinizinc(StringBuilder b, boolean bool_context) {
        b.append("inverse(");
        getChild(0).toMinizinc(b, false);  //  Check this includes the index domain.
        b.append(",");
        getChild(1).toMinizinc(b, false);
        b.append(")");
    }
    
    ////////////////////////////////////////////////////////////////////////////
    //  JSON output for symmetry detection
    
    /*public void toJSON(StringBuilder bf) {
        toJSONHeader(bf, true);
        // children
        bf.append("\"Children\": [");
        if(getChild(0) instanceof CompoundMatrix && getChild(0).numChildren()==3) {
            //   Special case for binary != constraint.
            getChild(0).getChild(1).toJSON(bf);
            bf.append(", ");
            getChild(0).getChild(2).toJSON(bf);
        }
        else {
            // Same as toJSON method in ASTNode.
            for (int i = 0; i < numChildren(); i++) {
                bf.append("\n");
                getChild(i).toJSON(bf);
                // not last child
                if (i < numChildren() - 1) {
                    bf.append(",");
                }
            }
        }
        bf.append("]\n}");
    }
    
    public boolean childrenAreSymmetric() {
        return (getChild(0) instanceof CompoundMatrix && getChild(0).numChildren()==3);
    }
    
    public boolean isChildSymmetric(int childIndex) {
        // If not a binary != ct, then the matrix inside should be regarded as symmetric.
        return !(getChild(0) instanceof CompoundMatrix && getChild(0).numChildren()==3);
    }

    public boolean canChildBeConvertedToDifference(int childIndex) {
        return isMyOnlyOtherSiblingEqualZero(childIndex);
    }*/

}
