/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Intpair;
import savilerow.expression.Min;
import savilerow.expression.NegInfinity;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;
import savilerow.model.SymbolTable;

public class MinVector
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public MinVector(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new MinVector(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in min function: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) {
            if (aSTNode instanceof EmptyMatrix) {
                return NumberConstant.make(0L);
            }
            ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
            if (aSTNode == this.getChild(0)) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.get(i).setParent(null);
                }
            }
            return new Min(arrayList);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PairASTNode getBoundsAST() {
        return new PairASTNode(new NegInfinity(), new PosInfinity());
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public String toString() {
        return "min(" + String.valueOf(this.getChild(0)) + ")";
    }
}

