/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.MDDUtils;
import savilerow.TabulationUtils;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomainFull;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.CompoundMatrixByte1D;
import savilerow.expression.CompoundMatrixInt1D;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.Identifier;
import savilerow.expression.InSet;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NegativeTable;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;
import savilerow.expression.SATLiteral;
import savilerow.expression.ToSet;
import savilerow.model.ConstantMatrixStore;
import savilerow.model.Model;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Table
extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    protected transient Model m;
    HashSet<Intpair> satisfyingTuples;

    public Table(Model model, ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
        this.m = model;
    }

    @Override
    public boolean hasModel() {
        return true;
    }

    @Override
    public Model getModel() {
        return this.m;
    }

    @Override
    public void setModel(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode copy() {
        return new Table(this.m, this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(1).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: First argument of table should be 1-dimensional matrix: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(1).getDimension() != 2) {
            CmdFlags.println("ERROR: Second argument of table should be 2-dimensional matrix: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(1).getCategory() >= 3) {
            CmdFlags.println("ERROR: Second argument of table cannot contain decision variables: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if ((aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) && this.getChild(1).getCategory() == 0) {
            ASTNode aSTNode2 = this.getChildConst(1);
            if (aSTNode2 == this.getChild(1) && (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                ASTNode aSTNode3 = this.m.cmstore.newConstantMatrixDedup(aSTNode2);
                this.getChild(0).setParent(null);
                return new Table(this.m, this.getChild(0), aSTNode3);
            }
            if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
                if (aSTNode2 instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                if (aSTNode instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                if (aSTNode.numChildren() == 2) {
                    if (aSTNode == this.getChild(0)) {
                        aSTNode.getChild(1).setParent(null);
                    }
                    ArrayList<Long> arrayList = ConstantMatrixStore.getConstantMatrixContents(aSTNode2);
                    ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        arrayList2.add(NumberConstant.make(arrayList.get(i)));
                    }
                    return new InSet(aSTNode.getChild(1), new ToSet(new CompoundMatrix(arrayList2)));
                }
                boolean bl = false;
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    if (!aSTNode.getChild(i).isConstant()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
                    ArrayList<ASTNode> arrayList3 = aSTNode2.getChildren(1);
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        if (!arrayList.get(i).isConstant()) continue;
                        long l = arrayList.get(i).getValue();
                        arrayList.remove(i);
                        ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
                        for (int j = 0; j < arrayList3.size(); ++j) {
                            Object[] objectArray;
                            Object object;
                            ASTNode aSTNode4 = arrayList3.get(j);
                            if (aSTNode4 instanceof CompoundMatrix) {
                                if (aSTNode4.getChild(i + 1).getValue() != l) continue;
                                object = arrayList3.get(j).getChildren(1);
                                object.remove(i);
                                arrayList4.add(CompoundMatrix.make((ArrayList<ASTNode>)object));
                                continue;
                            }
                            if (aSTNode4 instanceof CompoundMatrixByte1D) {
                                object = ((CompoundMatrixByte1D)aSTNode4).values;
                                if ((long)object[i] != l) continue;
                                objectArray = new byte[((byte[])object).length - 1];
                                for (int k = 0; k < objectArray.length; ++k) {
                                    objectArray[k] = (byte)object[k < i ? k : k + 1];
                                }
                                if (objectArray.length == 0) {
                                    ArrayList<ASTNode> arrayList5 = new ArrayList<ASTNode>();
                                    arrayList5.add(new IntegerDomain(new EmptyRange()));
                                    arrayList4.add(new EmptyMatrix(new MatrixDomain((ASTNode)new IntegerDomain(new EmptyRange()), arrayList5)));
                                    continue;
                                }
                                arrayList4.add(new CompoundMatrixByte1D((byte[])objectArray));
                                continue;
                            }
                            object = ((CompoundMatrixInt1D)aSTNode4).values;
                            if ((long)object[i] != l) continue;
                            objectArray = new int[((byte[])object).length - 1];
                            for (int k = 0; k < objectArray.length; ++k) {
                                objectArray[k] = (byte)object[k < i ? k : k + 1];
                            }
                            if (objectArray.length == 0) {
                                ArrayList<ASTNode> arrayList6 = new ArrayList<ASTNode>();
                                arrayList6.add(new IntegerDomain(new EmptyRange()));
                                arrayList4.add(new EmptyMatrix(new MatrixDomain((ASTNode)new IntegerDomain(new EmptyRange()), arrayList6)));
                                continue;
                            }
                            arrayList4.add(new CompoundMatrixInt1D((int[])objectArray));
                        }
                        arrayList3 = arrayList4;
                    }
                    ASTNode aSTNode5 = CompoundMatrix.make(arrayList3);
                    aSTNode5 = this.m.cmstore.newConstantMatrixDedup(aSTNode5);
                    if (aSTNode == this.getChild(0)) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            arrayList.get(i).setParent(null);
                        }
                    }
                    return new Table(this.m, CompoundMatrix.make(arrayList), aSTNode5);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new NegativeTable(this.m, this.getChild(0), this.getChild(1));
    }

    public void propagate() {
        int n;
        ASTNode aSTNode;
        TabulationUtils tabulationUtils = new TabulationUtils(this.m);
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren(1);
        ArrayList<ArrayList<Intpair>> arrayList2 = tabulationUtils.getDomainsConcrete(arrayList);
        int n2 = arrayList.size();
        ArrayList<ASTNode> arrayList3 = this.getChildConst(1).getChildren(1);
        boolean bl = false;
        block0: for (int i = 0; i < arrayList3.size(); ++i) {
            aSTNode = arrayList3.get(i);
            assert (aSTNode.isTuple());
            for (int j = 1; j <= n2; ++j) {
                if (Intpair.contains(arrayList2.get(j - 1), aSTNode.getValueIdx(j))) continue;
                arrayList3.set(i, null);
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>(arrayList3.size());
            for (int i = 0; i < arrayList3.size(); ++i) {
                if (arrayList3.get(i) == null) continue;
                arrayList4.add(arrayList3.get(i));
            }
            arrayList3 = arrayList4;
            aSTNode = CompoundMatrix.make(arrayList3);
            ASTNode aSTNode2 = this.m.cmstore.newConstantMatrixDedup(aSTNode);
            this.setChild(1, aSTNode2);
        }
        ArrayList arrayList5 = new ArrayList();
        for (n = 0; n < n2; ++n) {
            arrayList5.add(new ArrayList());
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            ASTNode aSTNode3 = arrayList3.get(n);
            for (int i = 1; i <= n2; ++i) {
                long l = aSTNode3.getValueIdx(i);
                ((ArrayList)arrayList5.get(i - 1)).add(new Intpair(l, l));
            }
        }
        for (n = 0; n < n2; ++n) {
            Intpair.normalise((ArrayList)arrayList5.get(n));
            arrayList5.set(n, Intpair.intersection((ArrayList)arrayList5.get(n), arrayList2.get(n)));
        }
        for (n = 0; n < n2; ++n) {
            this.m.global_symbols.setDomain(arrayList.get(n).toString(), Intpair.makeDomain((ArrayList)arrayList5.get(n), arrayList.get(n).isRelation()));
        }
    }

    @Override
    public String toString() {
        return this.generic_to_string("table");
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getChild(0).numChildren() <= 3) {
            bufferedWriter.append("table(");
        } else {
            bufferedWriter.append("table(");
        }
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            bufferedWriter.append("{");
            for (int i = 1; i < this.getChild(1).numChildren(); ++i) {
                ASTNode aSTNode = this.getChild(1).getChild(i);
                bufferedWriter.append("<");
                for (int j = 1; j <= aSTNode.getTupleLength(); ++j) {
                    bufferedWriter.append(String.valueOf(aSTNode.getValueIdx(j)));
                    if (j >= aSTNode.getTupleLength()) continue;
                    bufferedWriter.append(", ");
                }
                bufferedWriter.append(">");
                if (i >= this.getChild(1).numChildren() - 1) continue;
                bufferedWriter.append(", ");
            }
            bufferedWriter.append("}");
        } else {
            this.getChild(1).toMinion(bufferedWriter, false);
        }
        bufferedWriter.append(")");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (CmdFlags.getGecodetrans()) {
            bufferedWriter.append("constraint gecode_table_int(");
        } else if (CmdFlags.getOrtoolstrans()) {
            bufferedWriter.append("constraint ortools_table_int(");
        } else if (CmdFlags.getChuffedtrans()) {
            bufferedWriter.append("constraint chuffed_table_int(");
        } else if (CmdFlags.getChocotrans()) {
            bufferedWriter.append("constraint choco_fzn_table(");
        } else {
            bufferedWriter.append("constraint table_int(");
        }
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",[");
        ASTNode aSTNode = this.getChildConst(1);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            ASTNode aSTNode2 = aSTNode.getChild(i);
            for (int j = 1; j <= aSTNode2.getTupleLength(); ++j) {
                bufferedWriter.append(String.valueOf(aSTNode2.getValueIdx(j)));
                if (i >= aSTNode.numChildren() - 1 && j >= aSTNode2.getTupleLength()) continue;
                bufferedWriter.append(",");
            }
        }
        bufferedWriter.append("]);");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("table(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            ConstantMatrixStore.printMzn2darray(stringBuilder, this.getChild(1));
        } else {
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        stringBuilder.append(")");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        this.toSATHelper2(sat);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.toSATHelper(sat, l, true);
    }

    public void toSATHelper(Sat sat, long l, boolean bl) throws IOException {
        ASTNode aSTNode = this.getChildConst(1);
        ArrayList<Long> arrayList = new ArrayList<Long>(aSTNode.numChildren());
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            ASTNode aSTNode2 = aSTNode.getChild(i);
            long l2 = sat.createAuxSATVariable();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int j = 1; j <= aSTNode2.getTupleLength(); ++j) {
                long l3 = aSTNode2.getValueIdx(j);
                long l4 = this.getChild(0).getChild(j).directEncode(sat, l3);
                sat.addClause(-l2, l4);
                arrayList2.add(-l4);
            }
            arrayList2.add(l2);
            sat.addClause(arrayList2);
            arrayList.add(l2);
        }
        if (bl) {
            sat.addClauseReified(arrayList, l);
        } else {
            sat.addClause(arrayList);
        }
    }

    public void toSATHelper2(Sat sat) throws IOException {
        ASTNode aSTNode = this.getChildConst(1);
        ArrayList<ASTNode> arrayList = aSTNode.getChildren(1);
        if (this.getChild(0).numChildren() == 3) {
            this.satisfyingTuples = new HashSet();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.satisfyingTuples.add(new Intpair(arrayList.get(i).getValueIdx(1), arrayList.get(i).getValueIdx(2)));
            }
            sat.supportEncodingBinary(this, this.getChild(0).getChild(1), this.getChild(0).getChild(2));
            this.satisfyingTuples = null;
            return;
        }
        if (CmdFlags.sat_table_mdd) {
            MDDUtils.MDDEncode(this.getChild(0).getChildren(1), this.getChildConst(1).getChildren(1), sat);
        } else {
            int n;
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 1; i < this.getChild(0).numChildren(); ++i) {
                ASTNode aSTNode2 = this.getChild(0).getChild(i);
                if (aSTNode2 instanceof Identifier) {
                    arrayList2.add(((Identifier)aSTNode2).getDomain());
                    continue;
                }
                if (aSTNode2.isConstant()) {
                    arrayList2.add(new IntegerDomain(new Range(aSTNode2, aSTNode2)));
                    continue;
                }
                if (aSTNode2 instanceof SATLiteral) {
                    arrayList2.add(new BooleanDomainFull());
                    continue;
                }
                assert (false) : "Unknown type contained in table constraint:" + String.valueOf(aSTNode2);
            }
            ArrayList<Long> arrayList3 = new ArrayList<Long>(arrayList.size());
            for (n = 0; n < arrayList.size(); ++n) {
                boolean bl = true;
                for (int i = 1; i < this.getChild(0).numChildren(); ++i) {
                    if (((ASTNode)arrayList2.get(i - 1)).containsValue(arrayList.get(n).getValueIdx(i))) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    arrayList.set(n, arrayList.get(arrayList.size() - 1));
                    arrayList.remove(arrayList.size() - 1);
                    --n;
                    continue;
                }
                arrayList3.add(sat.createAuxSATVariable());
            }
            for (n = 1; n < this.getChild(0).numChildren(); ++n) {
                ASTNode aSTNode3 = this.getChild(0).getChild(n);
                ArrayList<Intpair> arrayList4 = ((ASTNode)arrayList2.get(n - 1)).getIntervalSet();
                long l = Intpair.numValues(arrayList4);
                ArrayList arrayList5 = new ArrayList((int)l);
                int n2 = 0;
                while ((long)n2 < l) {
                    arrayList5.add(new ArrayList());
                    ++n2;
                }
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    long l2 = arrayList.get(n2).getValueIdx(n);
                    int n3 = -1;
                    int n4 = 0;
                    for (int i = 0; i < arrayList4.size(); ++i) {
                        Intpair intpair = arrayList4.get(i);
                        if (l2 >= intpair.lower && l2 <= intpair.upper) {
                            n3 = (int)(l2 - intpair.lower + (long)n4);
                            break;
                        }
                        n4 = (int)((long)n4 + (intpair.upper - intpair.lower + 1L));
                    }
                    if (n3 == -1) {
                        assert (false) : "Should be no invalid tuples";
                        sat.addClause(-arrayList3.get(n2).longValue());
                        continue;
                    }
                    ((ArrayList)arrayList5.get(n3)).add(arrayList3.get(n2));
                }
                n2 = 0;
                for (int i = 0; i < arrayList4.size(); ++i) {
                    for (long j = arrayList4.get((int)i).lower; j <= arrayList4.get((int)i).upper; ++j) {
                        sat.addClauseReified((ArrayList)arrayList5.get(n2), aSTNode3.directEncode(sat, j));
                        ++n2;
                    }
                }
            }
            sat.addClause(arrayList3);
        }
    }

    @Override
    public boolean test(long l, long l2) {
        return this.satisfyingTuples.contains(new Intpair(l, l2));
    }
}

