/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Container;
import savilerow.expression.EmptyMatrix;
import savilerow.model.SymbolTable;
import savilerow.treetransformer.TransformDecomposeDisjunctive;

public class Disjunctive
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Disjunctive(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Disjunctive(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 2; ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in first argument of cumulative: " + String.valueOf(this));
            return false;
        }
        if (this.getChild(1).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in second argument of cumulative: " + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        ASTNode aSTNode2 = this.getChildConst(1);
        if (!(aSTNode instanceof CompoundMatrix)) {
            if (aSTNode instanceof EmptyMatrix) {
                return new BooleanConstant(true);
            }
            return null;
        }
        if (aSTNode.getCategory() == 0 && aSTNode2.getCategory() == 0) {
            return TransformDecomposeDisjunctive.taskDecomp(aSTNode, aSTNode2);
        }
        return null;
    }

    @Override
    public ASTNode normalise() {
        int n;
        if (!(this.getChild(0) instanceof CompoundMatrix) || !(this.getChild(1) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (n = 1; n < this.getChild(0).numChildren(); ++n) {
            arrayList.add(new Container(this.getChild(0).getChild(n), this.getChild(1).getChild(n)));
        }
        n = Disjunctive.sortByHashcode(arrayList) ? 1 : 0;
        if (n != 0) {
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(arrayList.get(i).getChild(0));
                arrayList3.add(arrayList.get(i).getChild(1));
            }
            return new Disjunctive(CompoundMatrix.make(arrayList2), CompoundMatrix.make(arrayList3));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        int n;
        if (!(this.getChild(0) instanceof CompoundMatrix) || !(this.getChild(1) instanceof CompoundMatrix)) {
            return null;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (n = 1; n < this.getChild(0).numChildren(); ++n) {
            arrayList.add(new Container(this.getChild(0).getChild(n), this.getChild(1).getChild(n)));
        }
        n = Disjunctive.sortByAlpha(arrayList) ? 1 : 0;
        if (n != 0) {
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(arrayList.get(i).getChild(0));
                arrayList3.add(arrayList.get(i).getChild(1));
            }
            return new Disjunctive(CompoundMatrix.make(arrayList2), CompoundMatrix.make(arrayList3));
        }
        return null;
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint fzn_disjunctive(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("disjunctive(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return this.generic_to_string("disjunctive");
    }
}

