/*
 * Decompiled with CFR 0.152.
 */
package savilerow.mdd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import savilerow.mdd.MDD;
import savilerow.mdd.MDDBuilder;
import savilerow.mdd.R_M;

public class AMOPBMDDBuilder
extends MDDBuilder {
    public static final long serialVersionUID = 1L;
    ArrayList<ArrayList<MDD>> L_MDDs;
    ArrayList<ArrayList<R_M>> L;
    int K;
    ArrayList<ArrayList<Integer>> Q;
    ArrayList<ArrayList<Long>> X;

    public AMOPBMDDBuilder(ArrayList<ArrayList<Integer>> arrayList, ArrayList<ArrayList<Long>> arrayList2, int n, boolean bl) {
        int n2;
        this.Q = arrayList;
        this.X = arrayList2;
        this.K = n;
        this.longedges = bl;
        for (n2 = 0; n2 < this.Q.size(); ++n2) {
            AMOPBMDDBuilder.sortCoefsDecreasing(this.Q.get(n2), this.X.get(n2));
        }
        this.depth = this.Q.size() + 1;
        this.initL();
        this.L_MDDs = new ArrayList(this.Q.size());
        for (n2 = 0; n2 < this.Q.size(); ++n2) {
            this.L_MDDs.add(new ArrayList());
        }
    }

    public static void sortCoefsDecreasing(ArrayList<Integer> arrayList, ArrayList<Long> arrayList2) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < n - (i + 1); ++j) {
                if (arrayList.get(j) >= arrayList.get(j + 1)) continue;
                Integer n2 = arrayList.get(j + 1);
                arrayList.set(j + 1, arrayList.get(j));
                arrayList.set(j, n2);
                Long l = arrayList2.get(j + 1);
                arrayList2.set(j + 1, arrayList2.get(j));
                arrayList2.set(j, l);
                bl = true;
            }
            if (!bl) break;
        }
    }

    @Override
    public void buildMDD() {
        this.root = this.MDDConstruction((int)0, (int)this.K).mdd;
    }

    private int inf_sum(int n, int n2) {
        if (n == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (n == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return n + n2;
    }

    private void insertMDD(R_M r_M, int n) {
        R_M r_M2;
        ArrayList<R_M> arrayList = this.L.get(n);
        if (arrayList.isEmpty()) {
            arrayList.add(r_M);
            return;
        }
        int n2 = arrayList.size();
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 - 1;
        n3 = (n5 - n4) / 2;
        while (n4 < n5) {
            r_M2 = arrayList.get(n3);
            if (r_M2.B > r_M.Y) {
                n5 = n3 - 1;
            } else {
                n4 = n3 + 1;
            }
            n3 = n4 + (n5 - n4) / 2;
        }
        r_M2 = arrayList.get(n3);
        if (r_M2.B <= r_M.Y) {
            ++n3;
        }
        this.L.get(n).add(n3, r_M);
    }

    private R_M searchMDD(int n, int n2) {
        ArrayList<R_M> arrayList = this.L.get(n2);
        R_M r_M = new R_M();
        R_M r_M2 = new R_M();
        r_M.mdd = null;
        int n3 = arrayList.size();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (n3 > 0) {
            n6 = n3 - 1;
            n4 = (n6 - n5) / 2;
            while (n5 <= n6 && !bl) {
                r_M2 = arrayList.get(n4);
                if (n >= r_M2.B && n <= r_M2.Y) {
                    r_M = r_M2;
                    bl = true;
                } else if (r_M2.B > n) {
                    n6 = n4 - 1;
                } else {
                    n5 = n4 + 1;
                }
                n4 = n5 + (n6 - n5) / 2;
            }
        }
        return r_M;
    }

    private R_M MDDConstruction(int n, int n2) {
        MDD mDD = null;
        R_M r_M = this.searchMDD(n2, n);
        if (r_M.mdd == null) {
            int n3;
            ArrayList<R_M> arrayList = new ArrayList<R_M>();
            ArrayList<MDD> arrayList2 = new ArrayList<MDD>();
            int n4 = Integer.MIN_VALUE;
            int n5 = Integer.MAX_VALUE;
            boolean bl = true;
            MDD mDD2 = null;
            for (int i = 0; i < this.Q.get(n).size(); ++i) {
                n3 = this.Q.get(n).get(i);
                R_M r_M2 = this.MDDConstruction(n + 1, n2 - n3);
                arrayList.add(r_M2);
                arrayList2.add(r_M2.mdd);
                if (mDD2 == null) {
                    mDD2 = r_M2.mdd;
                } else {
                    boolean bl2 = bl = bl && mDD2 == r_M2.mdd;
                }
                if (this.inf_sum(r_M2.B, n3) > n4) {
                    n4 = this.inf_sum(r_M2.B, n3);
                }
                if (this.inf_sum(r_M2.Y, n3) >= n5) continue;
                n5 = this.inf_sum(r_M2.Y, n3);
            }
            R_M r_M3 = this.MDDConstruction(n + 1, n2);
            arrayList.add(r_M3);
            arrayList2.add(r_M3.mdd);
            boolean bl3 = bl = bl && mDD2 == r_M3.mdd;
            if (r_M3.B > n4) {
                n4 = r_M3.B;
            }
            if (r_M3.Y < n5) {
                n5 = r_M3.Y;
            }
            int n6 = n3 = this.longedges && bl ? 1 : 0;
            if (n3 != 0) {
                r_M = new R_M();
                r_M.mdd = (MDD)arrayList2.get(0);
                r_M.B = n4;
                r_M.Y = ((R_M)arrayList.get((int)0)).Y;
            } else {
                mDD = new MDD(this.nodeCount++, this.X.size() - n);
                for (int i = 0; i < arrayList2.size() - 1; ++i) {
                    mDD.addChild(this.X.get(n).get(i), (MDD)arrayList2.get(i));
                }
                mDD.setElseChild((MDD)arrayList2.get(arrayList2.size() - 1));
                this.L_MDDs.get(n).add(mDD);
                r_M = new R_M(mDD, n4, n5);
                this.insertMDD(r_M, n);
            }
        }
        return r_M;
    }

    private void initL() {
        R_M r_M;
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.depth);
        for (n2 = 0; n2 < this.depth; ++n2) {
            arrayList.add(0);
        }
        this.L = new ArrayList(this.depth);
        for (n2 = 0; n2 < this.depth; ++n2) {
            this.L.add(new ArrayList());
        }
        arrayList.set(this.depth - 1, 0);
        for (n = this.depth - 2; n >= 0; --n) {
            arrayList.set(n, (Integer)arrayList.get(n + 1) + (Integer)Collections.max((Collection)this.Q.get(n)));
        }
        R_M r_M2 = new R_M();
        r_M2.mdd = MDD.MDDFalse();
        r_M2.B = Integer.MIN_VALUE;
        r_M2.Y = -1;
        if (this.longedges) {
            for (n = 0; n < this.depth - 1; ++n) {
                this.L.get(n).add(r_M2);
                r_M = new R_M();
                r_M.mdd = MDD.MDDTrue();
                r_M.B = (Integer)arrayList.get(n);
                r_M.Y = Integer.MAX_VALUE;
                this.L.get(n).add(r_M);
            }
        }
        r_M = new R_M();
        r_M.mdd = MDD.MDDTrue();
        r_M.B = 0;
        r_M.Y = Integer.MAX_VALUE;
        this.L.get(this.depth - 1).add(r_M2);
        this.L.get(this.depth - 1).add(r_M);
    }
}

