/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.model.InteractiveSMT;
import savilerow.model.Model;
import savilerow.solver.InteractiveRunCommand;
import savilerow.solver.SMTSolver;
import savilerow.solver.Stats;

public abstract class InteractiveSMTSolver
extends SMTSolver {
    InteractiveRunCommand irc;
    public BufferedWriter outputStream;

    public InteractiveSMTSolver(Model model) {
        super(model);
        this.irc = new InteractiveRunCommand(model, this.getCommand(CmdFlags.getSMTSolverPath(), null));
        this.outputStream = this.irc.output;
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        long l = System.nanoTime();
        int n = this.irc.processCurrentModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = this.irc.stdout_lines;
        l = System.nanoTime() - l;
        Stats stats2 = new Stats();
        this.detectErrors(n, arrayList2, arrayList, stats2);
        if (!CmdFlags.usingBoolector() && arrayList2.size() > 0) {
            int n2 = 0;
            while (!arrayList2.get(n2).contains(")") || !arrayList2.get(n2).contains("(")) {
                ++n2;
            }
            List<String> list = arrayList2.subList(0, n2);
            arrayList2 = new ArrayList<String>(arrayList2.subList(n2, arrayList2.size()));
            this.updateStats(stats2, list);
        }
        arrayList2.add(0, n == 10 ? "sat" : "unsat");
        if (stats2.getValue("SolverTotalTime").equals("NA") || CmdFlags.usingYices2()) {
            double d = (double)l / 1.0E9;
            stats2.putValue("SolverTotalTime", String.valueOf(d));
        }
        if (model.objective != null) {
            this.cleanActiveAssumptions();
        }
        return new Pair<ArrayList<String>, Stats>(this.handleOutput(arrayList2, stats2), stats2);
    }

    @Override
    protected ArrayList<String> getCommand(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        ArrayList<String> arrayList2 = new ArrayList<String>(CmdFlags.getSolverExtraFlags());
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    public void cleanActiveAssumptions() {
        ((InteractiveSMT)this.m.satModel).activeAssumptions.clear();
    }

    @Override
    public void findOneSolution(String string, String string2, Model model) {
        super.findOneSolution(string, string2, model);
        this.cleanActiveAssumptions();
    }

    @Override
    public void findMultipleSolutions(String string, String string2, Model model) {
        super.findMultipleSolutions(string, string2, model);
        this.cleanActiveAssumptions();
    }
}

