/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomainFull;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.DominanceRelation;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDomain;
import savilerow.expression.Negate;
import savilerow.expression.NoValue;
import savilerow.expression.NumberConstant;
import savilerow.expression.Solution;
import savilerow.expression.Top;
import savilerow.model.Model;
import savilerow.model.SymbolTable;
import savilerow.model.categoryentry;
import savilerow.treetransformer.SubstituteAllValues;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformer;

public abstract class Solver {
    long solutionCounter = 0L;
    int numdigits = 6;

    public abstract void findSolutions(String var1, String var2, Model var3) throws IOException, InterruptedException;

    public void parseSolutionMode() {
        SymbolTable symbolTable;
        Object object;
        Closeable closeable;
        try {
            closeable = new FileInputStream(CmdFlags.auxfile);
            object = new ObjectInputStream((InputStream)closeable);
            symbolTable = (SymbolTable)((ObjectInputStream)object).readObject();
            symbolTable.unmangle_after_serialization();
            ((ObjectInputStream)object).close();
            closeable.close();
        }
        catch (Exception exception) {
            CmdFlags.println(String.valueOf(exception));
            symbolTable = null;
        }
        if (symbolTable == null) {
            CmdFlags.errorExit("Failed to read serialisation file " + CmdFlags.auxfile);
        }
        if (!CmdFlags.getFindAllSolutions() && CmdFlags.getFindNumSolutions() == 1L) {
            try {
                closeable = new BufferedReader(new FileReader(CmdFlags.minionsolfile));
                object = this.parseLastSolverSolution(symbolTable, (BufferedReader)closeable);
                this.createSolutionFile((ASTNode)object, false);
            }
            catch (IOException iOException) {
                System.out.println("Could not open or parse Minion solution file. " + String.valueOf(iOException));
            }
        } else {
            try {
                closeable = new BufferedReader(new FileReader(CmdFlags.minionsolfile));
                this.parseAllSolverSolutions(symbolTable, (BufferedReader)closeable);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Could not open or parse Minion solution file. " + String.valueOf(fileNotFoundException));
            }
        }
    }

    public void parseDomainStore() {
        SymbolTable symbolTable;
        Object object;
        Closeable closeable;
        try {
            closeable = new FileInputStream(CmdFlags.auxfile);
            object = new ObjectInputStream((InputStream)closeable);
            symbolTable = (SymbolTable)((ObjectInputStream)object).readObject();
            symbolTable.unmangle_after_serialization();
            ((ObjectInputStream)object).close();
            ((FileInputStream)closeable).close();
        }
        catch (Exception exception) {
            CmdFlags.println(String.valueOf(exception));
            symbolTable = null;
        }
        if (symbolTable == null) {
            CmdFlags.errorExit("Failed to read serialisation file " + CmdFlags.auxfile);
        }
        try {
            Object object2;
            Object object3;
            Serializable serializable;
            Object object4;
            Object object5;
            closeable = new BufferedReader(new FileReader(CmdFlags.minionsolfile));
            object = ((BufferedReader)closeable).readLine();
            HashMap<Object, Serializable> hashMap = new HashMap<Object, Serializable>();
            while (object != null) {
                object5 = ((String)object).split(",");
                assert (((String[])object5).length % 2 == 1);
                object4 = object5[0];
                serializable = new ArrayList();
                for (int i = 1; i < ((String[])object5).length; i += 2) {
                    String string = object5[i].replaceAll("[^0-9]", "");
                    object3 = object5[i + 1].replaceAll("[^0-9]", "");
                    object2 = new Intpair(Long.parseLong(string), Long.parseLong((String)object3));
                    ((ArrayList)serializable).add(object2);
                }
                hashMap.put(object4, serializable);
                object = ((BufferedReader)closeable).readLine();
            }
            object5 = new ArrayList();
            object4 = new HashMap();
            serializable = symbolTable.getCategoryFirst();
            while (serializable != null) {
                String string = ((categoryentry)serializable).name;
                int n = ((categoryentry)serializable).cat;
                if (n == 3) {
                    object3 = symbolTable.getDomain(string);
                    assert (((ASTNode)object3).isFiniteSet());
                    object2 = (ArrayList<ASTNode>)hashMap.get(string);
                    ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                    for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                        Intpair intpair = (Intpair)((ArrayList)object2).get(i);
                        arrayList.add(CompoundMatrix.make(NumberConstant.make(intpair.lower), NumberConstant.make(intpair.upper)));
                    }
                    ASTNode aSTNode = CompoundMatrix.make(arrayList);
                    if (symbolTable.replaces_matrix.containsKey(string)) {
                        if (!((HashMap)object4).containsKey(symbolTable.replaces_matrix.get((Object)string).name)) {
                            ((HashMap)object4).put(symbolTable.replaces_matrix.get((Object)string).name, new HashMap());
                        }
                        ((HashMap)((HashMap)object4).get(symbolTable.replaces_matrix.get((Object)string).name)).put(symbolTable.replaces_matrix.get((Object)string).idx, aSTNode);
                    } else {
                        ((ArrayList)object5).add(new Letting((ASTNode)new Identifier(symbolTable.m, string), aSTNode));
                    }
                }
                serializable = ((categoryentry)serializable).next;
            }
            for (String string : ((HashMap)object4).keySet()) {
                object3 = symbolTable.deleted_matrices.get(string);
                object2 = ((ASTNode)object3).getChildren(3);
                boolean bl = ((ASTNode)object3).getChild(0).isBooleanSet();
                ((ArrayList)object5).add(new Letting((ASTNode)new Identifier(symbolTable.m, string), this.collectMatrix((ArrayList<ASTNode>)object2, string, new ArrayList<Long>(), (HashMap<String, HashMap<ArrayList<Long>, ASTNode>>)object4, bl)));
            }
            Solution solution = new Solution((ArrayList<ASTNode>)object5, new ArrayList<String>());
            System.out.println(solution);
        }
        catch (IOException iOException) {
            System.out.println("Could not open or parse domain store file. " + String.valueOf(iOException));
        }
    }

    void parseAllSolverSolutions(SymbolTable symbolTable, BufferedReader bufferedReader) {
        Solution solution;
        while ((solution = this.parseOneSolverSolution(symbolTable, bufferedReader)) != null) {
            this.createSolutionFile(solution, true);
            if (this.solutionCounter != CmdFlags.getFindNumSolutions()) continue;
            break;
        }
    }

    abstract Solution parseOneSolverSolution(SymbolTable var1, BufferedReader var2);

    abstract Solution parseLastSolverSolution(SymbolTable var1, BufferedReader var2);

    abstract HashMap<String, Long> readAllAssignments(ArrayList<String> var1, SymbolTable var2);

    Solution solverSolToAST(ArrayList<String> arrayList, SymbolTable symbolTable) {
        Object object;
        Object object2;
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        HashMap<String, HashMap<ArrayList<Long>, ASTNode>> hashMap = new HashMap<String, HashMap<ArrayList<Long>, ASTNode>>();
        HashMap<String, Long> hashMap2 = this.readAllAssignments(arrayList, symbolTable);
        Long l = null;
        if (symbolTable.m != null && symbolTable.m.objective != null) {
            l = hashMap2.get(symbolTable.m.objective.getChild(0).toString());
        }
        categoryentry categoryentry2 = symbolTable.getCategoryFirst();
        while (categoryentry2 != null) {
            object2 = categoryentry2.name;
            int n = categoryentry2.cat;
            if (n == 3) {
                long l2;
                object = symbolTable.getDomain((String)object2);
                assert (((ASTNode)object).isFiniteSet());
                if (hashMap2.containsKey(object2)) {
                    l2 = hashMap2.get(object2);
                } else if (hashMap2.containsKey(object2 + "_INTEGER")) {
                    l2 = hashMap2.get(object2 + "_INTEGER");
                } else if (hashMap2.containsKey(object2 + "_BOOL")) {
                    l2 = hashMap2.get((String)object2 + "_BOOL");
                } else if (CmdFlags.getSattrans()) {
                    l2 = ((ASTNode)object).getBounds().lower;
                } else {
                    return null;
                }
                if (symbolTable.replaces_matrix.containsKey(object2)) {
                    if (!hashMap.containsKey(symbolTable.replaces_matrix.get((Object)object2).name)) {
                        hashMap.put(symbolTable.replaces_matrix.get((Object)object2).name, new HashMap());
                    }
                    if (((ASTNode)object).isBooleanSet()) {
                        ((HashMap)hashMap.get(symbolTable.replaces_matrix.get((Object)object2).name)).put(symbolTable.replaces_matrix.get((Object)object2).idx, new BooleanConstant(l2 != 0L));
                    } else {
                        ((HashMap)hashMap.get(symbolTable.replaces_matrix.get((Object)object2).name)).put(symbolTable.replaces_matrix.get((Object)object2).idx, NumberConstant.make(l2));
                    }
                } else if (((ASTNode)object).isBooleanSet()) {
                    arrayList2.add(new Letting((ASTNode)new Identifier(symbolTable.m, (String)object2), new BooleanConstant(l2 != 0L)));
                } else {
                    arrayList2.add(new Letting((ASTNode)new Identifier(symbolTable.m, (String)object2), NumberConstant.make(l2)));
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        for (ASTNode aSTNode : symbolTable.replacements.keySet()) {
            object = aSTNode.toString();
            if (symbolTable.replacements_category.get(aSTNode) != 3) continue;
            ASTNode aSTNode2 = symbolTable.replacements.get(aSTNode);
            ASTNode aSTNode3 = symbolTable.replacements_domains.get(aSTNode);
            long l3 = this.readReplacementValue(aSTNode2, hashMap2, symbolTable.replacements);
            hashMap2.put((String)object, l3);
            if (symbolTable.replaces_matrix.containsKey(object)) {
                if (!hashMap.containsKey(symbolTable.replaces_matrix.get((Object)object).name)) {
                    hashMap.put(symbolTable.replaces_matrix.get((Object)object).name, new HashMap());
                }
                if (aSTNode3.isBooleanSet()) {
                    hashMap.get(symbolTable.replaces_matrix.get((Object)object).name).put(symbolTable.replaces_matrix.get((Object)object).idx, new BooleanConstant(l3 != 0L));
                    continue;
                }
                hashMap.get(symbolTable.replaces_matrix.get((Object)object).name).put(symbolTable.replaces_matrix.get((Object)object).idx, NumberConstant.make(l3));
                continue;
            }
            if (aSTNode3.isBooleanSet()) {
                arrayList2.add(new Letting((ASTNode)new Identifier(symbolTable.m, (String)object), new BooleanConstant(l3 != 0L)));
                continue;
            }
            arrayList2.add(new Letting((ASTNode)new Identifier(symbolTable.m, (String)object), NumberConstant.make(l3)));
        }
        for (String string : hashMap.keySet()) {
            object = symbolTable.deleted_matrices.get(string);
            ArrayList<ASTNode> arrayList3 = ((ASTNode)object).getChildren(3);
            boolean bl = ((ASTNode)object).getChild(0).isBooleanSet();
            arrayList2.add(new Letting((ASTNode)new Identifier(symbolTable.m, string), this.collectMatrix(arrayList3, string, new ArrayList<Long>(), hashMap, bl)));
        }
        for (String string : symbolTable.deleted_matrices.keySet()) {
            if (hashMap.keySet().contains(string)) continue;
            object = new EmptyMatrix(symbolTable.deleted_matrices.get(string));
            ASTNode aSTNode = new TransformSimplify().transform((ASTNode)object);
            arrayList2.add(new Letting((ASTNode)new Identifier(symbolTable.m, string), aSTNode));
        }
        class Cmplettings
        implements Comparator<ASTNode> {
            Cmplettings() {
            }

            @Override
            public int compare(ASTNode aSTNode, ASTNode aSTNode2) {
                return aSTNode.getChild(0).toString().compareTo(aSTNode2.getChild(0).toString());
            }
        }
        object2 = new Cmplettings();
        Collections.sort(arrayList2, object2);
        if (l == null) {
            return new Solution(arrayList2, new ArrayList<String>());
        }
        return new Solution(arrayList2, new ArrayList<String>(), l);
    }

    private long readReplacementValue(ASTNode aSTNode, HashMap<String, Long> hashMap, HashMap<ASTNode, ASTNode> hashMap2) {
        while (hashMap2.get(aSTNode) != null) {
            aSTNode = hashMap2.get(aSTNode);
        }
        if (aSTNode.isConstant()) {
            return aSTNode.getValue();
        }
        if (aSTNode instanceof Identifier) {
            if (hashMap.containsKey(aSTNode.toString())) {
                return hashMap.get(aSTNode.toString());
            }
            if (hashMap.containsKey(aSTNode.toString() + "_INTEGER")) {
                return hashMap.get(aSTNode.toString() + "_INTEGER");
            }
            return hashMap.get(aSTNode.toString() + "_BOOL");
        }
        if (aSTNode instanceof Negate) {
            return 1L - this.readReplacementValue(aSTNode.getChild(0), hashMap, hashMap2);
        }
        ASTNode aSTNode2 = aSTNode.copy();
        this.replaceIds(aSTNode2, hashMap, hashMap2);
        TransformSimplify transformSimplify = new TransformSimplify();
        aSTNode2 = transformSimplify.transform(aSTNode2);
        assert (aSTNode2.isConstant());
        return aSTNode2.getValue();
    }

    private void replaceIds(ASTNode aSTNode, HashMap<String, Long> hashMap, HashMap<ASTNode, ASTNode> hashMap2) {
        if (aSTNode instanceof Identifier) {
            if (hashMap2.containsKey(aSTNode)) {
                aSTNode.getParent().setChild(aSTNode.getChildNo(), hashMap2.get(aSTNode));
                aSTNode = aSTNode.getParent().getChild(aSTNode.getChildNo());
                this.replaceIds(aSTNode, hashMap, hashMap2);
            } else {
                aSTNode.getParent().setChild(aSTNode.getChildNo(), NumberConstant.make(hashMap.get(aSTNode.toString())));
            }
        } else {
            for (int i = 0; i < aSTNode.numChildren(); ++i) {
                this.replaceIds(aSTNode.getChild(i), hashMap, hashMap2);
            }
        }
    }

    private ASTNode collectMatrix(ArrayList<ASTNode> arrayList, String string, ArrayList<Long> arrayList2, HashMap<String, HashMap<ArrayList<Long>, ASTNode>> hashMap, boolean bl) {
        if (arrayList.size() == 0) {
            if (hashMap.get(string).containsKey(arrayList2)) {
                return hashMap.get(string).get(arrayList2);
            }
            return new NoValue();
        }
        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>(arrayList);
        ASTNode aSTNode = arrayList3.remove(0);
        ArrayList<Intpair> arrayList4 = aSTNode.getIntervalSet();
        ArrayList<ASTNode> arrayList5 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList4.size(); ++i) {
            for (long j = arrayList4.get((int)i).lower; j <= arrayList4.get((int)i).upper; ++j) {
                arrayList2.add(j);
                arrayList5.add(this.collectMatrix(arrayList3, string, arrayList2, hashMap, bl));
                arrayList2.remove(arrayList2.size() - 1);
            }
        }
        if (arrayList5.size() > 0) {
            return new CompoundMatrix(aSTNode, arrayList5);
        }
        if (bl) {
            return new EmptyMatrix(new MatrixDomain((ASTNode)new BooleanDomainFull(), arrayList));
        }
        return new EmptyMatrix(new MatrixDomain((ASTNode)new IntegerDomain(new EmptyRange()), arrayList));
    }

    void createSolutionFile(ASTNode aSTNode, boolean bl) {
        Object object;
        Object object2;
        if (bl) {
            object2 = String.format("%0" + this.numdigits + "d", this.solutionCounter + 1L);
            ++this.solutionCounter;
            object = CmdFlags.solutionfile + "." + (String)object2;
        } else {
            object = CmdFlags.solutionfile;
        }
        if (CmdFlags.dominanceRelation) {
            if (DominanceRelation.sollist == null) {
                DominanceRelation.sollist = new ArrayList();
            }
            DominanceRelation.sollist.add(aSTNode);
        }
        if (!CmdFlags.getSolutionsToNull()) {
            if (CmdFlags.getSolutionsToStdout()) {
                System.out.println(aSTNode.toString());
                System.out.println("----------");
            } else if (CmdFlags.getSolutionsToStdoutOneLine()) {
                System.out.println("Solution: " + ((Solution)aSTNode).toStringOneLine().replaceAll("[\\t\\n\\r]", " "));
            } else {
                try {
                    object2 = new BufferedWriter(new FileWriter((String)object));
                    ((Writer)object2).write(aSTNode.toString());
                    ((BufferedWriter)object2).close();
                    CmdFlags.println("Created solution file " + (String)object);
                }
                catch (IOException iOException) {
                    CmdFlags.println("Could not open file for solution output.");
                }
            }
        }
    }

    void checkSolution(HashMap<String, Long> hashMap) {
        Model model = CmdFlags.checkSolModel;
        assert (model.constraints instanceof Top);
        ArrayList<ASTNode> arrayList = model.constraints.getChild(0) instanceof And ? model.constraints.getChild(0).getChildren() : model.constraints.getChildren();
        SubstituteAllValues substituteAllValues = new SubstituteAllValues(hashMap);
        TransformSimplify transformSimplify = new TransformSimplify();
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i).copy();
            aSTNode = transformSimplify.transform(aSTNode);
            aSTNode = ((TreeTransformer)substituteAllValues).transform(aSTNode);
            if ((aSTNode = transformSimplify.transform(aSTNode)) instanceof BooleanConstant && aSTNode.getValue() == 1L) continue;
            System.out.println(hashMap);
            CmdFlags.errorExit("When checking constraint: " + String.valueOf(arrayList.get(i)), "Constraint not satisfied by solver solution.", "Evaluation is:" + String.valueOf(aSTNode));
        }
    }
}

