/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Intpair;

public class ElementOne
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ElementOne(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ElementOne(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        if (this.isNumerical()) {
            return true;
        }
        return super.toFlatten(bl);
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        if (aSTNode instanceof CompoundMatrix) {
            if (this.getChild(1).isConstant()) {
                long l = this.getChild(1).getValue();
                if (l < 1L || l >= (long)aSTNode.numChildren()) {
                    return null;
                }
                ASTNode aSTNode2 = aSTNode.getChild((int)l);
                if (aSTNode == this.getChild(0)) {
                    aSTNode2.setParent(null);
                }
                return aSTNode2;
            }
            Intpair intpair = this.getChild(1).getBounds();
            int n = aSTNode.numChildren() - 1;
            if (intpair.upper < (long)n) {
                ArrayList<ASTNode> arrayList = ElementOne.list();
                if (aSTNode == this.getChild(0)) {
                    aSTNode.detachChildren();
                }
                this.getChild(1).setParent(null);
                int n2 = 1;
                while ((long)n2 <= intpair.upper) {
                    arrayList.add(aSTNode.getChild(n2));
                    ++n2;
                }
                return new ElementOne(CompoundMatrix.make(arrayList), this.getChild(1));
            }
        }
        return null;
    }

    @Override
    public int polarity(int n) {
        if (n == 0) {
            return this.polarity();
        }
        return 0;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        return this.getChild(0).getIntervalSetExp();
    }

    @Override
    public void toFlatzincWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("constraint array_var_int_element(");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint array_var_bool_element(");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(0).toFlatzinc(bufferedWriter, true);
        bufferedWriter.append(", ");
        bufferedWriter.append("true");
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append("[");
        this.getChild(1).toMinizinc(stringBuilder, bl);
        stringBuilder.append("])");
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        assert (this.isRelation());
        this.toMinionWithAuxVar(bufferedWriter, new BooleanConstant(true));
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        if (CmdFlags.getUseBoundVars() && (aSTNode.exceedsBoundThreshold() || this.getChild(0).exceedsBoundThreshold() || this.getChild(1).exceedsBoundThreshold())) {
            bufferedWriter.append("element_one(");
        } else {
            bufferedWriter.append("watchelement_one(");
        }
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }
}

