/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.ASTNodeC;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;
import savilerow.model.SymbolTable;

public class Length
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Length(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Length(this.getChild(0));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            System.out.println("ERROR: Length must contain a one-dimensional matrix:" + String.valueOf(this));
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(0L, Long.MAX_VALUE);
    }

    public PairASTNode getBoundsAST() {
        return new PairASTNode(NumberConstant.make(0L), new PosInfinity());
    }

    @Override
    public ASTNode simplify() {
        ArrayList<ASTNode> arrayList = this.getChild(0).getIndexDomains();
        if (arrayList == null) {
            return null;
        }
        assert (arrayList.size() == 1);
        ArrayList<Intpair> arrayList2 = arrayList.get(0).getIntervalSet();
        long l = Intpair.numValues(arrayList2);
        return NumberConstant.make(l);
    }

    @Override
    public String toString() {
        return "length(" + String.valueOf(this.getChild(0)) + ")";
    }
}

