/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import savilerow.Pair;
import savilerow.expression.Solution;
import savilerow.model.Model;
import savilerow.solver.InteractiveAllMinisatStats;
import savilerow.solver.InteractiveSATSolver;
import savilerow.solver.Stats;

public class InteractiveAllMinisatSATSolver
extends InteractiveSATSolver {
    private long nativeSolverPointer;

    public InteractiveAllMinisatSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) {
        this.finaliseAssumptions();
        InteractiveAllMinisatSATSolver.addAssumptionsToSolver(this.nativeSolverPointer, Arrays.stream(this.assumptions).mapToInt(l -> (int)l).toArray());
        double d = System.currentTimeMillis();
        InteractiveAllMinisatSATSolver.runSolver(this.nativeSolverPointer, this);
        d = ((double)System.currentTimeMillis() - d) / 1000.0;
        double[] dArray = InteractiveAllMinisatSATSolver.getSolverStats(this.nativeSolverPointer);
        dArray[1] = d;
        InteractiveAllMinisatStats interactiveAllMinisatStats = new InteractiveAllMinisatStats(dArray);
        interactiveAllMinisatStats.setNbLearnts(this.getNbLearntClausesFromISATSolver());
        this.writeToFileSolutionStats(interactiveAllMinisatStats);
        return null;
    }

    @Override
    public void findOneSolution(String string, String string2, Model model) {
        InteractiveAllMinisatSATSolver.setNbSolutions(this.nativeSolverPointer, 1L);
        this.runSatSolver(string, string2, model, null);
        this.cleanAssumptionQueue();
    }

    @Override
    public void findMultipleSolutions(String string, String string2, Model model) {
        this.runSatSolver(string, string2, model, null);
        this.cleanAssumptionQueue();
    }

    private static native long initSolver();

    private static native long addClauseToSolver(long var0, int[] var2);

    private static native long setNbSolutions(long var0, long var2);

    private static native long addAssumptionsToSolver(long var0, int[] var2);

    private static native long runSolver(long var0, InteractiveSATSolver var2);

    private static native double[] getSolverStats(long var0);

    private static native long setRndSeed(long var0, long var2);

    private static native long getNbLearntClauses(long var0);

    @Override
    protected void initISATSolver() {
        this.nativeSolverPointer = InteractiveAllMinisatSATSolver.initSolver();
        assert (this.nativeSolverPointer != 0L);
    }

    @Override
    public void setRndSeedToISATSolver(long l) {
        InteractiveAllMinisatSATSolver.setRndSeed(this.nativeSolverPointer, l);
    }

    @Override
    public void addClauseToISATSolver(long[] lArray) {
        InteractiveAllMinisatSATSolver.addClauseToSolver(this.nativeSolverPointer, Arrays.stream(lArray).mapToInt(l -> (int)l).toArray());
    }

    @Override
    public long getNbLearntClausesFromISATSolver() {
        return InteractiveAllMinisatSATSolver.getNbLearntClauses(this.nativeSolverPointer);
    }

    @Override
    protected void handleFreshSolution(int[] nArray) {
        ArrayList arrayList = Arrays.stream(nArray).mapToObj(Integer::toString).collect(Collectors.toCollection(ArrayList::new));
        Solution solution = this.solverSolToAST(arrayList, this.m.global_symbols);
        this.createSolutionFile(solution, true);
    }

    static {
        System.loadLibrary("rust_jni_solvers");
    }
}

