/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.MultiplyMapper;
import savilerow.expression.NumberConstant;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class PB
extends Sat {
    protected int rhsval = 1;
    BufferedWriter realfile = null;
    CharArrayWriter buffer = null;

    public PB(SymbolTable symbolTable) {
        super(symbolTable);
    }

    @Override
    protected void writeLiteral(long l) throws IOException {
        if (l < 0L) {
            this.outstream.write("-1 x" + -l + " ");
            --this.rhsval;
        } else {
            this.outstream.write("+1 x" + l + " ");
        }
    }

    @Override
    protected void clauseStart() throws IOException {
        this.rhsval = 1;
        super.clauseStart();
    }

    @Override
    protected void clauseEnd() throws IOException {
        this.outstream.write(">= " + this.rhsval + ";");
        this.outstream.newLine();
    }

    @Override
    public void addComment(String string) throws IOException {
        this.outstream.write("* ");
        this.outstream.write(string);
        this.outstream.newLine();
    }

    @Override
    public void finaliseOutput() throws IOException {
        this.outstream.flush();
        this.fw.getFD().sync();
        this.outstream.close();
        RandomAccessFile randomAccessFile = new RandomAccessFile(CmdFlags.pbfile, "rws");
        randomAccessFile.seek(0L);
        byte[] byArray = ("* #variable= " + (this.variableNumber - 1L) + " #constraint= " + this.numClauses).getBytes();
        randomAccessFile.write(byArray);
        randomAccessFile.write("          ".getBytes());
        randomAccessFile.close();
    }

    public long normaliseConstraint(ArrayList<Long> arrayList, ArrayList<Long> arrayList2, long l) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList2.get(i) >= 0L) continue;
            l -= arrayList.get(i).longValue();
            arrayList.set(i, -arrayList.get(i).longValue());
            arrayList2.set(i, -arrayList2.get(i).longValue());
        }
        return l;
    }

    public void addConstraint(ArrayList<Long> arrayList, ArrayList<Long> arrayList2, int n, long l) throws IOException {
        l = this.addExpression(arrayList, arrayList2, l);
        if (n == -1) {
            this.outstream.write("<= ");
        } else if (n == 0) {
            this.outstream.write("= ");
        } else {
            this.outstream.write(">= ");
        }
        this.outstream.write(String.valueOf(l));
        this.outstream.write(";\n");
    }

    public long addExpression(ArrayList<Long> arrayList, ArrayList<Long> arrayList2, long l) throws IOException {
        l = this.normaliseConstraint(arrayList, arrayList2, l);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) > 0L) {
                this.outstream.write("+" + String.valueOf(arrayList.get(i)) + " x" + String.valueOf(arrayList2.get(i)) + " ");
            }
            if (arrayList.get(i) >= 0L) continue;
            this.outstream.write(String.valueOf(arrayList.get(i)) + " x" + String.valueOf(arrayList2.get(i)) + " ");
        }
        return l;
    }

    public void write(String string) throws IOException {
        this.outstream.write(string);
    }

    public long encodeIntegerTerm(ASTNode aSTNode, long l, ArrayList<Long> arrayList, ArrayList<Long> arrayList2, long l2) {
        if (l != 1L) {
            aSTNode = new MultiplyMapper(aSTNode, NumberConstant.make(l));
        }
        System.out.println(aSTNode);
        ArrayList<Intpair> arrayList3 = aSTNode.getIntervalSetExp();
        l2 -= arrayList3.get((int)0).lower;
        long l3 = Long.MIN_VALUE;
        for (int i = 0; i < arrayList3.size(); ++i) {
            long l4 = arrayList3.get((int)i).lower;
            while (l4 <= arrayList3.get((int)i).upper) {
                if (l3 > Long.MIN_VALUE) {
                    long l5 = -aSTNode.orderEncode(this, l3);
                    arrayList.add(l4 - l3);
                    arrayList2.add(l5);
                }
                l3 = l4++;
            }
        }
        return l2;
    }

    public void bufferConstraints() throws IOException {
        this.realfile = this.outstream;
        this.buffer = new CharArrayWriter();
        this.outstream = new BufferedWriter(this.buffer);
    }

    public void deactivateBufferConstraints() throws IOException {
        this.outstream.flush();
        this.outstream = this.realfile;
        this.realfile = null;
    }

    public void unbufferConstraints() throws IOException {
        this.outstream.write(this.buffer.toString());
        this.buffer = null;
    }
}

