/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import savilerow.expression.ASTNode;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TreeTransformer;

public abstract class TreeTransformerTopdown
extends TreeTransformer {
    Model m;

    TreeTransformerTopdown(Model model) {
        this.m = model;
    }

    @Override
    public ASTNode transform(ASTNode aSTNode) {
        this.changedTree = false;
        return this.transform_root(aSTNode);
    }

    public ASTNode transform_root(ASTNode aSTNode) {
        NodeReplacement nodeReplacement = this.processNode(aSTNode);
        if (nodeReplacement != null) {
            assert (nodeReplacement.rel_context == null && nodeReplacement.new_constraint == null);
            this.changedTree = true;
            return this.transform_root(nodeReplacement.current_node);
        }
        return this.transform_inner(aSTNode);
    }

    public ASTNode transform_inner(ASTNode aSTNode) {
        this.transform_children(aSTNode);
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            this.transform_inner(aSTNode.getChild(i));
        }
        return aSTNode;
    }

    public void transform_children(ASTNode aSTNode) {
        for (int i = 0; i < aSTNode.numChildren(); ++i) {
            NodeReplacement nodeReplacement = this.processNode(aSTNode.getChild(i));
            if (nodeReplacement == null) continue;
            assert (nodeReplacement.rel_context == null && nodeReplacement.new_constraint == null);
            this.changedTree = true;
            aSTNode.setChild(i, nodeReplacement.current_node);
            --i;
        }
    }
}

