/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import savilerow.CmdFlags;
import savilerow.eprimeparser.EPrimeReader;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.NumberConstant;
import savilerow.model.Model;
import savilerow.model.ModelContainer;
import savilerow.model.SymbolTable;
import savilerow.solver.MinionSolver;
import savilerow.solver.Solver;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformMakeSafe;
import savilerow.treetransformer.TransformQuantifiedExpression;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerBottomUp;

public final class SRWorkThread
extends Thread {
    @Override
    public void run() {
        Object object;
        Object object2;
        Object object3;
        if (CmdFlags.getMode() == 2 || CmdFlags.getMode() == 3) {
            object3 = new MinionSolver();
            if (CmdFlags.getMode() == 2) {
                ((Solver)object3).parseSolutionMode();
            } else {
                ((Solver)object3).parseDomainStore();
            }
            System.exit(0);
        }
        if (!CmdFlags.param_to_json) {
            object2 = new EPrimeReader(CmdFlags.eprimefile, true);
            object3 = ((EPrimeReader)object2).readModel();
            assert (((Model)object3).constraints != null);
        } else {
            object3 = new Model();
            ((Model)object3).global_symbols = new SymbolTable();
        }
        object2 = new ArrayList();
        if (CmdFlags.paramfile != null) {
            object = new EPrimeReader(CmdFlags.paramfile, true);
            ((ArrayList)object2).addAll(((EPrimeReader)object).readParameterFile((Model)object3));
        }
        if (CmdFlags.paramstring != null) {
            object = new EPrimeReader(CmdFlags.paramstring, false);
            ((ArrayList)object2).addAll(((EPrimeReader)object).readParameterFile((Model)object3));
        }
        object = new ModelContainer((Model)object3, new ArrayList<ASTNode>((Collection<ASTNode>)object2));
        if (CmdFlags.param_to_json) {
            this.paramToJSON((ArrayList<ASTNode>)object2, (Model)object3);
            System.exit(0);
        }
        if (CmdFlags.dump_model) {
            System.out.println(((ModelContainer)object).m.dumpToString());
            System.exit(0);
        }
        if (CmdFlags.dryruns) {
            int n = 1000;
            for (int i = 3; i > 0 && System.currentTimeMillis() - CmdFlags.startTime < (long)n; --i) {
                ModelContainer modelContainer = ((ModelContainer)object).copy();
                modelContainer.dryrun();
            }
        }
        CmdFlags.startTime = System.currentTimeMillis();
        if (CmdFlags.dump_json_model) {
            // empty if block
        }
        ((ModelContainer)object).process();
        System.exit(0);
    }

    public void paramToJSON(ArrayList<ASTNode> arrayList, Model model) {
        TransformSimplify transformSimplify;
        Object object;
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i);
            object = new TransformMakeSafe(model);
            aSTNode = ((TreeTransformerBottomUp)object).transform(aSTNode);
            transformSimplify = new TransformSimplify();
            aSTNode = transformSimplify.transform(aSTNode);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(model);
            aSTNode = transformQuantifiedExpression.transform(aSTNode);
            aSTNode = transformSimplify.transform(aSTNode);
            arrayList.set(i, aSTNode);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode.getChild(0), aSTNode.getChild(1));
            for (int j = i + 1; j < arrayList.size(); ++j) {
                arrayList.get(j).setChild(1, replaceASTNode.transform(arrayList.get(j).getChild(1)));
            }
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.paramfile + ".json"));
            bufferedWriter.write("{\n");
            for (int i = 0; i < arrayList.size(); ++i) {
                bufferedWriter.write("\"");
                bufferedWriter.write(arrayList.get(i).getChild(0).toString());
                bufferedWriter.write("\" : ");
                object = arrayList.get(i).getChild(1);
                transformSimplify = new TransformSimplify();
                object = transformSimplify.transform((ASTNode)object);
                if (object instanceof BooleanConstant || object instanceof NumberConstant) {
                    bufferedWriter.write(((ASTNode)object).toString());
                } else if (object instanceof EmptyMatrix) {
                    bufferedWriter.write("[ ]");
                } else {
                    bufferedWriter.write(((CompoundMatrix)object).toStringSimpleMatrix());
                }
                if (i < arrayList.size() - 1) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("}\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

