package savilerow.treetransformer;
/*

    Savile Row http://savilerow.cs.st-andrews.ac.uk/
    Copyright (C) 2014-2024 Peter Nightingale and Luke Ryan
    
    This file is part of Savile Row.
    
    Savile Row is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Savile Row is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Savile Row.  If not, see <http://www.gnu.org/licenses/>.

*/

import java.util.ArrayList;

import savilerow.CmdFlags;
import savilerow.expression.*;

public class TransformDecomposeDiffN extends TreeTransformerBottomUpNoWrapper
{
    private boolean propagate;
    
    public TransformDecomposeDiffN(boolean _propagate) { 
        super(null);
        propagate = _propagate;
    }
    
    protected NodeReplacement processNode(ASTNode curnode)
    {
        if(curnode instanceof DiffN) {
            boolean backendHasDiffN=(CmdFlags.getOrtoolstrans() || CmdFlags.getChocotrans() || CmdFlags.getGecodetrans() || CmdFlags.getMinizinctrans()) && !propagate;
            
            if(!backendHasDiffN || !curnode.getParent().inTopAnd()) {
                return new NodeReplacement(decomp(curnode));
            }
        }
        return null;
    }
    
    private static ASTNode decomp(ASTNode curnode) {
        ASTNode x = curnode.getChildConst(0);
        ASTNode y = curnode.getChildConst(1);
        ASTNode dx = curnode.getChildConst(2);
        ASTNode dy = curnode.getChildConst(3);
        
        ArrayList<ASTNode> nonOverlapCts=new ArrayList<>();
        
        for(int i=1; i<x.numChildren(); i++) {
            for(int j=i+1; j<x.numChildren(); j++) {
                ArrayList<ASTNode> or=new ArrayList<>(4);
                
                or.add(new LessEqual(new WeightedSum(x.getChild(i), dx.getChild(i)), x.getChild(j)));
                or.add(new LessEqual(new WeightedSum(x.getChild(j), dx.getChild(j)), x.getChild(i)));
                or.add(new LessEqual(new WeightedSum(y.getChild(i), dy.getChild(i)), y.getChild(j)));
                or.add(new LessEqual(new WeightedSum(y.getChild(j), dy.getChild(j)), y.getChild(i)));
                
                nonOverlapCts.add(new Or(or));
            }
        }
        return new And(nonOverlapCts);
    }
    
}
