/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.CSETransform;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.Times;

public class CSETransformTimes
extends CSETransform {
    long num;

    public CSETransformTimes(long l) {
        this.num = l;
    }

    @Override
    public boolean applicable(ASTNode aSTNode) {
        return true;
    }

    @Override
    public ASTNode transform(ASTNode aSTNode) {
        return new Times(new NumberConstant(this.num), aSTNode);
    }

    long product_saturate(long l) {
        long l2 = l * this.num;
        if (l2 / this.num != l) {
            if (l < 0L != this.num < 0L) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
        return l2;
    }

    @Override
    public ASTNode inverse_transform_domain(ASTNode aSTNode) {
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
        ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            if (this.num < 0L) {
                long l = this.product_saturate(intpair.lower);
                intpair.lower = this.product_saturate(intpair.upper);
                intpair.upper = l;
            } else {
                intpair.upper = this.product_saturate(intpair.upper);
                intpair.lower = this.product_saturate(intpair.lower);
            }
            if (this.num < 0L) {
                arrayList2.set(arrayList.size() - i - 1, intpair);
                continue;
            }
            arrayList2.set(i, intpair);
        }
        return Intpair.makeDomain(arrayList2, false);
    }
}

