/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import savilerow.CmdFlags;
import savilerow.Permutation;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.LexLessEqual;
import savilerow.model.Model;
import savilerow.model.SymbolTable;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;

public class SymmetryBreaker {
    public boolean detectAndBreakSymmetries(Model model) {
        try {
            String string = this.writeModelAsJSON(model);
            CmdFlags.println("Created output file " + string);
            ArrayList<Permutation> arrayList = this.getSymmetries(string);
            this.addConstraints(model, arrayList);
            return true;
        }
        catch (IOException iOException) {
            System.err.println("Error in symmetry breaker.");
            iOException.printStackTrace();
            return false;
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error in symmetry breaker.");
            interruptedException.printStackTrace();
            return false;
        }
    }

    public String writeModelAsJSON(Model model) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n\"symmetricChildren\":true,\n");
        stringBuilder.append("\"nodes_to_swap\":");
        model.global_symbols.writeVarListAsJSON(stringBuilder);
        stringBuilder.append(",\n");
        stringBuilder.append("\"variableDomains\":");
        model.global_symbols.writeVarDomainsAsJSON(stringBuilder);
        stringBuilder.append(",\n");
        stringBuilder.append("\"constraints\": ");
        model.constraints.toJSON(stringBuilder);
        if (model.objective != null) {
            stringBuilder.append(",\n");
            stringBuilder.append("\"objective\":");
            model.objective.toJSON(stringBuilder);
        }
        stringBuilder.append("\n}");
        String string = CmdFlags.minionfile;
        if (string.endsWith(".minion")) {
            string = string.substring(0, string.lastIndexOf(".minion"));
        }
        File file = new File(string + ".json");
        file.createNewFile();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println(stringBuilder.toString());
        printWriter.close();
        return file.getPath();
    }

    private void addConstraints(Model model, ArrayList<Permutation> arrayList) {
        Permutation.setOrdering(this.buildBranchOrderingList(model));
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(model.constraints.getChild(0));
        for (Permutation permutation : arrayList) {
            ASTNode aSTNode = CompoundMatrix.makeCompoundMatrix(this.toIdentifierList(Permutation.getOrdering(), model));
            ASTNode aSTNode2 = CompoundMatrix.makeCompoundMatrix(this.toIdentifierList(permutation.permutate(), model));
            arrayList2.add(new LexLessEqual(aSTNode, aSTNode2));
        }
        And and = new And(arrayList2);
        model.constraints.setChild(0, and);
    }

    private ArrayList<ASTNode> toIdentifierList(ArrayList<String> arrayList, Model model) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (String string : arrayList) {
            arrayList2.add(new Identifier(string, model.global_symbols));
        }
        return arrayList2;
    }

    public Collection<String> buildBranchOrderingList(Model model) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int i = 1; i < model.branchingon.numChildren(); ++i) {
            linkedHashSet.add(((Identifier)model.branchingon.getChild(i)).getName());
        }
        linkedHashSet.addAll(model.global_symbols.getVarNamesList());
        return linkedHashSet;
    }

    private ArrayList<Permutation> getSymmetries(String string) throws IOException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("symmetry_detect");
        arrayList2.add("--json");
        arrayList2.add(string);
        RunCommand.runCommand(arrayList2, new ArrayList<String>(), readProcessOutput);
        return this.parseSymmetries(this.buildString(arrayList));
    }

    private ArrayList<Permutation> parseSymmetries(String string) {
        ArrayList<Permutation> arrayList = new ArrayList<Permutation>();
        Pattern pattern = Pattern.compile("\\{([^}]*)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1).trim();
            Permutation permutation = this.makePermutation(string2);
            arrayList.add(permutation);
        }
        return arrayList;
    }

    private Permutation makePermutation(String string) {
        try {
            String[] stringArray;
            Permutation permutation = new Permutation();
            for (String string2 : stringArray = string.split(",\\s*")) {
                String[] stringArray2 = string2.split(":");
                String string3 = stringArray2[0].replaceAll("\"", "");
                String string4 = stringArray2[1].replaceAll("\"", "");
                permutation.addMapping(SymbolTable.unescapeVar(string3), SymbolTable.unescapeVar(string4));
            }
            return permutation;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException("Error in json syntax\n" + string);
        }
    }

    private String buildString(ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            stringBuilder.append(string + "\n");
        }
        return stringBuilder.toString();
    }
}

