/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanDomain;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDomain;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.expression.SimpleDomain;
import savilerow.model.SymbolTable;

public class CompoundMatrix
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public CompoundMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(aSTNode);
        arrayList2.addAll(arrayList);
        this.setChildren(arrayList2);
        assert (arrayList.size() > 0);
    }

    public CompoundMatrix(ArrayList<ASTNode> arrayList) {
        IntegerDomain integerDomain = new IntegerDomain(new Range(new NumberConstant(1L), new NumberConstant(arrayList.size())));
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(integerDomain);
        arrayList2.addAll(arrayList);
        this.setChildren(arrayList2);
        assert (arrayList.size() > 0);
    }

    public static ASTNode makeCompoundMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList, boolean bl) {
        if (arrayList.size() > 0) {
            return new CompoundMatrix(aSTNode, arrayList);
        }
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(aSTNode);
        SimpleDomain simpleDomain = bl ? new BooleanDomain(new EmptyRange()) : new IntegerDomain(new EmptyRange());
        return new EmptyMatrix(new MatrixDomain((ASTNode)simpleDomain, arrayList2));
    }

    public static ASTNode makeCompoundMatrix(ArrayList<ASTNode> arrayList) {
        if (arrayList.size() == 0) {
            return CompoundMatrix.makeCompoundMatrix(new IntegerDomain(new EmptyRange()), arrayList, false);
        }
        return CompoundMatrix.makeCompoundMatrix(new IntegerDomain(new Range(new NumberConstant(1L), new NumberConstant(arrayList.size()))), arrayList, false);
    }

    public static ASTNode makeCompoundMatrix(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        return new CompoundMatrix(arrayList);
    }

    public static ASTNode makeCompoundMatrix(ASTNode aSTNode, ASTNode aSTNode2) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        arrayList.add(aSTNode2);
        return new CompoundMatrix(arrayList);
    }

    @Override
    public boolean isRelation() {
        boolean bl = true;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).isRelation()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public boolean isNumerical() {
        boolean bl = false;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (!this.getChild(i).isNumerical()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean isSet() {
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).isSet()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASTNode copy() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        arrayList.remove(0);
        return new CompoundMatrix(this.getChild(0), arrayList);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(1).getBounds();
        for (int i = 2; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            if (intpair2.lower < intpair.lower) {
                intpair.lower = intpair2.lower;
            }
            if (intpair2.upper <= intpair.upper) continue;
            intpair.upper = intpair2.upper;
        }
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 1; i < this.numChildren(); ++i) {
            PairASTNode pairASTNode = this.getChild(i).getBoundsAST();
            arrayList.add(pairASTNode.e1);
            arrayList2.add(pairASTNode.e2);
        }
        return new PairASTNode(new Min(arrayList), new Max(arrayList2));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < this.numChildren(); ++n) {
            if (this.getChild(n).typecheck(symbolTable)) continue;
            return false;
        }
        n = this.getChild(1).getDimension();
        for (int i = 2; i < this.numChildren(); ++i) {
            if (this.getChild(i).getDimension() == n) continue;
            System.out.println("ERROR: In matrix literal: " + this);
            System.out.println("ERROR: Elements in matrix literal have different numbers of dimensions.");
            return false;
        }
        if (!this.getChild(0).isFiniteSet()) {
            System.out.println("ERROR: In matrix literal: " + this);
            System.out.println("ERROR: Index set is not a finite set.");
            return false;
        }
        return true;
    }

    @Override
    public int getDimension() {
        if (this.numChildren() == 1) {
            assert (false) : "CompoundMatrix type must have non-zero size.";
            return 1;
        }
        return 1 + this.getChild(1).getDimension();
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        assert (this.numChildren() >= 2);
        ArrayList<ASTNode> arrayList = this.getChild(1).getIndexDomains();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(0, this.getChild(0));
        return arrayList;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i).toString());
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
            if (!(this.getChild(i) instanceof CompoundMatrix) && !(this.getChild(i) instanceof EmptyMatrix)) continue;
            stringBuilder.append("\n");
        }
        stringBuilder.append(";");
        stringBuilder.append(this.getChild(0).toString());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(stringBuilder, bl);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, bl);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Domain\":");
        this.getChild(0).toJSON(stringBuilder);
        stringBuilder.append(",\n");
        stringBuilder.append("\"Children\": [");
        int n = this.numChildren();
        for (int i = 1; i < this.numChildren(); ++i) {
            stringBuilder.append("\n");
            this.getChild(i).toJSON(stringBuilder);
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return this.getParent().isChildSymmetric(this.getChildNo());
    }
}

